/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.exceptions.KafkaException;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.KafkaTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;

@Stateless
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class HopsKafkaAdminClient {
    private static final Logger LOG = Logger.getLogger(HopsKafkaAdminClient.class.getName());
    @EJB
    private BaseHadoopClientsService baseHadoopService;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    private AdminClient initClient() throws ServiceDiscoveryException {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", this.serviceDiscoveryController.constructServiceFQDNWithPort(HopsworksService.KAFKA.getNameWithTag((ServiceTags)KafkaTags.broker)));
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.truststore.location", this.baseHadoopService.getSuperTrustStorePath());
        props.setProperty("ssl.truststore.password", this.baseHadoopService.getSuperTrustStorePassword());
        props.setProperty("ssl.keystore.location", this.baseHadoopService.getSuperKeystorePath());
        props.setProperty("ssl.keystore.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.key.password", this.baseHadoopService.getSuperKeystorePassword());
        props.setProperty("ssl.endpoint.identification.algorithm", "");
        LOG.log(Level.FINE, "Will attempt to initialize current kafka client");
        return AdminClient.create((Properties)props);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListTopicsResult listTopics() throws KafkaException {
        try (AdminClient adminClient = this.initClient();){
            ListTopicsResult listTopicsResult = adminClient.listTopics();
            return listTopicsResult;
        }
        catch (Exception e) {
            throw new KafkaException(RESTCodes.KafkaErrorCode.BROKER_METADATA_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) throws KafkaException {
        try (AdminClient adminClient = this.initClient();){
            CreateTopicsResult createTopicsResult = adminClient.createTopics(newTopics);
            return createTopicsResult;
        }
        catch (Exception e) {
            throw new KafkaException(RESTCodes.KafkaErrorCode.TOPIC_CREATION_FAILED, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteTopicsResult deleteTopics(Collection<String> topics) throws KafkaException {
        try (AdminClient adminClient = this.initClient();){
            DeleteTopicsResult deleteTopicsResult = adminClient.deleteTopics(topics);
            return deleteTopicsResult;
        }
        catch (Exception e) {
            throw new KafkaException(RESTCodes.KafkaErrorCode.TOPIC_DELETION_FAILED, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DescribeTopicsResult describeTopics(Collection<String> topics) throws KafkaException {
        try (AdminClient adminClient = this.initClient();){
            DescribeTopicsResult describeTopicsResult = adminClient.describeTopics(topics);
            return describeTopicsResult;
        }
        catch (Exception e) {
            throw new KafkaException(RESTCodes.KafkaErrorCode.BROKER_METADATA_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }
}

