/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset;

import io.hops.common.Pair;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetRequestFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWithFacade;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.dao.log.operation.OperationsLogFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dataset.FilePreviewDTO;
import io.hops.hopsworks.common.dataset.FilePreviewMode;
import io.hops.hopsworks.common.dataset.FolderNameValidator;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.FsPermissions;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.command.ArchiveFormat;
import io.hops.hopsworks.common.hdfs.command.HdfsCommandExecutionController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.jupyter.JupyterController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.dataset.DatasetRequest;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.dataset.PermissionTransition;
import io.hops.hopsworks.persistence.entity.dataset.SharedState;
import io.hops.hopsworks.persistence.entity.hdfs.command.Command;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.log.operation.OperationType;
import io.hops.hopsworks.persistence.entity.log.operation.OperationsLog;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DatasetController {
    private static final Logger LOGGER = Logger.getLogger(DatasetController.class.getName());
    @EJB
    private InodeFacade inodes;
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private DatasetSharedWithFacade datasetSharedWithFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private OperationsLogFacade operationsLogFacade;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DatasetRequestFacade datasetRequest;
    @EJB
    private HopsFSProvenanceController fsProvController;
    @EJB
    private JupyterController jupyterController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private HdfsCommandExecutionController hdfsCommandExecutionController;

    public Dataset createDataset(Users user, Project project, String dataSetName, String datasetDescription, ProvTypeDTO metaStatus, boolean stickyBit, DatasetAccessPermission permission, DistributedFileSystemOps dfso) throws DatasetException, HopsSecurityException {
        if (user == null || project == null || dataSetName == null) {
            throw new IllegalArgumentException("User, project or dataset were not provided");
        }
        FolderNameValidator.isValidName(dataSetName);
        String dsPath = Utils.getProjectPath(project.getName()) + dataSetName;
        Inode parent = this.inodeController.getProjectRoot(project.getName());
        Inode ds = this.inodes.findByInodePK(parent, dataSetName, HopsUtils.dataSetPartitionId(parent, dataSetName));
        if (ds != null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "Dataset name: " + dataSetName);
        }
        Dataset newDS = null;
        FsPermission fsPermission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE, stickyBit);
        boolean success = this.createFolder(dsPath, fsPermission, dfso);
        if (success) {
            try {
                ds = this.inodes.findByInodePK(parent, dataSetName, HopsUtils.dataSetPartitionId(parent, dataSetName));
                newDS = new Dataset(project, ds.getInodePK().getName(), permission);
                newDS.setSearchable(this.isSearchable(metaStatus.getMetaStatus()));
                if (datasetDescription != null) {
                    newDS.setDescription(datasetDescription);
                }
                this.datasetFacade.persistDataset(newDS);
                this.activityFacade.persistActivity(" added a new dataset named " + dataSetName, project, user, ActivityFlag.DATASET);
                this.hdfsUsersController.createDatasetGroupsAndSetPermissions(user, project, newDS, new Path(dsPath), dfso);
                Dataset logDs = this.getByProjectAndDsName(project, null, dataSetName);
                this.fsProvController.updateDatasetProvType(logDs, metaStatus, dfso);
                this.logDataset(project, logDs, ds, OperationType.Add);
            }
            catch (Exception e) {
                try {
                    dfso.rm(new Path(dsPath), true);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Could not cleanup dataset dir after exception: " + dsPath, ex);
                }
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "Could not create dataset: " + dataSetName, e.getMessage(), (Throwable)e);
            }
        }
        throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.INFO, "Could not create dataset: " + dataSetName);
        return newDS;
    }

    private boolean isSearchable(Inode.MetaStatus metaStatus) {
        return !Inode.MetaStatus.DISABLED.equals((Object)metaStatus);
    }

    public void createSubDirectory(Project project, Path dirPath, DistributedFileSystemOps udfso) throws DatasetException, HopsSecurityException {
        if (project == null) {
            throw new NullPointerException("Cannot create a directory under a null project.");
        }
        if (dirPath == null) {
            throw new NullPointerException("Cannot create a directory for an empty path.");
        }
        String parentPath = dirPath.getParent().toString();
        if (this.inodeController.existsPath(dirPath.toString())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_SUBDIR_ALREADY_EXISTS, Level.FINE, "The given path: " + dirPath.toString() + " already exists");
        }
        Inode parent = this.inodeController.getInodeAtPath(parentPath);
        if (parent == null) {
            throw new IllegalArgumentException("Path for parent folder does not exist: " + parentPath + " under " + project.getName());
        }
        this.createFolder(dirPath.toString(), null, udfso);
    }

    public boolean deleteDatasetDir(Dataset dataset, Path location, DistributedFileSystemOps udfso) throws IOException {
        Inode datasetInodeId = this.inodeController.getInodeAtPath(location.toString());
        OperationsLog log = new OperationsLog(dataset, datasetInodeId.getId(), OperationType.Delete);
        boolean success = udfso.rm(location, true);
        if (success) {
            this.operationsLogFacade.persist(log);
        }
        return success;
    }

    public void recChangeOwnershipAndPermission(Path path, FsPermission permission, String username, String group, DistributedFileSystemOps dfso, DistributedFileSystemOps udfso) throws IOException {
        if (username != null && group != null && dfso != null) {
            dfso.setOwner(path, username, group);
        }
        udfso.setPermission(path, permission);
        Inode rootInode = this.inodeController.getInodeAtPath(path.toString());
        Stack<Pair> dirs = new Stack<Pair>();
        if (rootInode.isDir()) {
            dirs.push(new Pair((Object)rootInode, (Object)path));
        }
        while (!dirs.isEmpty()) {
            Pair dirInode = (Pair)dirs.pop();
            for (Inode child : this.inodeController.getChildren((Inode)dirInode.getL())) {
                Path childPath = new Path((Path)dirInode.getR(), child.getInodePK().getName());
                if (username != null && group != null && dfso != null) {
                    dfso.setOwner(childPath, username, group);
                }
                udfso.setPermission(childPath, permission);
                if (!child.isDir()) continue;
                dirs.push(new Pair((Object)child, (Object)childPath));
            }
        }
    }

    private boolean createFolder(String path, FsPermission fsPermission, DistributedFileSystemOps dfso) throws HopsSecurityException {
        boolean success;
        Path location = new Path(path);
        try {
            if (fsPermission == null) {
                fsPermission = dfso.getParentPermission(location);
            }
            if (success = dfso.mkdir(location, fsPermission)) {
                dfso.setPermission(location, fsPermission);
            }
        }
        catch (IOException ex) {
            throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.WARNING, "Permission denied: path=" + path, ex.getMessage(), (Throwable)ex);
        }
        return success;
    }

    public void generateReadme(DistributedFileSystemOps udfso, String dsName, String description, String project) {
        if (udfso != null) {
            String readmeFile = String.format("*This is an auto-generated README.md file for your Dataset!*\nTo replace it, go into your DataSet and edit the README.md file.\n\n*%s* DataSet\n===\n\n## %s", dsName, description);
            StringBuilder readmeSb = new StringBuilder();
            readmeSb.append(Utils.getProjectPath(project)).append(dsName).append(File.separator).append("README.md");
            String readMeFilePath = readmeSb.toString();
            try (FSDataOutputStream fsOut = udfso.create(readMeFilePath);){
                fsOut.writeBytes(readmeFile);
                fsOut.flush();
                udfso.setPermission(new Path(readMeFilePath), FsPermissions.rwxr_x___);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "README.md could not be generated for project {0} and dataset {1}.", new Object[]{project, dsName});
            }
        } else {
            LOGGER.log(Level.WARNING, "README.md could not be generated for project {0} and dataset {1}. DFS client was null", new Object[]{project, dsName});
        }
    }

    public FilePreviewDTO getReadme(String path, DistributedFileSystemOps dfso) throws IOException {
        if (path == null || dfso == null) {
            throw new IllegalArgumentException("One or more arguments are not set.");
        }
        if (!path.endsWith("README.md")) {
            throw new IllegalArgumentException("Path does not contain readme file.");
        }
        try {
            if (!dfso.exists(path) || dfso.isDir(path)) {
                throw new IOException("The file does not exist");
            }
            long fileSize = dfso.getFileStatus(new Path(path)).getLen();
            if (fileSize > 393216L) {
                throw new IllegalArgumentException("README.md must be smaller than393216 to be previewed");
            }
            byte[] headContent = new byte[(int)fileSize];
            try (DataInputStream dis = new DataInputStream((InputStream)dfso.open(path));){
                dis.readFully(headContent, 0, (int)fileSize);
            }
            FilePreviewDTO filePreviewDTO = new FilePreviewDTO("text", "md", new String(headContent));
            return filePreviewDTO;
        }
        catch (AccessControlException ex) {
            throw new AccessControlException("Permission denied: You can not view the file.");
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    public void logDataset(Project project, Dataset dataset, Inode datasetInode, OperationType type) {
        if (dataset.isShared(project) || !dataset.isSearchable()) {
            return;
        }
        this.operationsLogFacade.persist(new OperationsLog(dataset, datasetInode.getId(), type));
    }

    public Project getOwningProject(Dataset ds) {
        return ds.getProject();
    }

    public Project getOwningProject(Inode ds) {
        String datasetName;
        Inode parent = this.inodes.findParent(ds);
        Project proj = this.projectFacade.findByName(parent.getInodePK().getName());
        if (proj == null && (datasetName = ds.getInodePK().getName()).endsWith(".db")) {
            String projectName = datasetName.endsWith("_featurestore.db") ? datasetName.substring(0, datasetName.lastIndexOf("_")) : datasetName.substring(0, datasetName.lastIndexOf("."));
            proj = this.projectFacade.findByNameCaseInsensitive(projectName);
        }
        return proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadAllowed(Project project, Users user, String path) {
        String role = this.projectTeamFacade.findCurrentRole(project, user);
        if (role.equals("Data owner")) {
            return true;
        }
        if (role.equals("Data scientist")) {
            DistributedFileSystemOps udfso = null;
            try {
                String username = this.hdfsUsersController.getHdfsUserName(project, user);
                udfso = this.dfs.getDfsOps(username);
                String owner = udfso.getFileStatus(new Path(path)).getOwner();
                String projectUser = this.hdfsUsersController.getHdfsUserName(project, user);
                if (owner.equals(projectUser)) {
                    boolean bl = true;
                    this.dfs.closeDfsClient(udfso);
                    return bl;
                }
                this.dfs.closeDfsClient(udfso);
            }
            catch (IOException ex) {
                try {
                    LOGGER.log(Level.SEVERE, "Could not get owner of file: " + path, ex);
                    this.dfs.closeDfsClient(udfso);
                }
                catch (Throwable throwable) {
                    this.dfs.closeDfsClient(udfso);
                    throw throwable;
                }
            }
        }
        return false;
    }

    public Dataset getDatasetByName(Project project, String name) {
        return this.datasetFacade.findByProjectAndName(project, name);
    }

    public Dataset getByProjectAndDsName(Project currentProject, String inodeParentPath, String dsName) {
        Inode parentInode = this.inodeController.getInodeAtPath(inodeParentPath == null ? Utils.getProjectPath(currentProject.getName()) : inodeParentPath);
        Inode dsInode = this.inodes.findByInodePK(parentInode, dsName, HopsUtils.calculatePartitionId(parentInode.getId(), dsName, 3));
        if (dsInode == null && dsName.endsWith(".db")) {
            parentInode = this.inodeController.getInodeAtPath(this.settings.getHiveWarehouse());
            dsInode = this.inodes.findByInodePK(parentInode, dsName, HopsUtils.calculatePartitionId(parentInode.getId(), dsName, 3));
        }
        if (currentProject == null || dsInode == null) {
            return null;
        }
        return this.getByProjectAndInode(currentProject, dsInode);
    }

    public Dataset getByName(Project project, String dsName) throws DatasetException {
        String nativeDatasetPath = Utils.getProjectPath(project.getName()) + dsName;
        return this.getByProjectAndFullPath(project, nativeDatasetPath);
    }

    public List<Dataset> getAllByName(Project project, String dsName) {
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        try {
            Dataset nativeDataset = this.getByName(project, dsName);
            result.add(nativeDataset);
        }
        catch (DatasetException nativeDataset) {
            // empty catch block
        }
        List sharedDatasets = project.getDatasetSharedWithCollection().stream().filter(DatasetSharedWith::getAccepted).filter(sds -> sds.getDataset().getName().equals(dsName)).map(sds -> sds.getDataset()).collect(Collectors.toCollection(ArrayList::new));
        result.addAll(sharedDatasets);
        return result;
    }

    public Dataset getByProjectAndInode(Project project, Inode inode) {
        DatasetSharedWith datasetSharedWith;
        Dataset dataset = this.datasetFacade.findByProjectAndName(project, inode.getInodePK().getName());
        if (dataset != null && !dataset.getProject().equals((Object)project) && (datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset)) == null) {
            dataset = null;
        }
        return dataset;
    }

    public Dataset getByProjectAndFullPath(Project project, String fullPath) throws DatasetException {
        Inode inode = this.inodeController.getInodeAtPath(fullPath);
        if (project == null || inode == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE, "path: " + fullPath);
        }
        Dataset dataset = this.datasetFacade.findByProjectAndName(project, inode.getInodePK().getName());
        Project owningProject = this.getOwningProject(inode);
        if (!project.getName().equals(owningProject.getName())) {
            dataset = this.datasetFacade.findByProjectAndName(owningProject, inode.getInodePK().getName());
            if (dataset == null) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE, "path: " + fullPath);
            }
            DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset);
            if (datasetSharedWith == null) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE, "path: " + fullPath);
            }
            return datasetSharedWith.getDataset();
        }
        return dataset;
    }

    public FilePreviewDTO filePreview(Project project, Users user, Path fullPath, FilePreviewMode mode, List<String> allowedImgExtension) throws DatasetException {
        FilePreviewDTO filePreviewDTO;
        block30: {
            DistributedFileSystemOps udfso = null;
            FSDataInputStream is = null;
            filePreviewDTO = null;
            String fileName = fullPath.getName();
            try {
                udfso = this.dfs.getDfsOps(project, user);
                is = udfso.open(fullPath);
                String fileExtension = "txt";
                if (fileName.contains(".")) {
                    fileExtension = fileName.substring(fileName.lastIndexOf(".")).replace(".", "").toUpperCase();
                }
                long fileSize = udfso.getFileStatus(fullPath).getLen();
                if (allowedImgExtension.contains(fileExtension)) {
                    if (fileSize < (long)this.settings.getFilePreviewImageSize()) {
                        byte[] imageInBytes = new byte[(int)fileSize];
                        is.readFully(imageInBytes);
                        String base64Image = new Base64().encodeAsString(imageInBytes);
                        filePreviewDTO = new FilePreviewDTO("image", fileExtension.toLowerCase(), base64Image);
                        break block30;
                    }
                    throw new DatasetException(RESTCodes.DatasetErrorCode.IMAGE_SIZE_INVALID, Level.FINE);
                }
                if (fileExtension.equalsIgnoreCase("ipynb")) {
                    String html = this.jupyterController.convertIPythonNotebook(project, user, fullPath.toString(), "''", JupyterController.NotebookConversion.HTML);
                    filePreviewDTO = new FilePreviewDTO("html", fileExtension.toLowerCase(), html);
                    break block30;
                }
                try (DataInputStream dis = new DataInputStream((InputStream)is);){
                    int sizeThreshold = 393216;
                    if (fileSize > (long)sizeThreshold && !fileName.endsWith("README.md") && mode.equals((Object)FilePreviewMode.TAIL)) {
                        dis.skipBytes((int)(fileSize - (long)sizeThreshold));
                    } else {
                        if (fileName.endsWith("README.md") && fileSize > 393216L) {
                            throw new DatasetException(RESTCodes.DatasetErrorCode.FILE_PREVIEW_ERROR, Level.FINE, "File must be smaller than 384 KB to be previewed");
                        }
                        if ((int)fileSize < sizeThreshold) {
                            sizeThreshold = (int)fileSize;
                        }
                    }
                    byte[] headContent = new byte[sizeThreshold];
                    dis.readFully(headContent, 0, sizeThreshold);
                    filePreviewDTO = new FilePreviewDTO("text", fileExtension.toLowerCase(), new String(headContent));
                }
            }
            catch (ServiceException | IOException ex) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "path: " + fullPath.toString(), ex.getMessage(), ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "Error while closing stream.", ex);
                    }
                }
                this.dfs.closeDfsClient(udfso);
            }
        }
        return filePreviewDTO;
    }

    public void checkFileExists(Path filePath, String username) throws DatasetException {
        boolean exist;
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            exist = udfso.exists(filePath);
        }
        catch (AccessControlException ae) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_ACCESS_PERMISSION_DENIED, Level.FINE, "path: " + filePath.toString(), ae.getMessage(), (Throwable)ae);
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + filePath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        if (!exist) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + filePath.toString());
        }
    }

    public void unzip(Project project, Users user, Path path, Path destPath) throws DatasetException {
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        this.checkFileExists(path, hdfsUser);
        try {
            this.hdfsCommandExecutionController.setupAndStartJob(user, project, Command.EXTRACT, path, destPath, null, false);
        }
        catch (GenericException | JobException | ProjectException | ServiceException e) {
            String userMsg = e.getUsrMsg() != null ? e.getUsrMsg() : "";
            throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_ERROR, Level.SEVERE, "Error extracting file at path: " + path + ". " + userMsg, e.getMessage(), e);
        }
    }

    public void zip(Project project, Users user, Path path, Path destPath) throws DatasetException {
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        this.checkFileExists(path, hdfsUser);
        try {
            this.hdfsCommandExecutionController.setupAndStartJob(user, project, Command.COMPRESS, path, destPath, ArchiveFormat.ZIP, false);
        }
        catch (GenericException | JobException | ProjectException | ServiceException e) {
            String userMsg = e.getUsrMsg() != null ? e.getUsrMsg() : "";
            throw new DatasetException(RESTCodes.DatasetErrorCode.COMPRESSION_ERROR, Level.SEVERE, "Error compressing file at path: " + path + ". " + userMsg, e.getMessage(), e);
        }
    }

    public void share(String targetProjectName, String fullPath, DatasetAccessPermission permission, Project project, Users user) throws DatasetException, ProjectException {
        Project targetProject = this.projectFacade.findByName(targetProjectName);
        Dataset ds = this.getByProjectAndFullPath(project, fullPath);
        if (targetProject == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "Target project not found.");
        }
        DatasetSharedWith datasetSharedWith = this.shareInternal(targetProject, ds, user, permission);
        if (DatasetType.FEATURESTORE.equals((Object)ds.getDsType()) && datasetSharedWith.getAccepted()) {
            Dataset trainingDataset = this.getTrainingDataset(project);
            if (trainingDataset != null) {
                try {
                    this.shareInternal(targetProject, trainingDataset, user, permission);
                }
                catch (DatasetException datasetException) {
                    // empty catch block
                }
            }
            this.shareFeatureStoreServiceDataset(user, project, targetProject, permission, Settings.ServiceDataset.STATISTICS);
        }
    }

    private Dataset getTrainingDataset(Project project) {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        String trainingDatasetName = project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
        Inode inode = this.inodes.findByParentAndName(projectInode, trainingDatasetName);
        return this.datasetFacade.findByProjectAndName(project, inode.getInodePK().getName());
    }

    private void shareFeatureStoreServiceDataset(Users user, Project project, Project targetProject, DatasetAccessPermission permission, Settings.ServiceDataset serviceDataset) {
        Dataset dataset = this.getFeatureStoreServiceDataset(project, serviceDataset);
        if (dataset != null) {
            try {
                this.shareInternal(targetProject, dataset, user, permission);
            }
            catch (DatasetException datasetException) {
                // empty catch block
            }
        }
    }

    private Dataset getFeatureStoreServiceDataset(Project project, Settings.ServiceDataset serviceDataset) {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        Inode inode = this.inodes.findByParentAndName(projectInode, serviceDataset.getName());
        return this.datasetFacade.findByProjectAndName(project, inode.getInodePK().getName());
    }

    private DatasetSharedWith shareInternal(Project targetProject, Dataset ds, Users user, DatasetAccessPermission permission) throws DatasetException {
        DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(targetProject, ds);
        if (datasetSharedWith != null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "Dataset already in " + targetProject.getName());
        }
        datasetSharedWith = new DatasetSharedWith(targetProject, ds, permission, false, user);
        DatasetRequest dsReq = this.datasetRequest.findByProjectAndDataset(targetProject, ds);
        if (ds.isPublicDs()) {
            if (targetProject.equals((Object)ds.getProject())) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_ALREADY_IN_PROJECT, Level.FINE, "Dataset already in project.");
            }
            datasetSharedWith.setAccepted(true);
            datasetSharedWith.setAcceptedBy(user);
            this.addMembersToGroup(datasetSharedWith);
        } else if (dsReq != null && dsReq.getProjectTeam().getTeamRole().equals("Data owner")) {
            datasetSharedWith.setAccepted(true);
            datasetSharedWith.setAcceptedBy(dsReq.getProjectTeam().getUser());
            this.addMembersToGroup(datasetSharedWith);
        }
        this.datasetSharedWithFacade.save(datasetSharedWith);
        if (dsReq != null) {
            this.datasetRequest.remove(dsReq);
        }
        this.activityFacade.persistActivity(" shared dataset " + ds.getName() + " with project " + targetProject.getName(), ds.getProject(), user, ActivityFlag.DATASET);
        return datasetSharedWith;
    }

    private void addMembersToGroup(DatasetSharedWith datasetSharedWith) throws DatasetException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            for (ProjectTeam teamMember : datasetSharedWith.getProject().getProjectTeamCollection()) {
                this.hdfsUsersController.addNewMember(datasetSharedWith.getDataset(), datasetSharedWith.getPermission(), teamMember, dfso);
            }
        }
        catch (IOException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.FINE, "Failed to add member to group", e.getMessage());
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    public void acceptShared(Project project, Users user, DatasetSharedWith datasetSharedWith) throws DatasetException, FeaturestoreException {
        this.acceptSharedDs(user, datasetSharedWith);
        if (DatasetType.FEATURESTORE.equals((Object)datasetSharedWith.getDataset().getDsType())) {
            DatasetSharedWith trainingDataset = this.getOrCreateSharedTrainingDataset(project, datasetSharedWith.getDataset().getProject(), datasetSharedWith.getPermission(), datasetSharedWith.getSharedBy());
            if (trainingDataset != null && !trainingDataset.getAccepted()) {
                try {
                    this.acceptSharedDs(user, trainingDataset);
                }
                catch (DatasetException datasetException) {
                    // empty catch block
                }
            }
            this.acceptSharedFeatureStoreServiceDataset(project, datasetSharedWith, datasetSharedWith.getPermission(), datasetSharedWith.getSharedBy(), user, Settings.ServiceDataset.STATISTICS);
            this.onlineFeaturestoreController.shareOnlineFeatureStore(project, datasetSharedWith.getDataset().getFeatureStore(), datasetSharedWith.getPermission());
        }
    }

    private DatasetSharedWith getOrCreateSharedTrainingDataset(Project project, Project parentProject, DatasetAccessPermission permission, Users sharedBy) {
        Dataset trainingDataset = this.getTrainingDataset(parentProject);
        DatasetSharedWith sharedTrainingDataset = this.datasetSharedWithFacade.findByProjectAndDataset(project, trainingDataset);
        if (sharedTrainingDataset == null) {
            sharedTrainingDataset = new DatasetSharedWith(project, trainingDataset, permission, false, sharedBy);
            this.datasetSharedWithFacade.save(sharedTrainingDataset);
            sharedTrainingDataset = this.datasetSharedWithFacade.findByProjectAndDataset(project, trainingDataset);
        }
        return sharedTrainingDataset;
    }

    private void acceptSharedFeatureStoreServiceDataset(Project project, DatasetSharedWith datasetSharedWith, DatasetAccessPermission permission, Users sharedBy, Users acceptedBy, Settings.ServiceDataset serviceDataset) {
        DatasetSharedWith dataset = this.getOrCreateSharedFeatureStoreServiceDataset(project, datasetSharedWith.getDataset().getProject(), permission, sharedBy, serviceDataset);
        if (dataset != null && !dataset.getAccepted()) {
            try {
                this.acceptSharedDs(acceptedBy, dataset);
            }
            catch (DatasetException datasetException) {
                // empty catch block
            }
        }
    }

    private DatasetSharedWith getOrCreateSharedFeatureStoreServiceDataset(Project project, Project parentProject, DatasetAccessPermission permission, Users sharedBy, Settings.ServiceDataset serviceDataset) {
        Dataset dataset = this.getFeatureStoreServiceDataset(parentProject, serviceDataset);
        DatasetSharedWith sharedDataset = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset);
        if (sharedDataset == null) {
            sharedDataset = new DatasetSharedWith(project, dataset, permission, false, sharedBy);
            this.datasetSharedWithFacade.save(sharedDataset);
            sharedDataset = this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset);
        }
        return sharedDataset;
    }

    private void acceptSharedDs(Users user, DatasetSharedWith datasetSharedWith) throws DatasetException {
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE);
        }
        this.addMembersToGroup(datasetSharedWith);
        datasetSharedWith.setAccepted(true);
        datasetSharedWith.setAcceptedBy(user);
        this.datasetSharedWithFacade.update(datasetSharedWith);
    }

    public void rejectShared(DatasetSharedWith datasetSharedWith) throws DatasetException {
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_FOUND, Level.FINE);
        }
        this.datasetSharedWithFacade.remove(datasetSharedWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(Project project, Users user, Path fullPath, String name, Boolean isDataset, String description, ProvTypeDTO metaStatus, Boolean generateReadme, DatasetAccessPermission permission) throws DatasetException, HopsSecurityException {
        DistributedFileSystemOps dfso = this.dfs.getDfsOps();
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(username);
        if (description == null) {
            description = "";
        }
        try {
            if (isDataset.booleanValue()) {
                this.createDataset(user, project, name, description, metaStatus, false, permission, dfso);
                if (generateReadme != null && generateReadme.booleanValue()) {
                    this.generateReadme(udfso, name, description, project.getName());
                }
            } else {
                this.createSubDirectory(project, fullPath, udfso);
            }
        }
        finally {
            this.dfs.closeDfsClient(dfso);
            this.dfs.closeDfsClient(udfso);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(Project project, Users user, Path sourcePath, Path destPath, Dataset sourceDataset, Dataset destDataset) throws DatasetException, HopsSecurityException {
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        if (!this.getOwningProject(sourceDataset).equals((Object)destDataset.getProject())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_FORBIDDEN, Level.FINE, "Cannot copy file/folder from another project.");
        }
        if (destDataset.isPublicDs()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_FORBIDDEN, Level.FINE, "Can not move to a public dataset.");
        }
        DistributedFileSystemOps udfso = null;
        DistributedFileSystemOps dfso = null;
        try {
            Project owning = this.getOwningProject(sourceDataset);
            boolean isMember = this.projectTeamFacade.isUserMemberOfProject(owning, user);
            udfso = isMember && this.projectTeamFacade.findCurrentRole(owning, user).equals("Data owner") && owning.equals((Object)project) ? this.dfs.getDfsOps() : this.dfs.getDfsOps(username);
            dfso = this.dfs.getDfsOps();
            if (udfso.exists(destPath.toString())) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE, "destination: " + destPath.toString());
            }
            FsPermission permission = udfso.getFileStatus(destPath.getParent()).getPermission();
            String group = udfso.getFileStatus(destPath.getParent()).getGroup();
            String owner = udfso.getFileStatus(sourcePath).getOwner();
            udfso.moveWithinHdfs(sourcePath, destPath);
            this.recChangeOwnershipAndPermission(destPath, permission, owner, group, dfso, udfso);
            this.dfs.closeDfsClient(udfso);
            this.dfs.closeDfsClient(dfso);
            return;
        }
        catch (AccessControlException ex) {
            try {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.FINE, "Operation: move, from: " + sourcePath.toString() + " to: " + destPath.toString());
                catch (IOException ex2) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "move operation failed for: " + sourcePath.toString(), ex2.getMessage(), (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                this.dfs.closeDfsClient(dfso);
                throw throwable;
            }
        }
    }

    public void copy(Project project, Users user, Path sourcePath, Path destPath, Dataset sourceDataset, Dataset destDataset) throws DatasetException {
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        if (!this.getOwningProject(sourceDataset).equals((Object)destDataset.getProject())) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.COPY_FROM_PROJECT, Level.FINE);
        }
        if (destDataset.isPublicDs()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.COPY_TO_PUBLIC_DS, Level.FINE);
        }
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(username);
            if (udfso.exists(destPath.toString())) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DESTINATION_EXISTS, Level.FINE);
            }
            FsPermission permission = udfso.getFileStatus(destPath.getParent()).getPermission();
            udfso.copyInHdfs(sourcePath, destPath);
            this.recChangeOwnershipAndPermission(destPath, permission, null, null, null, udfso);
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.SEVERE, "move operation failed for: " + sourcePath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    public void changePermissions(Dataset ds, PermissionTransition permissionTransition, Project targetProject) throws DatasetException {
        if (permissionTransition.noop()) {
            this.datasetFacade.update(ds);
            return;
        }
        ds.setPermission(permissionTransition.getTo());
        try {
            this.hdfsUsersController.changePermission(ds, targetProject, permissionTransition);
        }
        catch (IOException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PERMISSION_ERROR, Level.WARNING, "dataset: " + ds.getName(), e.getMessage(), (Throwable)e);
        }
        this.datasetFacade.update(ds);
    }

    public void changePermissions(Dataset ds, PermissionTransition permissionTransition, Project targetProject, DistributedFileSystemOps dfso) throws DatasetException {
        if (permissionTransition.noop()) {
            this.datasetFacade.update(ds);
            return;
        }
        ds.setPermission(permissionTransition.getTo());
        try {
            this.hdfsUsersController.changePermission(ds, targetProject, permissionTransition, dfso);
        }
        catch (IOException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PERMISSION_ERROR, Level.WARNING, "dataset: " + ds.getName(), e.getMessage(), (Throwable)e);
        }
        this.datasetFacade.update(ds);
    }

    public void changePermissions(DatasetSharedWith ds, PermissionTransition permissionTransition) throws DatasetException {
        if (permissionTransition.noop()) {
            this.datasetSharedWithFacade.update(ds);
            return;
        }
        ds.setPermission(permissionTransition.getTo());
        try {
            this.hdfsUsersController.changePermission(ds.getDataset(), ds.getProject(), permissionTransition);
        }
        catch (IOException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PERMISSION_ERROR, Level.WARNING, "dataset: " + ds.getDataset().getName(), e.getMessage(), (Throwable)e);
        }
        this.datasetSharedWithFacade.update(ds);
    }

    public void changePermissions(DatasetSharedWith ds, PermissionTransition permissionTransition, DistributedFileSystemOps dfso) throws DatasetException {
        if (permissionTransition.noop()) {
            this.datasetSharedWithFacade.update(ds);
            return;
        }
        ds.setPermission(permissionTransition.getTo());
        try {
            this.hdfsUsersController.changePermission(ds.getDataset(), ds.getProject(), permissionTransition, dfso);
        }
        catch (IOException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PERMISSION_ERROR, Level.WARNING, "dataset: " + ds.getDataset().getName(), e.getMessage(), (Throwable)e);
        }
        this.datasetSharedWithFacade.update(ds);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Project project, Users user, Path fullPath, Dataset dataset, boolean isDataset) throws DatasetException {
        boolean success;
        String username = this.hdfsUsersController.getHdfsUserName(project, user);
        Project owning = this.getOwningProject(dataset);
        DistributedFileSystemOps dfso = null;
        if (isDataset && dataset.isShared(project)) {
            this.unshare(project, user, dataset, project.getName());
            return;
        }
        try {
            boolean isMember = this.projectTeamFacade.isUserMemberOfProject(owning, user);
            dfso = isMember && this.projectTeamFacade.findCurrentRole(owning, user).equals("Data owner") && owning.equals((Object)project) ? this.dfs.getDfsOps() : this.dfs.getDfsOps(username);
            if (isDataset) {
                success = this.deleteDatasetDir(dataset, fullPath, dfso);
                if (success) {
                    this.datasetFacade.removeDataset(dataset);
                }
            } else {
                success = dfso.rm(fullPath, true);
            }
            this.dfs.closeDfsClient(dfso);
        }
        catch (AccessControlException ae) {
            try {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_ACCESS_PERMISSION_DENIED, Level.FINE, "path: " + fullPath.toString(), ae.getMessage(), (Throwable)ae);
                catch (FileNotFoundException fnfe) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "path: " + fullPath.toString(), fnfe.getMessage(), (Throwable)fnfe);
                }
                catch (IOException ex) {
                    throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_DELETION_ERROR, Level.SEVERE, "path: " + fullPath.toString(), ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(dfso);
                throw throwable;
            }
        }
        if (!success) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_DELETION_ERROR, Level.FINE, "path: " + fullPath.toString());
        }
        if (!isDataset) return;
        try {
            this.hdfsUsersController.deleteDatasetGroups(project, dataset);
            return;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error while trying to delete the dataset groups", ex);
        }
    }

    public void deleteCorrupted(Project project, Users user, Path fullPath, Dataset dataset) throws DatasetException {
        DistributedFileSystemOps dfso = null;
        try {
            Project owning = this.getOwningProject(dataset);
            boolean isMember = this.projectTeamFacade.isUserMemberOfProject(owning, user);
            if (isMember && owning.equals((Object)project)) {
                dfso = this.dfs.getDfsOps();
                FileStatus fs = dfso.getFileStatus(fullPath);
                String owner = fs.getOwner();
                long len = fs.getLen();
                if (owner.equals(this.settings.getHopsworksUser()) && len == 0L) {
                    dfso.rm(fullPath, true);
                }
            }
        }
        catch (IOException ex) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_DELETION_ERROR, Level.SEVERE, "path: " + fullPath.toString(), ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unshare(Project project, Users user, Dataset dataset, String targetProjectName) throws DatasetException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            this.unshare(project, user, dataset, targetProjectName, dfso);
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    public void unshare(Project project, Users user, Dataset dataset, String targetProjectName, DistributedFileSystemOps dfso) throws DatasetException {
        Project targetProject = this.projectFacade.findByName(targetProjectName);
        if (targetProject == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.TARGET_PROJECT_NOT_FOUND, Level.FINE);
        }
        DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(targetProject, dataset);
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_SHARED_WITH_PROJECT, Level.FINE, "project: " + targetProject.getName());
        }
        if (DatasetType.FEATURESTORE.equals((Object)datasetSharedWith.getDataset().getDsType())) {
            DatasetSharedWith trainingDataset = this.getSharedTrainingDataset(targetProject, datasetSharedWith.getDataset().getProject());
            if (trainingDataset != null) {
                this.unshareDs(project, user, trainingDataset, dfso);
            }
            this.unshareFeatureStoreServiceDataset(user, project, targetProject, datasetSharedWith, Settings.ServiceDataset.STATISTICS, dfso);
            this.onlineFeaturestoreController.unshareOnlineFeatureStore(targetProject, dataset.getFeatureStore());
        }
        this.unshareDs(project, user, datasetSharedWith, dfso);
    }

    private DatasetSharedWith getSharedTrainingDataset(Project project, Project parentProject) {
        Dataset trainingDataset = this.getTrainingDataset(parentProject);
        return this.datasetSharedWithFacade.findByProjectAndDataset(project, trainingDataset);
    }

    private void unshareDs(Project project, Users user, DatasetSharedWith datasetSharedWith, DistributedFileSystemOps dfso) throws DatasetException {
        this.removeAllShareMembers(datasetSharedWith, dfso);
        this.datasetSharedWithFacade.remove(datasetSharedWith);
        this.activityFacade.persistActivity(" unshared dataset " + datasetSharedWith.getDataset().getName() + " with project " + datasetSharedWith.getProject().getName(), project, user, ActivityFlag.DATASET);
    }

    private void unshareDs(Project project, Users user, Dataset dataset, DatasetSharedWith datasetSharedWith) throws DatasetException {
        this.removeAllShareMembers(datasetSharedWith);
        this.datasetSharedWithFacade.remove(datasetSharedWith);
        this.activityFacade.persistActivity(" unshared dataset " + dataset.getName() + " with project " + datasetSharedWith.getProject().getName(), project, user, ActivityFlag.DATASET);
    }

    private void unshareFeatureStoreServiceDataset(Users user, Project project, Project targetProject, DatasetSharedWith datasetSharedWith, Settings.ServiceDataset serviceDataset, DistributedFileSystemOps dfso) throws DatasetException {
        DatasetSharedWith serviceDatasetSharedWith = this.getSharedFeatureStoreServiceDataset(targetProject, datasetSharedWith.getDataset().getProject(), serviceDataset);
        if (serviceDatasetSharedWith != null) {
            this.unshareDs(project, user, serviceDatasetSharedWith, dfso);
        }
    }

    private DatasetSharedWith getSharedFeatureStoreServiceDataset(Project project, Project parentProject, Settings.ServiceDataset serviceDataset) {
        Dataset dataset = this.getFeatureStoreServiceDataset(parentProject, serviceDataset);
        return this.datasetSharedWithFacade.findByProjectAndDataset(project, dataset);
    }

    public void unshareDataset(Project project, Users user, Project targetProject, Dataset dataset) throws DatasetException {
        DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(targetProject, dataset);
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_SHARED_WITH_PROJECT, Level.FINE, "project: " + targetProject.getName());
        }
        this.unshareDs(project, user, dataset, datasetSharedWith);
    }

    private void removeAllShareMembers(DatasetSharedWith datasetSharedWith) throws DatasetException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            this.removeAllShareMembers(datasetSharedWith, dfso);
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    private void removeAllShareMembers(DatasetSharedWith datasetSharedWith, DistributedFileSystemOps dfso) throws DatasetException {
        for (ProjectTeam teamMember : datasetSharedWith.getProject().getProjectTeamCollection()) {
            try {
                this.hdfsUsersController.removeMember(datasetSharedWith.getDataset(), datasetSharedWith.getPermission(), teamMember, dfso);
            }
            catch (IOException e) {
                throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OPERATION_ERROR, Level.FINE, "Failed to remove " + teamMember.getUser().getUsername() + " from dataset group " + datasetSharedWith.getDataset().getName(), e.getMessage());
            }
        }
    }

    public void updateDescription(Project project, Users user, Dataset dataset, String description) {
        if (description != null && !dataset.getDescription().equals(description)) {
            dataset.setDescription(description);
            this.datasetFacade.update(dataset);
            this.activityFacade.persistActivity(" updated dataset description for " + dataset.getName(), project, user, ActivityFlag.DATASET);
        }
    }

    public void makeImmutable(Dataset ds, Project project, Users user, Path path) throws DatasetException {
        PermissionTransition permissionTransition = PermissionTransition.valueOf((DatasetAccessPermission)ds.getPermission(), (DatasetAccessPermission)DatasetAccessPermission.READ_ONLY);
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            this.hdfsUsersController.makeImmutable(path, dfso);
            this.changePermissions(ds, permissionTransition, project, dfso);
            List<DatasetSharedWith> sharedWith = this.datasetSharedWithFacade.findByDataset(ds);
            for (DatasetSharedWith datasetSharedWith : sharedWith) {
                this.updateSharePermission(datasetSharedWith, PermissionTransition.valueOf((DatasetAccessPermission)datasetSharedWith.getPermission(), (DatasetAccessPermission)DatasetAccessPermission.READ_ONLY), project, user, dfso);
            }
        }
        catch (Exception e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PERMISSION_ERROR, Level.FINE, e.getMessage());
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    public void updatePermission(Dataset ds, DatasetAccessPermission datasetPermissions, Project project, Project targetProject, Users user) throws DatasetException {
        if (ds.isShared(project)) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OWNER_ERROR, Level.FINE);
        }
        if (ds.isPublicDs()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PUBLIC_IMMUTABLE, Level.FINE);
        }
        PermissionTransition permissionTransition = PermissionTransition.valueOf((DatasetAccessPermission)ds.getPermission(), (DatasetAccessPermission)datasetPermissions);
        this.changePermissions(ds, permissionTransition, targetProject);
        if (!permissionTransition.noop()) {
            this.activityFacade.persistActivity(" changed dataset permission  of " + ds.getName() + " from " + permissionTransition.getFrom().getDescription() + " to " + permissionTransition.getTo().getDescription(), project, user, ActivityFlag.DATASET);
        }
    }

    public void updateSharePermission(Dataset ds, DatasetAccessPermission datasetPermissions, Project project, String targetProjectName, Users user) throws DatasetException, ProjectException, FeaturestoreException {
        if (ds.isShared(project)) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OWNER_ERROR, Level.FINE);
        }
        if (ds.isPublicDs()) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PUBLIC_IMMUTABLE, Level.FINE);
        }
        Project targetProject = this.projectFacade.findByName(targetProjectName);
        if (targetProject == null) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "Target project not found.");
        }
        DatasetSharedWith datasetSharedWith = this.datasetSharedWithFacade.findByProjectAndDataset(targetProject, ds);
        if (datasetSharedWith == null) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_NOT_SHARED_WITH_PROJECT, Level.FINE, "project: " + targetProject.getName());
        }
        PermissionTransition permissionTransition = PermissionTransition.valueOf((DatasetAccessPermission)datasetSharedWith.getPermission(), (DatasetAccessPermission)datasetPermissions);
        this.updateSharePermission(datasetSharedWith, permissionTransition, project, user);
        if (datasetSharedWith.getDataset().getDsType() == DatasetType.FEATURESTORE) {
            DatasetSharedWith trainingDataset = this.getSharedTrainingDataset(targetProject, datasetSharedWith.getDataset().getProject());
            if (trainingDataset != null) {
                this.updateSharePermission(trainingDataset, permissionTransition, project, user);
            }
            this.onlineFeaturestoreController.shareOnlineFeatureStore(targetProject, datasetSharedWith.getDataset().getFeatureStore(), datasetPermissions);
        }
    }

    private void updateSharePermission(DatasetSharedWith datasetSharedWith, PermissionTransition permissionTransition, Project project, Users user) throws DatasetException {
        this.changePermissions(datasetSharedWith, permissionTransition);
        if (!permissionTransition.noop()) {
            this.activityFacade.persistActivity(" changed dataset share permission  of " + datasetSharedWith.getDataset().getName() + " shared with project " + datasetSharedWith.getProject().getName() + " from " + permissionTransition.getFrom().getDescription() + " to " + permissionTransition.getTo().getDescription(), project, user, ActivityFlag.DATASET);
            this.activityFacade.persistActivity(" changed dataset share permission  of " + datasetSharedWith.getDataset().getName() + " shared with project " + datasetSharedWith.getProject().getName() + " from " + permissionTransition.getFrom().getDescription() + " to " + permissionTransition.getTo().getDescription(), datasetSharedWith.getProject(), user, ActivityFlag.DATASET);
        }
    }

    private void updateSharePermission(DatasetSharedWith datasetSharedWith, PermissionTransition permissionTransition, Project project, Users user, DistributedFileSystemOps dfso) throws DatasetException {
        this.changePermissions(datasetSharedWith, permissionTransition, dfso);
        if (!permissionTransition.noop()) {
            this.activityFacade.persistActivity(" changed dataset share permission  of " + datasetSharedWith.getDataset().getName() + " shared with project " + datasetSharedWith.getProject().getName() + " from " + permissionTransition.getFrom().getDescription() + " to " + permissionTransition.getTo().getDescription(), project, user, ActivityFlag.DATASET);
            this.activityFacade.persistActivity(" changed dataset share permission  of " + datasetSharedWith.getDataset().getName() + " shared with project " + datasetSharedWith.getProject().getName() + " from " + permissionTransition.getFrom().getDescription() + " to " + permissionTransition.getTo().getDescription(), datasetSharedWith.getProject(), user, ActivityFlag.DATASET);
        }
    }

    public void shareWithCluster(Project project, Dataset dataset, Inode datasetInode, Users user, Path path) throws DatasetException {
        if (dataset.isPublicDs()) {
            return;
        }
        if (dataset.isShared(project)) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_OWNER_ERROR, Level.FINE);
        }
        dataset.setPublicDs(SharedState.CLUSTER.state);
        this.makeImmutable(dataset, project, user, path);
        this.logDataset(project, dataset, datasetInode, OperationType.Update);
        this.activityFacade.persistActivity(" shared dataset " + dataset.getName() + " with cluster ", project, user, ActivityFlag.DATASET);
    }

    public void unshareFromCluster(Project project, Dataset dataset, Inode datasetInode, Users user, Path path) throws DatasetException {
        if (!dataset.isPublicDs()) {
            return;
        }
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            this.hdfsUsersController.undoImmutable(path, dfso);
        }
        catch (IOException e) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.DATASET_PERMISSION_ERROR, Level.FINE, e.getMessage());
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
        dataset.setPublicDsState(SharedState.PRIVATE);
        this.datasetFacade.merge(dataset);
        this.logDataset(project, dataset, datasetInode, OperationType.Update);
        this.activityFacade.persistActivity(" unshared dataset " + dataset.getName() + " from cluster ", project, user, ActivityFlag.DATASET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unshareAll(Dataset dataset, Users user) throws DatasetException {
        List<DatasetSharedWith> shared = this.datasetSharedWithFacade.findByDataset(dataset);
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            for (DatasetSharedWith s : shared) {
                this.unshare(dataset.getProject(), user, dataset, s.getProject().getName(), dfso);
            }
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }
}

