/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.transformationFunction;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.transformationFunction.TransformationFunction;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class TransformationFunctionFacade
extends AbstractFacade<TransformationFunction> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public TransformationFunctionFacade() {
        super(TransformationFunction.class);
    }

    public TransformationFunction register(String name, String outputType, Integer version, Featurestore featurestore, Date created, Users user) {
        TransformationFunction transformationFunction = new TransformationFunction();
        transformationFunction.setFeaturestore(featurestore);
        transformationFunction.setName(name);
        transformationFunction.setOutputType(outputType);
        transformationFunction.setVersion(version);
        transformationFunction.setCreated(created);
        transformationFunction.setCreator(user);
        this.em.persist((Object)transformationFunction);
        this.em.flush();
        return transformationFunction;
    }

    public Optional<TransformationFunction> findById(Integer transformationFunctionId) {
        TypedQuery query = this.em.createNamedQuery("TransformationFunction.findById", TransformationFunction.class).setParameter("id", (Object)transformationFunctionId);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo findByFeaturestore(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sort, Featurestore featurestore) {
        String queryStr = this.buildQuery("SELECT tfn FROM TransformationFunction tfn ", filters, sort, "tfn.featurestore = :featurestore ");
        String queryCountStr = this.buildQuery("SELECT COUNT(tfn.id) FROM TransformationFunction tfn ", filters, sort, "tfn.featurestore = :featurestore ");
        TypedQuery query = this.em.createQuery(queryStr, TransformationFunction.class).setParameter("featurestore", (Object)featurestore);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, TransformationFunction.class).setParameter("featurestore", (Object)featurestore);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return this.findAll(offset, limit, filters, (Query)query, (Query)queryCount);
    }

    public AbstractFacade.CollectionInfo findByNameAndFeaturestoreOrderedDescVersion(String name, Featurestore featurestore, Integer offset) {
        TypedQuery query = this.em.createNamedQuery("TransformationFunction.findByNameAndFeaturestoreOrderedDescVersion", TransformationFunction.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name);
        TypedQuery queryCount = this.em.createNamedQuery("TransformationFunction.countByFeaturestore", Long.class).setParameter("featurestore", (Object)featurestore);
        query.setFirstResult(offset.intValue());
        queryCount.setFirstResult(offset.intValue());
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public Optional<TransformationFunction> findByNameVersionAndFeaturestore(String name, Integer version, Featurestore featurestore) {
        try {
            return Optional.of(this.em.createNamedQuery("TransformationFunction.findByNameVersionAndFeaturestore", TransformationFunction.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).setParameter("version", (Object)version).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    private AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Query query, Query queryCount) {
        this.setOffsetAndLim(offset, limit, query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void delete(TransformationFunction transformationFunction) {
        if (transformationFunction != null) {
            this.em.remove(this.em.merge((Object)transformationFunction));
        }
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filters, Query q) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filters) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
        }
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public static enum Filters {
        NAME("NAME", "tsfn.name = :name ", "name", " "),
        VERSION("VERSION", "tsfn.version = :version ", "version", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        NAME("NAME", " tsfn.name ", "DESC"),
        VERSION("VERSION", " tsfn.version ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String toString() {
            return this.value;
        }
    }
}

