/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.project;

import io.hops.hopsworks.common.project.Quotas;
import io.hops.hopsworks.persistence.entity.hdfs.inode.InodeView;
import io.hops.hopsworks.persistence.entity.project.CreationStatus;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProjectDTO {
    private Integer projectId;
    private String projectName;
    private String owner;
    private String description;
    private String dockerImage;
    private Date created;
    private List<String> services;
    private List<ProjectTeam> projectTeam;
    private List<InodeView> datasets;
    private Long inodeid;
    private Quotas quotas;
    private boolean isPreinstalledDockerImage;
    private boolean isOldDockerImage;
    private CreationStatus creationStatus;

    public ProjectDTO() {
    }

    public ProjectDTO(Integer projectId, String projectName, String owner) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.owner = owner;
    }

    public ProjectDTO(Project project, Long inodeid, List<String> services, List<ProjectTeam> projectTeam, Quotas quotas, boolean isPreinstalledDockerImage, boolean isOldDockerImage) {
        this.projectId = project.getId();
        this.inodeid = inodeid;
        this.projectName = project.getName();
        this.owner = project.getOwner().getEmail();
        this.created = project.getCreated();
        this.description = project.getDescription();
        this.dockerImage = project.getDockerImage();
        this.services = services;
        this.projectTeam = projectTeam;
        this.quotas = quotas;
        this.isPreinstalledDockerImage = isPreinstalledDockerImage;
        this.isOldDockerImage = isOldDockerImage;
        this.creationStatus = project.getCreationStatus();
    }

    public ProjectDTO(Project project, Long inodeid, List<String> services, List<ProjectTeam> projectTeam, List<InodeView> datasets, boolean isPreinstalledDockerImage, boolean isOldDockerImage) {
        this.projectId = project.getId();
        this.inodeid = inodeid;
        this.projectName = project.getName();
        this.owner = project.getOwner().getEmail();
        this.created = project.getCreated();
        this.description = project.getDescription();
        this.dockerImage = project.getDockerImage();
        this.services = services;
        this.projectTeam = projectTeam;
        this.datasets = datasets;
        this.isPreinstalledDockerImage = isPreinstalledDockerImage;
        this.isOldDockerImage = isOldDockerImage;
        this.creationStatus = project.getCreationStatus();
    }

    public ProjectDTO(Integer projectId, String projectName, String owner, Date created, String description, boolean isPreinstalledDockerImage, boolean isOldDockerImage, List<String> services, List<ProjectTeam> projectTeam) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.owner = owner;
        this.created = created;
        this.description = description;
        this.isPreinstalledDockerImage = isPreinstalledDockerImage;
        this.isOldDockerImage = isOldDockerImage;
        this.services = services;
        this.projectTeam = projectTeam;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public Long getInodeid() {
        return this.inodeid;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setInodeid(Long inodeid) {
        this.inodeid = inodeid;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public List<ProjectTeam> getProjectTeam() {
        return this.projectTeam;
    }

    public void setProjectTeam(List<ProjectTeam> projectTeams) {
        this.projectTeam = projectTeams;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public List<InodeView> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<InodeView> datasets) {
        this.datasets = datasets;
    }

    public Quotas getQuotas() {
        return this.quotas;
    }

    public void setQuotas(Quotas quotas) {
        this.quotas = quotas;
    }

    public boolean getIsPreinstalledDockerImage() {
        return this.isPreinstalledDockerImage;
    }

    public void setIsPreinstalledDockerImage(boolean isPreinstalledDockerImage) {
        this.isPreinstalledDockerImage = isPreinstalledDockerImage;
    }

    public boolean getIsOldDockerImage() {
        return this.isOldDockerImage;
    }

    public void setIsOldDockerImage(boolean isOldDockerImage) {
        this.isOldDockerImage = isOldDockerImage;
    }

    public CreationStatus getCreationStatus() {
        return this.creationStatus;
    }

    public void setCreationStatus(CreationStatus creationStatus) {
        this.creationStatus = creationStatus;
    }

    public String toString() {
        return "ProjectDTO{projectName=" + this.projectName + ", owner=" + this.owner + ", description=" + this.description + ", created=" + this.created + ", services=" + this.services + ", projectTeam=" + this.projectTeam + ", isPreinstalledDockerImage=" + this.isPreinstalledDockerImage + '}';
    }
}

