/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeatureViewXAttrDTO;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeaturegroupXAttr;
import io.hops.hopsworks.common.featurestore.xattr.dto.TrainingDatasetXAttrDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.hdfs.xattrs.XAttrsController;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.dto.ProvCoreDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvDatasetDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.util.HopsworksJAXBContext;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.MetadataException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless(name="HopsFSProvenanceController")
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HopsFSProvenanceController {
    private static final Logger LOGGER = Logger.getLogger(HopsFSProvenanceController.class.getName());
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    @EJB
    private HopsworksJAXBContext converter;
    @EJB
    private XAttrsController xattrCtrl;
    @EJB
    private InodeController inodeController;

    private ProvCoreDTO getProvCoreXAttr(String path, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            byte[] provTypeB = this.xattrCtrl.getProvXAttr(udfso, path, "core");
            if (provTypeB == null) {
                return null;
            }
            return this.converter.unmarshal(new String(provTypeB), ProvCoreDTO.class);
        }
        catch (DatasetException | GenericException | MetadataException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - get xattr - prov core - error", "hopsfs - get xattr - prov core - error", e);
        }
    }

    private void setProvCoreXAttr(String path, ProvCoreDTO provCore, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            String provType = this.converter.marshal(provCore);
            this.xattrCtrl.upsertProvXAttr(udfso, path, "core", provType.getBytes());
        }
        catch (DatasetException | GenericException | MetadataException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - prov core - error", "hopsfs - set xattr - prov core - error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvTypeDTO getProjectProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        String projectPath = Utils.getProjectPath(project.getName());
        try {
            ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, udfso);
            ProvTypeDTO provTypeDTO = provCore == null ? null : provCore.getType();
            return provTypeDTO;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectProvType(Users user, Project project, ProvTypeDTO provType) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            this.updateProjectProvType(project, provType, udfso);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void updateProjectProvType(Project project, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        String projectPath = Utils.getProjectPath(project.getName());
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, dfso);
        if (provCore != null && newProvType.equals(provCore.getType())) {
            return;
        }
        provCore = new ProvCoreDTO(newProvType, null);
        this.setProvCoreXAttr(projectPath, provCore, dfso);
        provCore = new ProvCoreDTO(newProvType, projectInode.getId());
        for (Dataset dataset : project.getDatasetCollection()) {
            String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
            ProvCoreDTO datasetProvCore = this.getProvCoreXAttr(datasetPath, dfso);
            if (datasetProvCore != null && (datasetProvCore.getType().equals(Provenance.Type.DISABLED.dto) || datasetProvCore.getType().equals(newProvType))) continue;
            this.updateDatasetProvType(datasetPath, provCore, dfso);
        }
    }

    public void updateDatasetProvType(Dataset dataset, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        Inode projectInode = this.inodeController.getProjectRoot(dataset.getProject().getName());
        ProvCoreDTO newProvCore = new ProvCoreDTO(newProvType, projectInode.getId());
        String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
        ProvCoreDTO currentProvCore = this.getProvCoreXAttr(datasetPath, dfso);
        if (currentProvCore != null && currentProvCore.getType().equals(newProvType)) {
            return;
        }
        this.updateDatasetProvType(datasetPath, newProvCore, dfso);
    }

    public void updateHiveDatasetProvCore(Project project, String hiveDBPath, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        ProvCoreDTO newProvCore = new ProvCoreDTO(newProvType, projectInode.getId());
        ProvCoreDTO currentProvCore = this.getProvCoreXAttr(hiveDBPath, dfso);
        if (currentProvCore != null && currentProvCore.getType().equals(newProvType)) {
            return;
        }
        this.updateDatasetProvType(hiveDBPath, newProvCore, dfso);
    }

    private void updateDatasetProvType(String datasetPath, ProvCoreDTO provCore, DistributedFileSystemOps dfso) throws ProvenanceException {
        try {
            dfso.setMetaStatus(datasetPath, provCore.getType().getMetaStatus());
        }
        catch (IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - dataset set meta status error", "hopsfs - dataset set meta status error", (Throwable)e);
        }
        this.setProvCoreXAttr(datasetPath, provCore, dfso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvDatasetDTO> getDatasetsProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            ProvDatasetDTO dsState;
            Path datasetPath;
            ArrayList<ProvDatasetDTO> result = new ArrayList<ProvDatasetDTO>();
            Inode projectInode = this.inodeController.getProjectRoot(project.getName());
            for (Dataset dataset : project.getDatasetCollection()) {
                datasetPath = Utils.getDatasetPath(dataset, this.settings);
                ProvCoreDTO provCore = this.getProvCoreXAttr(datasetPath.toString(), udfso);
                if (provCore == null) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "malformed dataset - provenance", "no provenance core xattr");
                }
                Inode datasetInode = this.inodeController.getProjectDatasetInode(projectInode, datasetPath.toString(), dataset);
                dsState = new ProvDatasetDTO(dataset.getName(), datasetInode.getId(), provCore.getType());
                result.add(dsState);
            }
            for (Dataset dataset : project.getDatasetSharedWithCollection()) {
                datasetPath = Utils.getDatasetPath(dataset.getDataset(), this.settings);
                Inode datasetInode = this.inodeController.getInodeAtPath(datasetPath.toString());
                ProvCoreDTO provCore = this.getProvCoreXAttr(datasetPath.toString(), udfso);
                if (provCore == null) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "malformed dataset - provenance", "no provenance core xattr");
                }
                dsState = new ProvDatasetDTO(dataset.getDataset().getProject().getName() + "::" + dataset.getDataset().getName(), datasetInode.getId(), provCore.getType());
                result.add(dsState);
            }
            ArrayList<ProvDatasetDTO> arrayList = result;
            return arrayList;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void featuregroupAttachXAttrs(String fgPath, FeaturegroupDTO featuregroup, DistributedFileSystemOps udfso) throws ProvenanceException {
        block5: {
            FeaturegroupXAttr.FullDTO fg = this.fromFeaturegroup(featuregroup);
            try {
                byte[] xattrVal = this.converter.marshal(fg).getBytes();
                try {
                    this.xattrCtrl.upsertProvXAttr(udfso, fgPath, "featurestore", xattrVal);
                }
                catch (MetadataException e) {
                    if (RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED.equals((Object)e.getErrorCode())) {
                        LOGGER.log(Level.INFO, "xattr is too large to attach - featuregroup:{0} will not have features attached", fgPath);
                        fg = new FeaturegroupXAttr.FullDTO(featuregroup.getFeaturestoreId(), featuregroup.getDescription(), featuregroup.getCreated(), featuregroup.getCreator().getEmail());
                        xattrVal = this.converter.marshal(fg).getBytes();
                        this.xattrCtrl.upsertProvXAttr(udfso, fgPath, "featurestore", xattrVal);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (DatasetException | GenericException | MetadataException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - featuregroup - error", "hopsfs - set xattr - featuregroup - error", e);
            }
        }
    }

    public void trainingDatasetAttachXAttr(String path, TrainingDatasetDTO trainingDatasetDTO, DistributedFileSystemOps udfso) throws ProvenanceException {
        block5: {
            TrainingDatasetXAttrDTO td = new TrainingDatasetXAttrDTO(trainingDatasetDTO.getFeaturestoreId(), trainingDatasetDTO.getDescription(), trainingDatasetDTO.getCreated(), trainingDatasetDTO.getCreator().getEmail(), this.fromTrainingDataset(trainingDatasetDTO));
            try {
                byte[] xattrVal = this.converter.marshal(td).getBytes();
                try {
                    this.xattrCtrl.upsertProvXAttr(udfso, path, "featurestore", xattrVal);
                }
                catch (MetadataException e) {
                    if (RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED.equals((Object)e.getErrorCode())) {
                        LOGGER.log(Level.INFO, "xattr is too large to attach - trainingdataset:{0} will not have features attached", path);
                        td = new TrainingDatasetXAttrDTO(trainingDatasetDTO.getFeaturestoreId(), trainingDatasetDTO.getDescription(), trainingDatasetDTO.getCreated(), trainingDatasetDTO.getCreator().getEmail());
                        xattrVal = this.converter.marshal(td).getBytes();
                        this.xattrCtrl.upsertProvXAttr(udfso, path, "featurestore", xattrVal);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (DatasetException | GenericException | MetadataException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - training dataset - error", "hopsfs - set xattr - training dataset - error", e);
            }
        }
    }

    public void featureViewAttachXAttr(String path, FeatureView featureView, DistributedFileSystemOps udfso) throws ProvenanceException {
        block5: {
            FeatureViewXAttrDTO fv = new FeatureViewXAttrDTO(featureView.getFeaturestore().getId(), featureView.getDescription(), featureView.getCreated(), featureView.getCreator().getEmail(), this.fromFeatureViewQuery(featureView));
            try {
                byte[] xattrVal = this.converter.marshal(fv).getBytes();
                try {
                    this.xattrCtrl.upsertProvXAttr(udfso, path, "featurestore", xattrVal);
                }
                catch (MetadataException e) {
                    if (RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED.equals((Object)e.getErrorCode())) {
                        LOGGER.log(Level.INFO, "xattr is too large to attach - feature view:{0} will not have features attached", path);
                        fv = new FeatureViewXAttrDTO(featureView.getFeaturestore().getId(), featureView.getDescription(), featureView.getCreated(), featureView.getCreator().getEmail());
                        xattrVal = this.converter.marshal(fv).getBytes();
                        this.xattrCtrl.upsertProvXAttr(udfso, path, "featurestore", xattrVal);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (DatasetException | GenericException | MetadataException e) {
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - feature view - error", "hopsfs - set xattr - feature view - error", e);
            }
        }
    }

    public ProvTypeDTO getMetaStatus(Users user, Project project, Boolean searchable) throws ProvenanceException {
        if (searchable != null && searchable.booleanValue()) {
            ProvTypeDTO projectMetaStatus = this.getProjectProvType(user, project);
            if (Inode.MetaStatus.DISABLED.equals((Object)projectMetaStatus.getMetaStatus())) {
                return Provenance.Type.META.dto;
            }
            return projectMetaStatus;
        }
        return Provenance.Type.DISABLED.dto;
    }

    private List<FeaturegroupXAttr.SimplifiedDTO> fromTrainingDataset(TrainingDatasetDTO trainingDatasetDTO) {
        if (trainingDatasetDTO.getFromQuery().booleanValue()) {
            return this.fromTrainingDatasetQuery(trainingDatasetDTO);
        }
        return this.fromTrainingDatasetDataframe(trainingDatasetDTO);
    }

    private List<FeaturegroupXAttr.SimplifiedDTO> fromTrainingDatasetQuery(TrainingDatasetDTO trainingDatasetDTO) {
        HashMap<Integer, FeaturegroupXAttr.SimplifiedDTO> featuregroups = new HashMap<Integer, FeaturegroupXAttr.SimplifiedDTO>();
        for (TrainingDatasetFeatureDTO feature : trainingDatasetDTO.getFeatures()) {
            FeaturegroupXAttr.SimplifiedDTO featuregroup = (FeaturegroupXAttr.SimplifiedDTO)featuregroups.get(feature.getFeaturegroup().getId());
            if (featuregroup == null) {
                featuregroup = new FeaturegroupXAttr.SimplifiedDTO(feature.getFeaturegroup().getFeaturestoreId(), feature.getFeaturegroup().getName(), feature.getFeaturegroup().getVersion());
                featuregroups.put(feature.getFeaturegroup().getId(), featuregroup);
            }
            featuregroup.addFeature(feature.getName());
        }
        return new ArrayList<FeaturegroupXAttr.SimplifiedDTO>(featuregroups.values());
    }

    private List<FeaturegroupXAttr.SimplifiedDTO> fromFeatureViewQuery(FeatureView featureView) {
        HashMap<Integer, FeaturegroupXAttr.SimplifiedDTO> featuregroups = new HashMap<Integer, FeaturegroupXAttr.SimplifiedDTO>();
        for (TrainingDatasetFeature feature : featureView.getFeatures()) {
            FeaturegroupXAttr.SimplifiedDTO featuregroup = (FeaturegroupXAttr.SimplifiedDTO)featuregroups.get(feature.getFeatureGroup().getId());
            if (featuregroup == null) {
                featuregroup = new FeaturegroupXAttr.SimplifiedDTO(feature.getFeatureGroup().getFeaturestore().getId(), feature.getFeatureGroup().getName(), feature.getFeatureGroup().getVersion());
                featuregroups.put(feature.getFeatureGroup().getId(), featuregroup);
            }
            featuregroup.addFeature(feature.getName());
        }
        return new ArrayList<FeaturegroupXAttr.SimplifiedDTO>(featuregroups.values());
    }

    private List<FeaturegroupXAttr.SimplifiedDTO> fromTrainingDatasetDataframe(TrainingDatasetDTO trainingDatasetDTO) {
        FeaturegroupXAttr.SimplifiedDTO containerFeatureGroup = new FeaturegroupXAttr.SimplifiedDTO(-1, "", -1);
        containerFeatureGroup.addFeatures(trainingDatasetDTO.getFeatures().stream().map(TrainingDatasetFeatureDTO::getName).collect(Collectors.toList()));
        return Arrays.asList(containerFeatureGroup);
    }

    private FeaturegroupXAttr.FullDTO fromFeaturegroup(FeaturegroupDTO featuregroup) {
        LinkedList<FeaturegroupXAttr.SimpleFeatureDTO> features = new LinkedList<FeaturegroupXAttr.SimpleFeatureDTO>();
        for (FeatureGroupFeatureDTO feature : featuregroup.getFeatures()) {
            features.add(new FeaturegroupXAttr.SimpleFeatureDTO(feature.getName(), feature.getDescription()));
        }
        FeaturegroupXAttr.FullDTO fullDTO = new FeaturegroupXAttr.FullDTO(featuregroup.getFeaturestoreId(), featuregroup.getDescription(), featuregroup.getCreated(), featuregroup.getCreator().getEmail(), features);
        if (featuregroup instanceof CachedFeaturegroupDTO) {
            fullDTO.setFgType(FeaturegroupXAttr.FGType.CACHED);
        } else if (featuregroup instanceof StreamFeatureGroupDTO) {
            fullDTO.setFgType(FeaturegroupXAttr.FGType.STREAM);
        } else if (featuregroup instanceof OnDemandFeaturegroupDTO) {
            fullDTO.setFgType(FeaturegroupXAttr.FGType.ON_DEMAND);
        }
        return fullDTO;
    }
}

