/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import fish.payara.nucleus.cluster.PayaraCluster;
import io.hops.hopsworks.common.util.HK2Lookups;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PayaraClusterManager {
    private static final Logger LOGGER = Logger.getLogger(PayaraClusterManager.class.getName());
    private static final String DAS_NAME = "server";
    @Inject
    private HazelcastInstance hazelcastInstance;
    private PayaraCluster cluster;
    private static final int DEFAULT_DAS_PORT = 4900;

    @PostConstruct
    public void init() {
        this.cluster = HK2Lookups.getCluster();
        Optional<String> memberName = this.getMemberName();
        Optional<String> memberGroup = this.getMemberGroup();
        LOGGER.log(Level.INFO, "This Member: {0}, MemberGroup: {1}, Is primary: {2}", new Object[]{memberName.orElse("Unknown"), memberGroup.orElse("Unknown"), this.amIThePrimary()});
    }

    public boolean isDASInstance(Member member) {
        return this.cluster != null ? DAS_NAME.equals(this.cluster.getMemberName(member.getUuid())) : member.getAddress().getPort() == 4900;
    }

    public Optional<String> getMemberName() {
        return this.cluster != null && this.cluster.getUnderlyingHazelcastService().isEnabled() ? Optional.ofNullable(this.cluster.getUnderlyingHazelcastService().getMemberName()) : Optional.empty();
    }

    public String getMemberName(Member member) {
        return this.cluster != null ? this.cluster.getMemberName(member.getUuid()) : member.toString();
    }

    public Optional<String> getMemberGroup() {
        return this.cluster != null && this.cluster.getUnderlyingHazelcastService().isEnabled() ? Optional.ofNullable(this.cluster.getUnderlyingHazelcastService().getMemberGroup()) : Optional.empty();
    }

    public Optional<Member> getLocalMember() {
        if (this.hazelcastInstance == null || this.hazelcastInstance.getCluster().getMembers().size() < 2) {
            return Optional.empty();
        }
        for (Member localMember : this.hazelcastInstance.getCluster().getMembers()) {
            if (!localMember.localMember()) continue;
            return Optional.of(localMember);
        }
        return Optional.empty();
    }

    public String getLocalIp() {
        Optional<Member> localMember = this.getLocalMember();
        return localMember.isPresent() ? localMember.get().getAddress().getHost() : "localhost";
    }

    public boolean amIThePrimary() {
        try {
            if (this.hazelcastInstance == null || this.hazelcastInstance.getCluster().getMembers().size() < 2) {
                return true;
            }
            Iterator iterator = this.hazelcastInstance.getCluster().getMembers().iterator();
            Member oldestMember = (Member)iterator.next();
            if (this.isDASInstance(oldestMember) && iterator.hasNext()) {
                oldestMember = (Member)iterator.next();
                LOGGER.log(Level.FINE, "Oldest Member was DAS getting next member. Primary: {0}", this.getMemberName(oldestMember));
            }
            return oldestMember.localMember();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error checking if node is primary. {0}", ex);
            return true;
        }
    }
}

