/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.expectations;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.suites.ExpectationSuiteFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class ExpectationFacade
extends AbstractFacade<Expectation> {
    private static final Logger LOGGER = Logger.getLogger(ExpectationSuiteFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ExpectationFacade() {
        super(Expectation.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<Expectation> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("Expectation.findById", Expectation.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<Expectation> findByExpectationSuite(ExpectationSuite expectationSuite) {
        String queryStr = "SELECT expec from Expectation expec WHERE expec.expectationSuite = :expectationSuite";
        String queryCountStr = "SELECT COUNT(expec.id) from Expectation expec WHERE expec.expectationSuite = :expectationSuite";
        TypedQuery query = this.em.createQuery(queryStr, Expectation.class).setParameter("expectationSuite", (Object)expectationSuite);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Expectation.class).setParameter("expectationSuite", (Object)expectationSuite);
        return new AbstractFacade.CollectionInfo<Expectation>((Long)queryCount.getSingleResult(), query.getResultList());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void createExpectation(Expectation expectation) {
        try {
            this.em.persist((Object)expectation);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new Expectation", cve);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateExpectation(Expectation expectation) {
        try {
            this.em.merge((Object)expectation);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not update the Expectation", cve);
        }
    }
}

