/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.FsQueryDTO;
import io.hops.hopsworks.common.featurestore.query.HudiFeatureGroupAliasDTO;
import io.hops.hopsworks.common.featurestore.query.OnDemandFeatureGroupAliasDTO;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.filter.FilterController;
import io.hops.hopsworks.common.featurestore.query.join.Join;
import io.hops.hopsworks.common.featurestore.query.join.JoinController;
import io.hops.hopsworks.common.featurestore.query.pit.PitJoinController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.dialect.SparkSqlDialect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ConstructorController {
    @EJB
    private FeaturegroupController featuregroupController;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private FeaturestoreStorageConnectorController storageConnectorController;
    @EJB
    private FilterController filterController;
    @EJB
    private JoinController joinController;
    @EJB
    private PitJoinController pitJoinController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;

    public ConstructorController() {
    }

    public ConstructorController(FeaturegroupController featuregroupController, CachedFeaturegroupController cachedFeaturegroupController, FilterController filterController, JoinController joinController) {
        this.featuregroupController = featuregroupController;
        this.cachedFeaturegroupController = cachedFeaturegroupController;
        this.filterController = filterController;
        this.joinController = joinController;
    }

    public FsQueryDTO construct(Query query, boolean pitEnabled, Project project, Users user) throws FeaturestoreException, ServiceException {
        return this.construct(query, pitEnabled, false, project, user);
    }

    public FsQueryDTO construct(Query query, boolean pitEnabled, boolean isTrainingDataset, Project project, Users user) throws FeaturestoreException, ServiceException {
        FsQueryDTO fsQueryDTO = new FsQueryDTO();
        if (query.getDeletedFeatureGroups() != null && !query.getDeletedFeatureGroups().isEmpty()) {
            fsQueryDTO.setQuery(String.format("Parent feature groups of the following features are not available anymore: %s", String.join((CharSequence)", ", query.getDeletedFeatureGroups())));
            return fsQueryDTO;
        }
        fsQueryDTO.setQuery(this.makeOfflineQuery(query));
        fsQueryDTO.setHudiCachedFeatureGroups(this.getHudiAliases(query));
        fsQueryDTO.setOnDemandFeatureGroups(this.getOnDemandAliases(user, project, query));
        fsQueryDTO.setQueryOnline(this.generateSQL(query, true).toSqlString((SqlDialect)new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql());
        if (pitEnabled) {
            fsQueryDTO.setPitQuery(this.makePitQuery(query, isTrainingDataset));
        }
        return fsQueryDTO;
    }

    String makeOfflineQuery(Query query) {
        HiveSqlDialect offlineSqlDialect = query.getHiveEngine() != false ? new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT) : new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT);
        return this.generateSQL(query, false).toSqlString((SqlDialect)offlineSqlDialect).getSql();
    }

    String makePitQuery(Query query, boolean isTrainingDataset) {
        SqlNode pitQuery = this.pitJoinController.generateSQL(query, isTrainingDataset);
        return query.getHiveEngine() != false ? pitQuery.toSqlString((SqlDialect)new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql() : pitQuery.toSqlString((SqlDialect)new SparkSqlDialect(SqlDialect.EMPTY_CONTEXT)).getSql();
    }

    public SqlSelect generateSQL(Query query, boolean online) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        for (Feature f : this.collectFeatures(query)) {
            if (f.getDefaultValue() == null) {
                selectList.add(this.getWithOrWithoutAs(f, true, true));
                continue;
            }
            selectList.add(this.selectWithDefaultAs(f, true));
        }
        SqlNode joinNode = null;
        joinNode = query.getJoins() == null || query.getJoins().isEmpty() ? this.generateTableNode(query, online) : this.joinController.buildJoinNode(query, query.getJoins().size() - 1, online);
        SqlNode filterNode = null;
        if (query.getJoins() == null || query.getJoins().isEmpty()) {
            if (query.getFilter() != null) {
                filterNode = this.filterController.generateFilterLogicNode(query.getFilter(), online);
            }
        } else {
            filterNode = this.filterController.buildFilterNode(query, query, query.getJoins().size() - 1, online);
        }
        SqlNodeList orderByList = null;
        if (query.getOrderByFeatures() != null && !query.getOrderByFeatures().isEmpty()) {
            orderByList = new SqlNodeList(SqlParserPos.ZERO);
            for (Feature f : query.getOrderByFeatures()) {
                if (f.getDefaultValue() == null) {
                    orderByList.add(this.getWithOrWithoutAs(f, false, false));
                    continue;
                }
                orderByList.add(this.selectWithDefaultAs(f, false));
            }
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, joinNode, filterNode, null, null, null, orderByList, null, null, null);
    }

    public SqlNode caseWhenDefault(Feature feature) {
        SqlIdentifier featureIdentifier = new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias() + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO);
        SqlCall featureIsNull = SqlStdOperatorTable.IS_NULL.createCall(SqlParserPos.ZERO, new SqlNode[]{featureIdentifier});
        Object defaultValue = feature.getType().equalsIgnoreCase("string") ? SqlLiteral.createCharString((String)feature.getDefaultValue(), (SqlParserPos)SqlParserPos.ZERO) : new SqlIdentifier(feature.getDefaultValue(), SqlParserPos.ZERO);
        return new SqlCase(SqlParserPos.ZERO, null, new SqlNodeList(Arrays.asList(featureIsNull), SqlParserPos.ZERO), new SqlNodeList(Arrays.asList(defaultValue), SqlParserPos.ZERO), (SqlNode)featureIdentifier);
    }

    public SqlNode selectWithDefaultAs(Feature feature, boolean withPrefix) {
        String featureName = feature.getName();
        if (feature.getPrefix() != null && withPrefix) {
            featureName = feature.getPrefix() + featureName;
        }
        return SqlStdOperatorTable.AS.createCall(new SqlNodeList(Arrays.asList(this.caseWhenDefault(feature), new SqlIdentifier("`" + featureName + "`", SqlParserPos.ZERO)), SqlParserPos.ZERO));
    }

    public List<Feature> collectFeatures(Query query) {
        List<Feature> features = new ArrayList<Feature>(query.getFeatures());
        if (query.getJoins() != null) {
            for (Join join : query.getJoins()) {
                if (join.getRightQuery() == null || join.getRightQuery().getFeatures() == null) continue;
                if (join.getPrefix() != null) {
                    for (Feature f : join.getRightQuery().getFeatures()) {
                        f.setPrefix(join.getPrefix());
                    }
                }
                features.addAll(this.collectFeatures(join.getRightQuery()));
            }
        }
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP || query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI) {
            features = this.cachedFeaturegroupController.dropHudiSpecFeatures(features);
        }
        return features;
    }

    private SqlNode generateCachedTableNode(Query query, boolean online) {
        ArrayList<String> tableIdentifierStr = new ArrayList<String>();
        if (online) {
            tableIdentifierStr.add("`" + query.getProject() + "`");
            tableIdentifierStr.add("`" + query.getFeaturegroup().getName() + "_" + query.getFeaturegroup().getVersion() + "`");
        } else if (query.getHiveEngine().booleanValue() || !this.isHudiTimeTravelFeatureGroup(query)) {
            tableIdentifierStr.add("`" + query.getFeatureStore() + "`");
            tableIdentifierStr.add("`" + query.getFeaturegroup().getName() + "_" + query.getFeaturegroup().getVersion() + "`");
        } else {
            tableIdentifierStr.add("`" + query.getAs() + "`");
        }
        SqlNodeList asNodeList = new SqlNodeList(Arrays.asList(new SqlIdentifier(tableIdentifierStr, SqlParserPos.ZERO), new SqlIdentifier("`" + query.getAs() + "`", SqlParserPos.ZERO)), SqlParserPos.ZERO);
        return SqlStdOperatorTable.AS.createCall(asNodeList);
    }

    private SqlNode generateOnDemandTableNode(Query query, boolean online) {
        if (online) {
            ArrayList<String> tableIdentifierStr = new ArrayList<String>();
            tableIdentifierStr.add("`" + query.getProject() + "`");
            tableIdentifierStr.add("`" + query.getFeaturegroup().getName() + "_" + query.getFeaturegroup().getVersion() + "`");
            SqlNodeList asNodeList = new SqlNodeList(Arrays.asList(new SqlIdentifier(tableIdentifierStr, SqlParserPos.ZERO), new SqlIdentifier("`" + query.getAs() + "`", SqlParserPos.ZERO)), SqlParserPos.ZERO);
            return SqlStdOperatorTable.AS.createCall(asNodeList);
        }
        return new SqlIdentifier("`" + query.getAs() + "`", SqlParserPos.ZERO);
    }

    public SqlNode generateTableNode(Query query, boolean online) {
        if (query.getFeaturegroup().getFeaturegroupType() != FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            return this.generateCachedTableNode(query, online);
        }
        return this.generateOnDemandTableNode(query, online);
    }

    public List<HudiFeatureGroupAliasDTO> getHudiAliases(Query query) throws ServiceException {
        String featurestoreName;
        FeaturegroupDTO featuregroupDTO;
        ArrayList<HudiFeatureGroupAliasDTO> aliases = new ArrayList<HudiFeatureGroupAliasDTO>();
        Featuregroup featuregroup = query.getFeaturegroup();
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && this.isHudiTimeTravelFeatureGroup(query)) {
            featuregroupDTO = new CachedFeaturegroupDTO(featuregroup);
            featurestoreName = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
            featuregroupDTO.setFeaturestoreName(featurestoreName);
            featuregroupDTO.setLocation(this.featurestoreUtils.resolveLocationURI(featuregroup.getCachedFeaturegroup().getHiveTbls().getSdId().getLocation()));
            aliases.add(new HudiFeatureGroupAliasDTO(query.getAs(), featuregroupDTO, query.getLeftFeatureGroupStartTimestamp(), query.getLeftFeatureGroupEndTimestamp()));
        } else if (featuregroup.getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP && this.isHudiTimeTravelFeatureGroup(query)) {
            featuregroupDTO = new StreamFeatureGroupDTO(featuregroup);
            featurestoreName = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
            featuregroupDTO.setFeaturestoreName(featurestoreName);
            featuregroupDTO.setLocation(this.featurestoreUtils.resolveLocationURI(featuregroup.getStreamFeatureGroup().getHiveTbls().getSdId().getLocation()));
            aliases.add(new HudiFeatureGroupAliasDTO(query.getAs(), featuregroupDTO, query.getLeftFeatureGroupStartTimestamp(), query.getLeftFeatureGroupEndTimestamp()));
        }
        if (query.getJoins() != null && !query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                aliases.addAll(this.getHudiAliases(join.getRightQuery()));
            }
        }
        return aliases;
    }

    private boolean isHudiTimeTravelFeatureGroup(Query query) {
        Boolean isHudiFg = query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP || query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && query.getFeaturegroup().getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI;
        Boolean hasTimeTravel = query.getLeftFeatureGroupStartTimestamp() != null && query.getLeftFeatureGroupStartTimestamp() != 0L || query.getLeftFeatureGroupEndTimestamp() != null;
        return isHudiFg != false && hasTimeTravel != false;
    }

    public List<OnDemandFeatureGroupAliasDTO> getOnDemandAliases(Users user, Project project, Query query) throws FeaturestoreException, ServiceException {
        ArrayList<OnDemandFeatureGroupAliasDTO> aliases = new ArrayList<OnDemandFeatureGroupAliasDTO>();
        if (query.getFeaturegroup().getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            FeaturestoreStorageConnectorDTO storageConnectorDTO = null;
            if (!query.getFeaturegroup().getOnDemandFeaturegroup().isSpine()) {
                storageConnectorDTO = this.storageConnectorController.convertToConnectorDTO(user, project, query.getFeaturegroup().getOnDemandFeaturegroup().getFeaturestoreConnector());
            }
            OnDemandFeaturegroupDTO onDemandFeaturegroupDTO = new OnDemandFeaturegroupDTO(query.getFeaturegroup(), storageConnectorDTO);
            try {
                String path = this.featuregroupController.getFeatureGroupLocation(query.getFeaturegroup());
                onDemandFeaturegroupDTO.setLocation(this.featurestoreUtils.prependNameNode(path));
            }
            catch (ServiceDiscoveryException e) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE);
            }
            aliases.add(new OnDemandFeatureGroupAliasDTO(query.getAs(), onDemandFeaturegroupDTO));
        }
        if (query.getJoins() != null && !query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                aliases.addAll(this.getOnDemandAliases(user, project, join.getRightQuery()));
            }
        }
        return aliases;
    }

    protected SqlNode getWithOrWithoutAs(Feature feature, boolean withAs, boolean withPrefix) {
        if (!withAs) {
            return new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias() + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO);
        }
        String featureName = feature.getName();
        if (feature.getPrefix() != null && withPrefix) {
            featureName = feature.getPrefix() + featureName;
        }
        return SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, new SqlNode[]{new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias() + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO), new SqlIdentifier("`" + featureName + "`", SqlParserPos.ZERO)});
    }
}

