/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.bigquery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.bigquery.FeaturestoreBigqueryConnectorDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.bigquery.FeatureStoreBigqueryConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreBigqueryConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreBigqueryConnectorController.class.getName());
    @EJB
    private StorageConnectorUtil storageConnectorUtil;

    public FeaturestoreBigqueryConnectorController() {
    }

    @VisibleForTesting
    public FeaturestoreBigqueryConnectorController(StorageConnectorUtil storageConnectorUtil) {
        this.storageConnectorUtil = storageConnectorUtil;
    }

    public FeaturestoreBigqueryConnectorDTO getBigqueryConnectorDTO(FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreBigqueryConnectorDTO bigqueryConnectorDTO = new FeaturestoreBigqueryConnectorDTO(featurestoreConnector);
        bigqueryConnectorDTO.setKeyPath(featurestoreConnector.getBigqueryConnector().getKeyPath());
        bigqueryConnectorDTO.setParentProject(featurestoreConnector.getBigqueryConnector().getParentProject());
        bigqueryConnectorDTO.setDataset(featurestoreConnector.getBigqueryConnector().getDataset());
        bigqueryConnectorDTO.setQueryProject(featurestoreConnector.getBigqueryConnector().getQueryProject());
        bigqueryConnectorDTO.setQueryTable(featurestoreConnector.getBigqueryConnector().getQueryTable());
        bigqueryConnectorDTO.setMaterializationDataset(featurestoreConnector.getBigqueryConnector().getMaterializationDataset());
        bigqueryConnectorDTO.setArguments(this.storageConnectorUtil.toOptions(featurestoreConnector.getBigqueryConnector().getArguments()));
        return bigqueryConnectorDTO;
    }

    public FeatureStoreBigqueryConnector createBigqueryConnector(Project project, Users users, FeaturestoreBigqueryConnectorDTO featurestoreBigqueryConnectorDTO) throws FeaturestoreException {
        this.validateInput(project, users, featurestoreBigqueryConnectorDTO);
        FeatureStoreBigqueryConnector featurestoreBigqueryConnector = new FeatureStoreBigqueryConnector();
        return this.setConnectorData(featurestoreBigqueryConnectorDTO, featurestoreBigqueryConnector);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeatureStoreBigqueryConnector updateBigqueryConnector(Project project, Users user, FeaturestoreBigqueryConnectorDTO featurestoreBigqueryConnectorDTO, FeatureStoreBigqueryConnector featureStoreBigqueryConnector) throws FeaturestoreException {
        this.validateInput(project, user, featurestoreBigqueryConnectorDTO);
        return this.setConnectorData(featurestoreBigqueryConnectorDTO, featureStoreBigqueryConnector);
    }

    private FeatureStoreBigqueryConnector setConnectorData(FeaturestoreBigqueryConnectorDTO featurestoreBigqueryConnectorDTO, FeatureStoreBigqueryConnector featureStoreBigqueryConnector) {
        featureStoreBigqueryConnector.setKeyPath(featurestoreBigqueryConnectorDTO.getKeyPath());
        featureStoreBigqueryConnector.setParentProject(featurestoreBigqueryConnectorDTO.getParentProject());
        featureStoreBigqueryConnector.setDataset(featurestoreBigqueryConnectorDTO.getDataset());
        featureStoreBigqueryConnector.setQueryTable(featurestoreBigqueryConnectorDTO.getQueryTable());
        featureStoreBigqueryConnector.setQueryProject(featurestoreBigqueryConnectorDTO.getQueryProject());
        featureStoreBigqueryConnector.setMaterializationDataset(featurestoreBigqueryConnectorDTO.getMaterializationDataset());
        featureStoreBigqueryConnector.setArguments(this.storageConnectorUtil.fromOptions(featurestoreBigqueryConnectorDTO.getArguments()));
        return featureStoreBigqueryConnector;
    }

    public void validateInput(Project project, Users user, FeaturestoreBigqueryConnectorDTO featurestoreBigqueryConnectorDTO) throws FeaturestoreException {
        String arguments;
        this.storageConnectorUtil.validatePath(project, user, featurestoreBigqueryConnectorDTO.getKeyPath(), "Key file path");
        if (Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getParentProject())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Parent Project is mandatory");
        }
        if (!(Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getQueryProject()) && Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getDataset()) && Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getQueryTable()) || !Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getQueryProject()) && !Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getDataset()) && !Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getQueryTable()))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Query Project, Dataset, Table are set either all together or none of them");
        }
        if (Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getQueryProject()) && Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getDataset()) && Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getQueryTable()) && Strings.isNullOrEmpty((String)featurestoreBigqueryConnectorDTO.getMaterializationDataset())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "Materialization Dataset is required if Query Project, Dataset, Table are null");
        }
        if (featurestoreBigqueryConnectorDTO.getArguments() != null && !Strings.isNullOrEmpty((String)(arguments = this.storageConnectorUtil.fromOptions(featurestoreBigqueryConnectorDTO.getArguments()))) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_ARGUMENTS, Level.FINE, "Key-Value arguments should not exceed: 2000 characters");
        }
    }
}

