/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git.util;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.git.CloneCommandConfiguration;
import io.hops.hopsworks.common.git.CommitCommandConfiguration;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandType;
import io.hops.hopsworks.persistence.entity.git.config.GitProvider;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class GitCommandConfigurationValidator {
    private static final Logger LOGGER = Logger.getLogger(GitCommandConfigurationValidator.class.getName());
    private static final Pattern REPO_ATTRS = Pattern.compile("http(s)?://(?<type>.+)/(?<username>.+)/(?<repository>.+)\\.git");
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private Settings settings;
    @EJB
    private DistributedFsService dfs;

    public void verifyCloneOptions(Project project, Users user, CloneCommandConfiguration config) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)config.getUrl())) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.REPOSITORY_URL_NOT_PROVIDED.getMessage());
        }
        if (config.getProvider() == null) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.GIT_PROVIDER_NOT_PROVIDED.getMessage() + "Invalid git provider. Git provider should be one of GitHub, GitLab, or BitBucket");
        }
        this.verifyRepositoryPath(project, user, config.getPath());
    }

    public void verifyCommitOptions(CommitCommandConfiguration commitConfiguration) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)commitConfiguration.getMessage())) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.COMMIT_MESSAGE_IS_EMPTY.getMessage());
        }
        if (!commitConfiguration.isAll().booleanValue() && commitConfiguration.getFiles().isEmpty()) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.COMMIT_FILES_EMPTY.getMessage() + ". Please specify set the all option to true if you want to add and commit all the files.");
        }
    }

    public void verifyRemoteNameAndBranch(String remoteName, String branchName) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)remoteName)) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_REMOTE_NAME.getMessage());
        }
        if (Strings.isNullOrEmpty((String)branchName)) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.INVALID_BRANCH_NAME.getMessage());
        }
    }

    public GitRepository verifyRepository(Project project, Users user, Integer repositoryId) throws GitOpException {
        GitRepository repository = this.verifyRepository(project, repositoryId);
        if (user.equals((Object)repository.getCreator())) {
            return repository;
        }
        throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.USER_IS_NOT_REPOSITORY_OWNER, Level.INFO, "Git operation forbidden. Only repository owners can execute a git command in repository");
    }

    public GitRepository verifyRepository(Project project, Integer repositoryId) throws GitOpException {
        Optional<GitRepository> optional = this.gitRepositoryFacade.findByIdAndProject(project, repositoryId);
        return optional.orElseThrow(() -> new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.REPOSITORY_NOT_FOUND, Level.INFO, "No repository with id [" + repositoryId + "] in project [" + project.getId() + "] found in database."));
    }

    public void verifyReadOnly(GitCommandType gitCommandType, GitRepository repository) throws GitOpException {
        if (this.settings.getEnableGitReadOnlyRepositories().booleanValue() && (gitCommandType == GitCommandType.COMMIT || gitCommandType == GitCommandType.FILE_CHECKOUT || gitCommandType == GitCommandType.PUSH)) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.READ_ONLY_REPOSITORY, Level.INFO, "Git operation forbidden. Repository is read only. Contact your admin to enable this feature.");
        }
    }

    private void verifyRepositoryPath(Project project, Users user, String gitPath) throws IllegalArgumentException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps(project, user);
            if (Strings.isNullOrEmpty((String)gitPath)) {
                throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.DIRECTORY_PATH_NOT_PROVIDED.getMessage());
            }
            if (!dfso.exists(gitPath)) {
                throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.DIRECTORY_PATH_DOES_NOT_EXIST.getMessage());
            }
            if (!dfso.isDir(gitPath)) {
                throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.PATH_IS_NOT_DIRECTORY.getMessage());
            }
            if (this.gitRepositoryFacade.findByPath(gitPath).isPresent()) {
                throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.DIRECTORY_IS_ALREADY_GIT_REPO.getMessage());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(RESTCodes.GitOpErrorCode.ERROR_VALIDATING_REPOSITORY_PATH.getMessage());
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    public void validateProviderConfiguration(BasicAuthSecrets secrets, GitCommandConfiguration gitCommandConfiguration) throws GitOpException {
        GitCommandType commandType = gitCommandConfiguration.getCommandType();
        GitProvider gitProvider = gitCommandConfiguration.getProvider();
        boolean authSecretsConfigured = this.authSecretsConfigured(secrets);
        if (commandType == GitCommandType.PUSH && !authSecretsConfigured || commandType == GitCommandType.CLONE && gitProvider == GitProvider.BITBUCKET && !authSecretsConfigured || commandType == GitCommandType.PULL && (gitProvider == GitProvider.GIT_LAB || gitProvider == GitProvider.BITBUCKET) && !authSecretsConfigured) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_USERNAME_AND_PASSWORD_NOT_SET, Level.WARNING, ". You should setup secrets for " + gitProvider.getProvider() + " to be able to perform a " + commandType.getGitCommand() + " operation");
        }
    }

    public String getRepositoryName(String remoteURI) throws IllegalArgumentException {
        Matcher matcher = REPO_ATTRS.matcher(remoteURI);
        if (matcher.matches()) {
            return matcher.group("repository");
        }
        throw new IllegalArgumentException("Could not parse remote URI: " + remoteURI);
    }

    private boolean authSecretsConfigured(BasicAuthSecrets basicAuthSecrets) {
        return !Strings.isNullOrEmpty((String)basicAuthSecrets.getUsername()) && !Strings.isNullOrEmpty((String)basicAuthSecrets.getPassword());
    }
}

