/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.opensearch.common.settings.Settings;

@Startup
@Singleton
public class OpenSearchCleaner {
    private static final Logger LOGGER = Logger.getLogger(OpenSearchCleaner.class.getName());
    @EJB
    OpenSearchClientController elasticClientCtrl;
    @EJB
    io.hops.hopsworks.common.util.Settings settings;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;

    @PostConstruct
    public void init() {
        long intervalDuration = 86400000L;
        this.timer = this.timerService.createIntervalTimer(0L, intervalDuration, new TimerConfig((Serializable)((Object)"OpenSearch Cleaner timer"), false));
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void deleteLogIndices(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        LOGGER.log(Level.INFO, "Running OpenSearchCleaner.");
        try {
            Function<Settings, Long> creationTimeParser = settings -> {
                try {
                    return Long.parseLong(settings.get("index.creation_date"));
                }
                catch (NullPointerException | NumberFormatException e) {
                    return -1L;
                }
            };
            String indexRegex = "(.*_logs-\\d{4}.\\d{2}.\\d{2})|(.*_serving-\\d{4}.\\d{2}.\\d{2})|(.services-\\d{4}.\\d{2}.\\d{2})|(onlinefs_\\d+-\\d{4}.\\d{2}.\\d{2})";
            Map<String, Long> indices = this.elasticClientCtrl.mngIndicesGetByRegex(indexRegex, creationTimeParser);
            for (String index : indices.keySet()) {
                long indexCreationTime;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (indexCreationTime = indices.get(index).longValue()) <= this.settings.getOpenSearchLogsIndexExpiration()) continue;
                this.elasticClientCtrl.mngIndexDelete(index);
                LOGGER.log(Level.INFO, "Deletedindex:{0}", index);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Index deletion failed", ex);
        }
    }
}

