/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import com.lambdista.util.FailableSupplier;
import com.lambdista.util.Try;
import io.hops.hopsworks.common.opensearch.OpenSearchClient;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchAggregation;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchAggregationParser;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHelper;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHits;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.SSLHandshakeException;
import org.javatuples.Pair;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.GetAliasesResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.GetIndexTemplatesRequest;
import org.opensearch.client.indices.GetIndexTemplatesResponse;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.GetMappingsResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.RestStatus;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class OpenSearchClientController {
    private static final Logger LOG = Logger.getLogger(OpenSearchClientController.class.getName());
    @EJB
    private OpenSearchClient client;

    public GetIndexResponse mngIndexGet(GetIndexRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().indices().get(request, RequestOptions.DEFAULT);
        return (GetIndexResponse)this.executeOpenSearchQuery(query, "opensearch get index", request.toString());
    }

    public String[] mngIndicesGetBySimplifiedRegex(String regex) throws OpenSearchException {
        try {
            return this.mngIndexGet(new GetIndexRequest(new String[]{regex})).getIndices();
        }
        catch (OpenSearchException e) {
            if (OpenSearchHelper.indexNotFound(e.getCause())) {
                return new String[0];
            }
            throw e;
        }
    }

    public String[] mngIndicesGetByRegex(String[] regexes) throws OpenSearchException {
        GetIndexResponse response = this.mngIndexGet(new GetIndexRequest(new String[]{"*"}));
        ArrayList<String> result = new ArrayList<String>();
        for (String index : response.getIndices()) {
            for (String regex : regexes) {
                Pattern pattern = Pattern.compile(regex);
                if (!pattern.matcher(index).matches()) continue;
                result.add(index);
            }
        }
        return result.toArray(new String[0]);
    }

    public <T> Map<String, T> mngIndicesGetByRegex(String regex, Function<Settings, T> indexSettingsParser) throws OpenSearchException {
        GetIndexResponse response = this.mngIndexGet(new GetIndexRequest(new String[]{"*"}));
        HashMap<String, T> result = new HashMap<String, T>();
        Pattern pattern = Pattern.compile(regex);
        Map settings = response.getSettings();
        for (String index : response.getIndices()) {
            if (!pattern.matcher(index).matches()) continue;
            result.put(index, indexSettingsParser.apply((Settings)settings.get(index)));
        }
        return result;
    }

    public Map<String, Map<String, String>> mngIndexGetMappings(String indexRegex) throws OpenSearchException {
        GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{indexRegex});
        FailableSupplier query = () -> this.client.getClient().indices().getMapping(request, RequestOptions.DEFAULT);
        GetMappingsResponse response = (GetMappingsResponse)this.executeOpenSearchQuery(query, "opensearch get index mapping", request.toString());
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry e1 : response.mappings().entrySet()) {
            String index = (String)e1.getKey();
            Map<String, String> mapping = this.parseMapping((Map)((MappingMetadata)e1.getValue()).sourceAsMap().get("properties"));
            result.put(index, mapping);
        }
        return result;
    }

    private Map<String, String> parseMapping(Map mapping) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry e1 : mapping.entrySet()) {
            String key1 = (String)e1.getKey();
            Map value = (Map)e1.getValue();
            if (value.containsKey("type")) {
                result.put(key1, (String)value.get("type"));
                continue;
            }
            if (!value.containsKey("properties")) continue;
            Map<String, String> embeddedMapping = this.parseMapping((Map)value.get("properties"));
            for (Map.Entry<String, String> e2 : embeddedMapping.entrySet()) {
                String key2 = key1 + "." + e2.getKey();
                result.put(key2, e2.getValue());
            }
        }
        return result;
    }

    public boolean mngIndexExists(String indexName) throws OpenSearchException {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        FailableSupplier query = () -> this.client.getClient().indices().exists(request, RequestOptions.DEFAULT);
        return (Boolean)this.executeOpenSearchQuery(query, "opensearch index exists", request.toString());
    }

    public CreateIndexResponse mngIndexCreate(CreateIndexRequest request) throws OpenSearchException {
        if (request.index().length() > 255) {
            String msg = "opensearch index name is too long:" + request.index();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
        if (!request.index().equals(request.index().toLowerCase())) {
            String msg = "opensearch index names can only contain lower case:" + request.index();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
        FailableSupplier query = () -> this.client.getClient().indices().create(request, RequestOptions.DEFAULT);
        CreateIndexResponse response = (CreateIndexResponse)this.executeOpenSearchQuery(query, "opensearch index create", request.toString());
        if (response.isAcknowledged()) {
            return response;
        }
        String msg = "opensearch index:" + request.index() + "creation could not be acknowledged";
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
    }

    public AcknowledgedResponse mngIndexDelete(String index) throws OpenSearchException {
        return this.mngIndexDelete(new DeleteIndexRequest(index));
    }

    public AcknowledgedResponse mngIndexDelete(DeleteIndexRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().indices().delete(request, RequestOptions.DEFAULT);
        AcknowledgedResponse response = (AcknowledgedResponse)this.executeOpenSearchQuery(query, "opensearch index delete", request.toString());
        if (response.isAcknowledged()) {
            return response;
        }
        String msg = "opensearch index:" + request.indices()[0] + "deletion could not be acknowledged";
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
    }

    public void indexDoc(IndexRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().index(request, RequestOptions.DEFAULT);
        IndexResponse response = (IndexResponse)this.executeOpenSearchQuery(query, "opensearch index doc", request.toString());
        if (response.status().getStatus() != 201) {
            String msg = "doc index - bad status response:" + response.status().getStatus();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
    }

    public void updateDoc(UpdateRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().update(request, RequestOptions.DEFAULT);
        UpdateResponse response = (UpdateResponse)this.executeOpenSearchQuery(query, "opensearch update doc", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "doc update - bad status response:" + response.status().getStatus();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
    }

    public MultiSearchResponse multiSearch(MultiSearchRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().msearch(request, RequestOptions.DEFAULT);
        MultiSearchResponse response = (MultiSearchResponse)this.executeOpenSearchQuery(query, "opensearch multi search", request.toString());
        return response;
    }

    public SearchResponse baseSearch(SearchRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().search(request, RequestOptions.DEFAULT);
        SearchResponse response = (SearchResponse)this.executeOpenSearchQuery(query, "opensearch basic search", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "searchBasic query - bad status response:" + response.status().getStatus();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    public <R, S> Pair<Long, Try<S>> search(SearchRequest request, OpenSearchHits.Handler<R, S> handler) throws OpenSearchException {
        SearchResponse response = this.baseSearch(request);
        Try collectedResults = (Try)handler.apply(response.getHits().getHits());
        return Pair.with((Object)response.getHits().getTotalHits().value, (Object)collectedResults);
    }

    public <R, S> Pair<Long, Try<S>> scrolling(SearchResponse response, OpenSearchHits.Handler<R, S> handler, SearchRequest request) throws OpenSearchException {
        long totalHits = response.getHits().getTotalHits().value;
        long leftover = Math.min((long)request.source().size(), totalHits);
        Try result = (Try)handler.apply(response.getHits().getHits());
        if ((leftover -= (long)response.getHits().getHits().length) > 0L && response.getScrollId() == null) {
            response = this.baseSearch(request);
        }
        while (leftover > 0L && result.isSuccess()) {
            SearchScrollRequest next = this.nextScrollPage(response.getScrollId());
            response = this.searchScrollingInt(next);
            leftover -= (long)response.getHits().getHits().length;
            result = (Try)handler.apply(response.getHits().getHits());
        }
        if (response.getScrollId() != null) {
            this.clearScrollingContext(response.getScrollId());
        }
        return Pair.with((Object)totalHits, (Object)result);
    }

    public <R, S> Pair<Long, Try<S>> searchScrolling(SearchRequest request, OpenSearchHits.Handler<R, S> handler) throws OpenSearchException {
        SearchResponse response = this.baseSearch(request);
        return this.scrolling(response, handler, request);
    }

    public <O1, O2, O3> List<Pair<Long, Try<O1>>> multiSearchScrolling(MultiSearchRequest multiSearchRequest, GenericHandlerFactory<O1, O2, O3> handlerFactory) throws OpenSearchException {
        MultiSearchResponse multiSearchResponse = this.multiSearch(multiSearchRequest);
        ArrayList<Pair<Long, Try<O1>>> searchResult = new ArrayList<Pair<Long, Try<O1>>>();
        int index = 0;
        for (MultiSearchResponse.Item item : multiSearchResponse) {
            SearchResponse response = item.getResponse();
            SearchRequest request = (SearchRequest)multiSearchRequest.requests().get(index++);
            searchResult.add(this.scrolling(response, handlerFactory.getHandler(), request));
        }
        return searchResult;
    }

    public long searchCount(SearchRequest request) throws OpenSearchException {
        LOG.log(Level.FINE, "request:{0}", request.toString());
        SearchResponse response = this.baseSearch(request);
        LOG.log(Level.FINE, "response:{0}", response.toString());
        return response.getHits().getTotalHits().value;
    }

    public <A extends OpenSearchAggregation, E extends Exception> Map<A, List> searchAggregations(SearchRequest request, Map<A, OpenSearchAggregationParser<?, E>> aggregations) throws OpenSearchException, E {
        SearchResponse response = this.baseSearch(request);
        LOG.log(Level.FINE, "response:{0}", response.toString());
        HashMap aggResults = new HashMap();
        if (!aggregations.isEmpty()) {
            for (Map.Entry<A, OpenSearchAggregationParser<?, E>> aggregation : aggregations.entrySet()) {
                aggResults.put(aggregation.getKey(), aggregation.getValue().apply(response.getAggregations()));
            }
        }
        return aggResults;
    }

    SearchResponse searchScrollingInt(SearchScrollRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().scroll(request, RequestOptions.DEFAULT);
        SearchResponse response = (SearchResponse)this.executeOpenSearchQuery(query, "opensearch scrolling search", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "searchBasic query - bad status response:" + response.status().getStatus();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    private SearchScrollRequest nextScrollPage(String scrollId) {
        SearchScrollRequest ssr = new SearchScrollRequest(scrollId);
        ssr.scroll(TimeValue.timeValueMinutes((long)1L));
        return ssr;
    }

    ClearScrollResponse clearScrollingContext(String scrollId) throws OpenSearchException {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        FailableSupplier query = () -> this.client.getClient().clearScroll(request, RequestOptions.DEFAULT);
        ClearScrollResponse response = (ClearScrollResponse)this.executeOpenSearchQuery(query, "opensearch scrolling search", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "scroll context clearing query - bad status response:" + response.status().getStatus();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    public void bulkDelete(BulkRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().bulk(request, RequestOptions.DEFAULT);
        BulkResponse response = (BulkResponse)this.executeOpenSearchQuery(query, "opensearch bulk delete", request.toString());
        if (response.hasFailures()) {
            String msg = "failures during bulk delete";
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
    }

    public BulkResponse bulkUpdateDoc(BulkRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().bulk(request, RequestOptions.DEFAULT);
        BulkResponse response = (BulkResponse)this.executeOpenSearchQuery(query, "opensearch bulk update doc", request.toString());
        if (response.status().getStatus() != 200) {
            String msg = "doc update - bad status response:" + response.status().getStatus();
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, msg);
        }
        return response;
    }

    public AcknowledgedResponse aliasUpdate(IndicesAliasesRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().indices().updateAliases(request, RequestOptions.DEFAULT);
        AcknowledgedResponse response = (AcknowledgedResponse)this.executeOpenSearchQuery(query, "opensearch alias update", request.toString());
        if (response.isAcknowledged()) {
            return response;
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INTERNAL_REQ_ERROR, Level.INFO, "error during opensearch alias update");
    }

    public AcknowledgedResponse aliasSwitchIndex(String alias, String fromIndex, String toIndex) throws OpenSearchException {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(fromIndex).alias(alias)).addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(toIndex).alias(alias));
        return this.aliasUpdate(request);
    }

    public GetAliasesResponse aliasGet(GetAliasesRequest request) throws OpenSearchException {
        FailableSupplier query = () -> this.client.getClient().indices().getAlias(request, RequestOptions.DEFAULT);
        GetAliasesResponse response = (GetAliasesResponse)this.executeOpenSearchQuery(query, "opensearch get alias", request.toString());
        if (response.status().equals((Object)RestStatus.OK) || response.status().equals((Object)RestStatus.NOT_FOUND)) {
            return response;
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "error during opensearch get alias");
    }

    public GetAliasesResponse getAliases(String alias) throws OpenSearchException {
        GetAliasesRequest request = new GetAliasesRequest().aliases(new String[]{alias});
        return this.aliasGet(request);
    }

    public AcknowledgedResponse createAlias(String alias, String index) throws OpenSearchException {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(index).alias(alias));
        return this.aliasUpdate(request);
    }

    public ClusterHealthResponse clusterHealthGet() throws OpenSearchException {
        ClusterHealthRequest request = new ClusterHealthRequest();
        FailableSupplier query = () -> this.client.getClient().cluster().health(request, RequestOptions.DEFAULT);
        ClusterHealthResponse response = (ClusterHealthResponse)this.executeOpenSearchQuery(query, "opensearch get cluster health", request.toString());
        if (response.status().equals((Object)RestStatus.OK) || response.status().equals((Object)RestStatus.NOT_FOUND)) {
            return response;
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "error during opensearch get cluster health");
    }

    public GetIndexTemplatesResponse templateGet(String template) throws OpenSearchException {
        GetIndexTemplatesRequest request = new GetIndexTemplatesRequest(new String[]{template});
        FailableSupplier query = () -> this.client.getClient().indices().getIndexTemplate(request, RequestOptions.DEFAULT);
        return (GetIndexTemplatesResponse)this.executeOpenSearchQuery(query, "opensearch get template", request.toString());
    }

    private <O> O executeOpenSearchQuery(FailableSupplier<O> query, String usrMsg, String devMsg) throws OpenSearchException {
        try {
            try {
                LOG.log(Level.FINE, "{0}:{1}", new Object[]{usrMsg, devMsg});
                return (O)query.get();
            }
            catch (SSLHandshakeException e) {
                this.client.resetClient();
                return (O)query.get();
            }
        }
        catch (IndexNotFoundException e) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.INFO, "opensearch index not found during " + usrMsg, devMsg, (Throwable)e);
        }
        catch (OpenSearchStatusException e) {
            if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.INFO, "opensearch index not found during " + usrMsg, devMsg, (Throwable)e);
            }
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INTERNAL_REQ_ERROR, Level.WARNING, "error during " + usrMsg, devMsg, (Throwable)e);
        }
        catch (Throwable e) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INTERNAL_REQ_ERROR, Level.WARNING, "error during " + usrMsg, devMsg, e);
        }
    }

    public static interface GenericHandlerFactory<O1, O2, O3> {
        public OpenSearchHits.Handler<O3, O1> getHandler();

        public O2 checkedResult(Try<O1> var1) throws Exception;
    }
}

