/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.environment;

import com.google.common.collect.Sets;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.python.EnvironmentHistoryFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.history.EnvironmentDelta;
import io.hops.hopsworks.persistence.entity.python.history.LibrarySpec;
import io.hops.hopsworks.persistence.entity.python.history.LibraryUpdate;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.yaml.snakeyaml.Yaml;

@Stateless
public class EnvironmentHistoryController {
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private EnvironmentHistoryFacade environmentHistoryFacade;
    private final String BASE_IMAGE = "BASE";
    private final String UPGRADED_KEY = "upgraded";
    private final String DOWNGRADED_KEY = "downgraded";

    public void computeDelta(Project project, Users user) throws ServiceDiscoveryException, ServiceException {
        String dockerImage = this.projectUtils.getFullDockerImageName(project, false);
        String tag = dockerImage.substring(dockerImage.lastIndexOf(":") + 1);
        Optional<EnvironmentDelta> previousEnvironmentOptional = this.environmentHistoryFacade.getPreviousBuild(project);
        EnvironmentDelta diff = new EnvironmentDelta(project, user, tag, new Date());
        if (!previousEnvironmentOptional.isPresent()) {
            diff.setPreviousDockerImage("BASE");
            this.environmentHistoryFacade.create(diff);
            return;
        }
        EnvironmentDelta previousEnvironment = previousEnvironmentOptional.get();
        Set<LibrarySpec> currentEnvInstalledLibraries = this.getDependencies(project, user, tag);
        Set<LibrarySpec> prevEnvInstalledLibraries = this.getDependencies(project, user, previousEnvironment.getDockerImage());
        diff.setInstalled(new JSONArray(this.getInstalled(currentEnvInstalledLibraries, prevEnvInstalledLibraries)));
        diff.setUninstalled(new JSONArray(this.getUninstalled(currentEnvInstalledLibraries, prevEnvInstalledLibraries)));
        Map<String, List<LibraryUpdate>> updates = this.getLibraryUpdates(currentEnvInstalledLibraries, prevEnvInstalledLibraries);
        diff.setUpgraded(new JSONArray((Collection)updates.get("upgraded")));
        diff.setDowngraded(new JSONArray((Collection)updates.get("downgraded")));
        diff.setPreviousDockerImage(previousEnvironment.getDockerImage());
        this.environmentHistoryFacade.create(diff);
    }

    public Set<LibrarySpec> getDependencies(Project project, Users user, String tag) throws ServiceException {
        ArrayList allDependencies = this.readEnvironment(project, user, tag);
        HashSet<LibrarySpec> allLibraries = new HashSet<LibrarySpec>();
        allLibraries.addAll(this.getPipInstalled(allDependencies));
        allLibraries.addAll(this.getCondaInstalled(allDependencies));
        return allLibraries;
    }

    private Set<LibrarySpec> getPipInstalled(ArrayList allDeps) {
        Set<LibrarySpec> pipInstalled = new HashSet<LibrarySpec>();
        for (int i = allDeps.size() - 1; i >= 0; --i) {
            if (!(allDeps.get(i) instanceof LinkedHashMap)) continue;
            LinkedHashMap lhm = (LinkedHashMap)allDeps.get(i);
            if (!lhm.containsKey("pip")) break;
            pipInstalled = this.parseLibrariesToLibrarySpec((ArrayList)lhm.get("pip"), CondaInstallType.PIP);
            break;
        }
        return pipInstalled;
    }

    private Set<LibrarySpec> getCondaInstalled(ArrayList allDeps) {
        HashSet<LibrarySpec> condaInstalled = new HashSet<LibrarySpec>();
        allDeps.stream().forEach(dep -> {
            if (dep instanceof String) {
                condaInstalled.add(this.parseLibraryToLibrarySpec((String)dep, CondaInstallType.CONDA));
            }
        });
        return condaInstalled;
    }

    private ArrayList readEnvironment(Project project, Users user, String imageTag) throws ServiceException {
        Yaml yaml = new Yaml();
        String environmentYaml = this.readEnvironmentYamlFile(project, user, imageTag);
        LinkedHashMap data = (LinkedHashMap)yaml.load(environmentYaml);
        return (ArrayList)data.get("dependencies");
    }

    private List<LibrarySpec> getUninstalled(Set<LibrarySpec> current, Set<LibrarySpec> previous) {
        List<LibrarySpec> uninstalled = previous.stream().filter(lib -> !current.contains(lib)).collect(Collectors.toList());
        return uninstalled;
    }

    private List<LibrarySpec> getInstalled(Set<LibrarySpec> current, Set<LibrarySpec> previous) {
        List<LibrarySpec> installed = current.stream().filter(lib -> !previous.contains(lib)).collect(Collectors.toList());
        return installed;
    }

    private Map<String, List<LibraryUpdate>> getLibraryUpdates(Set<LibrarySpec> current, Set<LibrarySpec> old) {
        final ArrayList upgraded = new ArrayList();
        final ArrayList downgraded = new ArrayList();
        Map<String, String> currentMap = current.stream().collect(Collectors.toMap(LibrarySpec::getLibrary, lib -> lib.getVersion()));
        Map<String, String> oldMap = old.stream().collect(Collectors.toMap(LibrarySpec::getLibrary, lib -> lib.getVersion()));
        Sets.SetView common = Sets.intersection(current, old);
        common.stream().forEach(lib -> {
            String oldVersion;
            String currentVersion = (String)currentMap.get(lib.getLibrary());
            int compare = currentVersion.compareTo(oldVersion = (String)oldMap.get(lib.getLibrary()));
            if (compare > 0) {
                upgraded.add(new LibraryUpdate(lib.getLibrary(), oldVersion, currentVersion));
            } else if (compare < 0) {
                downgraded.add(new LibraryUpdate(lib.getLibrary(), oldVersion, currentVersion));
            }
        });
        return new HashMap<String, List<LibraryUpdate>>(){
            {
                this.put("upgraded", upgraded);
                this.put("downgraded", downgraded);
            }
        };
    }

    private Set<LibrarySpec> parseLibrariesToLibrarySpec(ArrayList<String> rawLibraries, CondaInstallType condaInstallType) {
        HashSet<LibrarySpec> libraries = new HashSet<LibrarySpec>();
        rawLibraries.stream().forEach(lib -> libraries.add(this.parseLibraryToLibrarySpec((String)lib, condaInstallType)));
        return libraries;
    }

    private LibrarySpec parseLibraryToLibrarySpec(String library, CondaInstallType condaInstallType) {
        String[] libParts = library.split("==");
        if (condaInstallType == CondaInstallType.CONDA) {
            libParts = library.split("=");
        }
        return new LibrarySpec(libParts[0], libParts[1], condaInstallType.name());
    }

    private String readEnvironmentYamlFile(Project project, Users user, String imageTag) throws ServiceException {
        DistributedFileSystemOps dfso = null;
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        try {
            dfso = this.dfs.getDfsOps(hdfsUser);
            String string = dfso.cat(Utils.getProjectPath(project.getName()) + "Resources/.python/" + imageTag + "-" + "environment.yml");
            return string;
        }
        catch (IOException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ENVIRONMENT_YAML_READ_ERROR, Level.SEVERE, "Failed to compute history", e.getMessage(), (Throwable)e);
        }
        finally {
            if (dfso != null) {
                this.dfs.closeDfsClient(dfso);
            }
        }
    }
}

