/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.commands.featurestore.search;

import io.hops.hopsworks.common.dao.commands.search.SearchFSCommandFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.commands.CommandStatus;
import io.hops.hopsworks.persistence.entity.commands.search.SearchFSCommand;
import io.hops.hopsworks.persistence.entity.commands.search.SearchFSCommandOp;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnector;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SearchFSCommandLogger {
    private static final Logger LOGGER = Logger.getLogger(SearchFSCommandLogger.class.getName());
    @EJB
    private SearchFSCommandFacade commandFacade;
    @EJB
    private InodeController inodeCtrl;
    @EJB
    private FeaturegroupController featureGroupCtrl;
    @EJB
    private FeatureViewController featureViewCtrl;
    @EJB
    private TrainingDatasetController trainingDatasetCtrl;
    @EJB
    private Settings settings;

    public void create(Featuregroup featureGroup) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureGroup, SearchFSCommandOp.CREATE);
        this.commandFacade.persistAndFlush(command);
    }

    public void create(FeatureView featureView) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureView, SearchFSCommandOp.CREATE);
        this.commandFacade.persistAndFlush(command);
    }

    public void create(TrainingDataset trainingDataset) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(trainingDataset, SearchFSCommandOp.CREATE);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateFeaturestore(Featuregroup featureGroup) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureGroup, SearchFSCommandOp.UPDATE_FEATURESTORE);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateFeaturestore(FeatureView featureView) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureView, SearchFSCommandOp.UPDATE_FEATURESTORE);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateFeaturestore(TrainingDataset trainingDataset) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(trainingDataset, SearchFSCommandOp.UPDATE_FEATURESTORE);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateKeywords(Featuregroup featureGroup) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureGroup, SearchFSCommandOp.UPDATE_KEYWORDS);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateKeywords(FeatureView featureView) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureView, SearchFSCommandOp.UPDATE_KEYWORDS);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateKeywords(TrainingDataset trainingDataset) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(trainingDataset, SearchFSCommandOp.UPDATE_KEYWORDS);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateTags(Featuregroup featureGroup) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureGroup, SearchFSCommandOp.UPDATE_TAGS);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateTags(FeatureView featureView) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureView, SearchFSCommandOp.UPDATE_TAGS);
        this.commandFacade.persistAndFlush(command);
    }

    public void updateTags(TrainingDataset trainingDataset) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(trainingDataset, SearchFSCommandOp.UPDATE_TAGS);
        this.commandFacade.persistAndFlush(command);
    }

    public void delete(Featuregroup featuregroup) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featuregroup, SearchFSCommandOp.DELETE_ARTIFACT);
        this.commandFacade.persistAndFlush(command);
    }

    public void delete(FeatureView featureView) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(featureView, SearchFSCommandOp.DELETE_ARTIFACT);
        this.commandFacade.persistAndFlush(command);
    }

    public void delete(TrainingDataset trainingDataset) throws FeaturestoreException {
        SearchFSCommand command = this.getCommand(trainingDataset, SearchFSCommandOp.DELETE_ARTIFACT);
        this.commandFacade.persistAndFlush(command);
    }

    public void delete(Project project) {
        SearchFSCommand command = this.getCommand(project, SearchFSCommandOp.DELETE_PROJECT);
        this.commandFacade.persistAndFlush(command);
    }

    private SearchFSCommand getCommand(Featuregroup featureGroup, SearchFSCommandOp op) throws FeaturestoreException {
        SearchFSCommand command = new SearchFSCommand();
        String path = this.featureGroupCtrl.getFeatureGroupLocation(featureGroup);
        Inode inode = this.inodeCtrl.getInodeAtPath(path);
        if (inode == null) {
            LOGGER.log(Level.FINE, "feature group:<{0},{1},{2}> does not have an inode", new Object[]{featureGroup.getId(), featureGroup.getName(), featureGroup.getVersion()});
            return null;
        }
        command.setInodeId(inode.getId());
        command.setProject(featureGroup.getFeaturestore().getProject());
        command.setStatus(CommandStatus.NEW);
        command.setFeatureGroup(featureGroup);
        command.setOp(op);
        return command;
    }

    private SearchFSCommand getCommand(FeatureView featureView, SearchFSCommandOp op) throws FeaturestoreException {
        SearchFSCommand command = new SearchFSCommand();
        String path = this.featureViewCtrl.getLocation(featureView);
        Inode inode = this.inodeCtrl.getInodeAtPath(path);
        if (inode == null) {
            LOGGER.log(Level.FINE, "feature view:<{0},{1},{2}> does not have an inode", new Object[]{featureView.getId(), featureView.getName(), featureView.getVersion()});
            return null;
        }
        command.setInodeId(inode.getId());
        command.setProject(featureView.getFeaturestore().getProject());
        command.setStatus(CommandStatus.NEW);
        command.setFeatureView(featureView);
        command.setOp(op);
        return command;
    }

    private SearchFSCommand getCommand(TrainingDataset trainingDataset, SearchFSCommandOp op) throws FeaturestoreException {
        SearchFSCommand command = new SearchFSCommand();
        FeaturestoreHopsfsConnector fsConnector = this.trainingDatasetCtrl.getHopsFsConnector(trainingDataset).getHopsfsConnector();
        String datasetPath = Utils.getDatasetPath(fsConnector.getHopsfsDataset(), this.settings).toString();
        String tagPath = this.trainingDatasetCtrl.getTrainingDatasetPath(datasetPath, trainingDataset.getName(), trainingDataset.getVersion());
        Inode inode = this.inodeCtrl.getInodeAtPath(tagPath);
        if (inode == null) {
            LOGGER.log(Level.FINE, "training dataset:<{0},{1},{2},{3}> does not have an inode", new Object[]{trainingDataset.getId(), trainingDataset.getFeatureView().getName(), trainingDataset.getFeatureView().getVersion(), trainingDataset.getVersion()});
            return null;
        }
        command.setInodeId(inode.getId());
        command.setProject(trainingDataset.getFeaturestore().getProject());
        command.setStatus(CommandStatus.NEW);
        command.setTrainingDataset(trainingDataset);
        command.setOp(op);
        return command;
    }

    private SearchFSCommand getCommand(Project p, SearchFSCommandOp op) {
        SearchFSCommand command = new SearchFSCommand();
        command.setInodeId(Long.valueOf(-1L));
        command.setProject(p);
        command.setStatus(CommandStatus.NEW);
        command.setOp(op);
        return command;
    }
}

