/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.metadata;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.metadata.TagSchemas;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class TagSchemasFacade
extends AbstractFacade<TagSchemas> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public TagSchemasFacade() {
        super(TagSchemas.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public TagSchemas findByName(String name) {
        TypedQuery q = this.em.createNamedQuery("TagSchemas.findByName", TagSchemas.class);
        q.setParameter("name", (Object)name);
        try {
            return (TagSchemas)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    public AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT f FROM TagSchemas f ", filter, sort, null);
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT f.id) FROM TagSchemas f ", filter, null, null);
        TypedQuery query = this.em.createQuery(queryStr, TagSchemas.class);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, TagSchemas.class);
        this.setFilter(filter, (Query)query);
        this.setFilter(filter, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case ID: {
                q.setParameter(filterBy.getField(), (Object)this.getIntValue(filterBy));
                break;
            }
            case NAME: 
            case NAME_LIKE: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
            }
        }
    }

    public static enum Filters {
        ID("ID", " f.id = :id", "id", ""),
        NAME("NAME", " f.name = :name", "name", ""),
        NAME_LIKE("NAME_LIKE", " UPPER(f.name) LIKE CONCAT(:name_like, '%')", "name_like", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", " f.id ", "ASC"),
        NAME("NAME", " LOWER(f.name) ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String toString() {
            return this.value;
        }
    }
}

