/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.git;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.GitRepositoryRemote;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class GitRepositoryRemotesFacade
extends AbstractFacade<GitRepositoryRemote> {
    private static final Logger LOGGER = Logger.getLogger(GitRepositoryRemotesFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public GitRepositoryRemotesFacade() {
        super(GitRepositoryRemote.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<GitRepositoryRemote> findAllForRepository(GitRepository repository) {
        return this.em.createNamedQuery("GitRepositoryRemote.findAllInRepository", GitRepositoryRemote.class).setParameter("repository", (Object)repository).getResultList();
    }

    public Optional<GitRepositoryRemote> findByNameAndRepository(GitRepository repository, String name) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepositoryRemote.findByNameAndRepository", GitRepositoryRemote.class).setParameter("repository", (Object)repository).setParameter("name", (Object)name).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public void deleteAllInRepository(GitRepository repository) {
        this.em.createNamedQuery("GitRepositoryRemote.deleteAllInRepository").setParameter("repository", (Object)repository).executeUpdate();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateRepositoryRemotes(List<GitRepositoryRemote> remotes, GitRepository repository) {
        this.deleteAllInRepository(repository);
        for (GitRepositoryRemote remote : remotes) {
            this.save(remote);
        }
    }
}

