/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore;

import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class FeaturestoreDTO {
    private Integer featurestoreId;
    private String featurestoreName;
    private Date created;
    private String projectName;
    private Integer projectId;
    private String onlineFeaturestoreName;
    private Double onlineFeaturestoreSize;
    private String offlineFeaturestoreName;
    private String hiveEndpoint;
    private String mysqlServerEndpoint;
    private Boolean onlineEnabled = false;
    private Long numFeatureGroups;
    private Long numTrainingDatasets;
    private Long numStorageConnectors;
    private Long numFeatureViews;

    public FeaturestoreDTO() {
    }

    public FeaturestoreDTO(Featurestore featurestore) {
        this.featurestoreId = featurestore.getId();
        this.created = featurestore.getCreated();
        this.projectName = featurestore.getProject().getName();
        this.projectId = featurestore.getProject().getId();
        this.featurestoreName = null;
        this.onlineFeaturestoreName = null;
        this.offlineFeaturestoreName = null;
        this.hiveEndpoint = null;
        this.mysqlServerEndpoint = null;
        this.onlineFeaturestoreSize = 0.0;
        this.onlineEnabled = false;
    }

    @XmlElement
    public String getFeaturestoreName() {
        return this.featurestoreName;
    }

    public void setFeaturestoreName(String featurestoreName) {
        this.featurestoreName = featurestoreName;
    }

    @XmlElement
    public Integer getFeaturestoreId() {
        return this.featurestoreId;
    }

    @XmlElement
    public Date getCreated() {
        return this.created;
    }

    @XmlElement
    public String getProjectName() {
        return this.projectName;
    }

    @XmlElement
    public Integer getProjectId() {
        return this.projectId;
    }

    @XmlElement
    public String getOnlineFeaturestoreName() {
        return this.onlineFeaturestoreName;
    }

    @XmlElement
    public String getOfflineFeaturestoreName() {
        return this.offlineFeaturestoreName;
    }

    public void setOfflineFeaturestoreName(String offlineFeaturestoreName) {
        this.offlineFeaturestoreName = offlineFeaturestoreName;
    }

    @XmlElement
    public Double getOnlineFeaturestoreSize() {
        return this.onlineFeaturestoreSize;
    }

    public void setOnlineFeaturestoreSize(Double onlineFeaturestoreSize) {
        this.onlineFeaturestoreSize = onlineFeaturestoreSize;
    }

    @XmlElement
    public String getHiveEndpoint() {
        return this.hiveEndpoint;
    }

    public void setHiveEndpoint(String hiveEndpoint) {
        this.hiveEndpoint = hiveEndpoint;
    }

    @XmlElement
    public String getMysqlServerEndpoint() {
        return this.mysqlServerEndpoint;
    }

    public void setMysqlServerEndpoint(String mysqlServerEndpoint) {
        this.mysqlServerEndpoint = mysqlServerEndpoint;
    }

    public void setOnlineFeaturestoreName(String onlineFeaturestoreName) {
        this.onlineFeaturestoreName = onlineFeaturestoreName;
    }

    @XmlElement
    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    public Long getNumFeatureGroups() {
        return this.numFeatureGroups;
    }

    public void setNumFeatureGroups(Long numFeatureGroups) {
        this.numFeatureGroups = numFeatureGroups;
    }

    public Long getNumTrainingDatasets() {
        return this.numTrainingDatasets;
    }

    public void setNumTrainingDatasets(Long numTrainingDatasets) {
        this.numTrainingDatasets = numTrainingDatasets;
    }

    public Long getNumStorageConnectors() {
        return this.numStorageConnectors;
    }

    public void setNumStorageConnectors(Long numStorageConnectors) {
        this.numStorageConnectors = numStorageConnectors;
    }

    public Long getNumFeatureViews() {
        return this.numFeatureViews;
    }

    public void setNumFeatureViews(Long numFeatureViews) {
        this.numFeatureViews = numFeatureViews;
    }

    public String toString() {
        return "FeaturestoreDTO{featurestoreId=" + this.featurestoreId + ", featurestoreName='" + this.featurestoreName + '\'' + ", created=" + this.created + ", projectName='" + this.projectName + '\'' + ", projectId=" + this.projectId + ", onlineFeaturestoreName='" + this.onlineFeaturestoreName + '\'' + ", onlineFeaturestoreSize=" + this.onlineFeaturestoreSize + ", offlineFeaturestoreName='" + this.offlineFeaturestoreName + '\'' + ", hiveEndpoint='" + this.hiveEndpoint + '\'' + ", mysqlServerEndpoint='" + this.mysqlServerEndpoint + '\'' + ", onlineEnabled=" + this.onlineEnabled + ", numFeatureGroups=" + this.numFeatureGroups + ", numTrainingDatasets=" + this.numTrainingDatasets + ", numStorageConnectors=" + this.numStorageConnectors + ", numFeatureViews=" + this.numFeatureViews + '}';
    }
}

