/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featureview;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.hops.hopsworks.common.commands.featurestore.search.SearchFSCommandLogger;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.app.FsJobManagerController;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.provenance.explicit.FeatureViewLinkController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.ServingKey;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoin;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoinCondition;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.hadoop.fs.permission.FsPermission;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureViewController {
    private static final String PATH_TO_FEATURE_VIEW = "%s/.featureviews/%s_%d";
    @EJB
    private FeatureViewFacade featureViewFacade;
    @EJB
    private Settings settings;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    @EJB
    private HopsFSProvenanceController fsProvenanceController;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private TrainingDatasetController trainingDatasetController;
    @EJB
    private ActivityFacade activityFacade;
    @Inject
    private FsJobManagerController fsJobManagerController;
    @EJB
    private FeatureViewLinkController featureViewLinkController;
    @EJB
    private FeaturegroupController featuregroupController;
    @EJB
    private SearchFSCommandLogger searchCommandLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureView createFeatureView(Project project, Users user, FeatureView featureView, Featurestore featurestore) throws FeaturestoreException, ProvenanceException, IOException {
        this.featurestoreUtils.verifyUserProjectEqualsFsProject(user, project, featurestore, FeaturestoreUtils.ActionMessage.CREATE_FEATURE_VIEW);
        if (featureView.getVersion() == null) {
            Integer latestVersion = this.featureViewFacade.findLatestVersion(featureView.getName(), featurestore);
            if (latestVersion != null) {
                featureView.setVersion(Integer.valueOf(latestVersion + 1));
            } else {
                featureView.setVersion(Integer.valueOf(1));
            }
        }
        if (!this.featureViewFacade.findByNameVersionAndFeaturestore(featureView.getName(), featureView.getVersion(), featurestore).isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_ALREADY_EXISTS, Level.FINE, "Feature view: " + featureView.getName() + ", version: " + featureView.getVersion());
        }
        List<TrainingDataset> trainingDatasets = this.trainingDatasetFacade.findByNameAndFeaturestoreExcludeFeatureView(featureView.getName(), featurestore);
        if (trainingDatasets != null && !trainingDatasets.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_ALREADY_EXISTS, Level.FINE, "Name of the feature view collides with an existing training dataset name : " + featureView.getName());
        }
        DistributedFileSystemOps udfso = null;
        try {
            String path = this.getLocation(featureView);
            udfso = this.dfs.getDfsOps(project, user);
            udfso.mkdirs(path, FsPermission.getDefault());
            featureView = this.featureViewFacade.update(featureView);
            this.searchCommandLogger.create(featureView);
            this.fsActivityFacade.logMetadataActivity(user, featureView, FeaturestoreActivityMeta.FV_CREATED);
            this.activityFacade.persistActivity(" created a new feature view " + featureView.getName(), project, user, ActivityFlag.SERVICE);
            this.fsProvenanceController.featureViewAttachXAttr(path.toString(), featureView, udfso);
            this.featureViewLinkController.createParentLinks(featureView);
            this.searchCommandLogger.updateFeaturestore(featureView);
            FeatureView featureView2 = featureView;
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            return featureView2;
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            throw throwable;
        }
    }

    public String getLocation(FeatureView featureView) throws FeaturestoreException {
        Featurestore featurestore = featureView.getFeaturestore();
        String connectorName = featurestore.getProject().getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
        Dataset datasetsFolder = this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + connectorName)).getHopsfsConnector().getHopsfsDataset();
        return String.format(PATH_TO_FEATURE_VIEW, Utils.getDatasetPath(datasetsFolder, this.settings), featureView.getName(), featureView.getVersion());
    }

    public List<FeatureView> getAll() {
        return this.featureViewFacade.findAll();
    }

    public List<FeatureView> getByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        return this.featureViewFacade.findByFeaturestore(featurestore, queryParam);
    }

    public List<FeatureView> getByNameAndFeatureStore(String name, Featurestore featurestore, QueryParam queryParam) throws FeaturestoreException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameAndFeaturestore(name, featurestore, queryParam);
        if (featureViews.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_NOT_FOUND, Level.FINE, String.format("There exists no feature view with the name %s.", name));
        }
        return featureViews;
    }

    public FeatureView getByNameVersionAndFeatureStore(String name, Integer version, Featurestore featurestore) throws FeaturestoreException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        if (featureViews.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_NOT_FOUND, Level.FINE, String.format("There exists no feature view with the name %s and version %d.", name, version));
        }
        return featureViews.get(0);
    }

    public void delete(Users user, Project project, Featurestore featurestore, String name) throws FeaturestoreException, JobException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameAndFeaturestore(name, featurestore);
        this.delete(user, project, featurestore, featureViews);
    }

    public void delete(Users user, Project project, Featurestore featurestore, String name, Integer version) throws FeaturestoreException, JobException {
        List<FeatureView> featureViews = this.featureViewFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        this.delete(user, project, featurestore, featureViews);
    }

    private void delete(Users user, Project project, Featurestore featurestore, List<FeatureView> featureViews) throws FeaturestoreException, JobException {
        if (featureViews == null || featureViews.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_VIEW_NOT_FOUND, Level.FINE, "Provided feature view name or version does not exist.");
        }
        for (FeatureView fv : featureViews) {
            this.featurestoreUtils.verifyFeatureViewDataOwnerOrSelf(user, project, fv, FeaturestoreUtils.ActionMessage.DELETE_FEATURE_VIEW);
        }
        for (FeatureView fv : featureViews) {
            this.trainingDatasetController.delete(user, project, featurestore, fv);
            this.searchCommandLogger.delete(fv);
            this.featureViewFacade.remove(fv);
            this.removeFeatureViewDir(project, user, fv);
            this.fsJobManagerController.deleteJobs(project, user, fv);
            this.activityFacade.persistActivity(" deleted a feature view " + fv.getName(), project, user, ActivityFlag.SERVICE);
        }
    }

    private void removeFeatureViewDir(Project project, Users user, FeatureView featureView) throws FeaturestoreException {
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(project, user);
        try {
            udfso.rm(this.getLocation(featureView), true);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_FEATURE_VIEW, Level.WARNING, "Error removing feature view directory", e.getMessage(), (Throwable)e);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public FeatureView update(Users user, Project project, Featurestore featurestore, String name, Integer version, String description) throws FeaturestoreException {
        FeatureView featureView = this.getByNameVersionAndFeatureStore(name, version, featurestore);
        this.featurestoreUtils.verifyFeatureViewDataOwnerOrSelf(user, project, featureView, FeaturestoreUtils.ActionMessage.UPDATE_FEATURE_VIEW);
        featureView.setDescription(description);
        this.featureViewFacade.update(featureView);
        this.activityFacade.persistActivity(" edited a feature view " + name, project, user, ActivityFlag.SERVICE);
        return this.getByNameVersionAndFeatureStore(name, version, featurestore);
    }

    public List<TrainingDatasetFeature> getFeaturesSorted(Collection<TrainingDatasetFeature> features) {
        return features.stream().sorted((t1, t2) -> {
            if (t1.getIndex() != null) {
                return t1.getIndex().compareTo(t2.getIndex());
            }
            return t1.getName().compareTo(t2.getName());
        }).collect(Collectors.toList());
    }

    public List<ServingKey> getServingKeys(Project project, Users user, FeatureView featureView) throws FeaturestoreException {
        ArrayList servingKeys = Lists.newArrayList();
        HashSet prefixFeatureNames = Sets.newHashSet();
        HashSet featureGroupIdAdded = Sets.newHashSet();
        Optional<TrainingDatasetJoin> leftJoin = featureView.getJoins().stream().filter(join -> join.getIndex().equals(0)).findFirst();
        if (!leftJoin.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.SEVERE, "Cannot construct serving because some feature groups which are used in the query are removed");
        }
        Set leftPrimaryKeys = this.featuregroupController.getFeatures(leftJoin.get().getFeatureGroup(), project, user).stream().filter(FeatureGroupFeatureDTO::getPrimary).map(FeatureGroupFeatureDTO::getName).collect(Collectors.toSet());
        for (TrainingDatasetJoin join2 : featureView.getJoins().stream().sorted(Comparator.comparingInt(TrainingDatasetJoin::getIndex)).collect(Collectors.toList())) {
            HashSet tempPrefixFeatureNames = Sets.newHashSet();
            List primaryKeys = this.featuregroupController.getFeatures(join2.getFeatureGroup(), project, user).stream().filter(FeatureGroupFeatureDTO::getPrimary).collect(Collectors.toList());
            Set primaryKeyNames = primaryKeys.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toSet());
            Collection joinConditions = join2.getConditions() == null ? Lists.newArrayList() : join2.getConditions();
            for (TrainingDatasetJoinCondition condition : joinConditions) {
                ServingKey servingKey = new ServingKey();
                String featureName = condition.getRightFeature();
                if (!primaryKeyNames.contains(featureName)) continue;
                servingKey.setFeatureName(featureName);
                String joinOn = condition.getLeftFeature();
                servingKey.setJoinOn(joinOn);
                servingKey.setRequired(Boolean.valueOf(!leftPrimaryKeys.contains(joinOn)));
                servingKey.setFeatureGroup(join2.getFeatureGroup());
                servingKey.setFeatureView(featureView);
                servingKey.setJoinIndex(join2.getIndex());
                if (servingKey.getRequired().booleanValue()) {
                    servingKey.setPrefix(this.getPrefixCheckCollision(prefixFeatureNames, servingKey.getFeatureName(), join2.getPrefix()));
                } else {
                    servingKey.setPrefix(join2.getPrefix());
                }
                tempPrefixFeatureNames.add((join2.getPrefix() == null ? "" : join2.getPrefix()) + servingKey.getFeatureName());
                servingKeys.add(servingKey);
            }
            for (FeatureGroupFeatureDTO pk : primaryKeys) {
                String prefixFeatureName = pk.getName();
                if (!Strings.isNullOrEmpty((String)join2.getPrefix())) {
                    prefixFeatureName = join2.getPrefix() + pk.getName();
                }
                if (tempPrefixFeatureNames.contains(prefixFeatureName)) continue;
                ServingKey servingKey = new ServingKey();
                servingKey.setFeatureName(pk.getName());
                servingKey.setPrefix(this.getPrefixCheckCollision(prefixFeatureNames, pk.getName(), join2.getPrefix()));
                servingKey.setRequired(Boolean.valueOf(true));
                servingKey.setFeatureGroup(join2.getFeatureGroup());
                servingKey.setJoinIndex(join2.getIndex());
                servingKey.setFeatureView(featureView);
                servingKeys.add(servingKey);
                tempPrefixFeatureNames.add((join2.getPrefix() == null ? "" : join2.getPrefix()) + servingKey.getFeatureName());
            }
            prefixFeatureNames.addAll(tempPrefixFeatureNames);
            featureGroupIdAdded.add(join2.getFeatureGroup().getId());
        }
        Set labelOnlyFgs = featureView.getFeatures().stream().collect(Collectors.groupingBy(TrainingDatasetFeature::getFeatureGroup)).entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().allMatch(TrainingDatasetFeature::isLabel)).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (ServingKey servingKey : servingKeys) {
            if (!labelOnlyFgs.contains(servingKey.getFeatureGroup()) || !servingKeys.stream().noneMatch(key -> (servingKey.getPrefix() + servingKey.getFeatureName()).equals(key.getJoinOn()))) continue;
            servingKey.setRequired(Boolean.valueOf(false));
        }
        return servingKeys;
    }

    private String getPrefixCheckCollision(Set<String> prefixFeatureNames, String featureName, String prefix) {
        String prefixFeatureName = featureName;
        if (!Strings.isNullOrEmpty((String)prefix)) {
            prefixFeatureName = prefix + featureName;
        }
        if (prefixFeatureNames.contains(prefixFeatureName)) {
            String defaultPrefix;
            int i = 0;
            do {
                defaultPrefix = Strings.isNullOrEmpty((String)prefix) ? String.format("%d_", i) : String.format("%d_%s", i, prefix);
                ++i;
            } while (prefixFeatureNames.contains(defaultPrefix + featureName));
            return defaultPrefix;
        }
        return prefix;
    }

    public void setFeaturegroupController(FeaturegroupController featuregroupController) {
        this.featuregroupController = featuregroupController;
    }
}

