/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import io.hops.hopsworks.common.dao.git.GitOpExecutionFacade;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.util.GitCommandOperationUtil;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitOpExecutionState;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class GitTimeoutCommandsMonitor {
    private static final Logger LOGGER = Logger.getLogger(GitTimeoutCommandsMonitor.class.getName());
    private static final Integer BONUS_TIME = 90000;
    private static final Integer WAIT_TIME_BEFORE_EXECUTION_OBJECT_CREATION = 3000;
    @EJB
    private GitOpExecutionFacade gitOpExecutionFacade;
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private GitCommandOperationUtil gitCommandOperationUtil;
    @EJB
    private Settings settings;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;
    private String localMemberIp;

    @PostConstruct
    public void init() {
        this.localMemberIp = this.payaraClusterManager.getLocalIp();
        long intervalDuration = 60000L;
        this.timer = this.timerService.createIntervalTimer(0L, intervalDuration, new TimerConfig((Serializable)((Object)"Git Commands Monitor timer"), false));
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void gitCommandMonitor(Timer timer) {
        LOGGER.log(Level.FINE, "Running GitTimeoutCommandsMonitor");
        List<GitRepository> repositories = this.gitRepositoryFacade.findAllWithOngoingOperations();
        for (GitRepository repository : repositories) {
            Optional<GitOpExecution> optional = this.gitOpExecutionFacade.findRunningInRepository(repository);
            if (optional.isPresent()) {
                long timeElapsed;
                GitOpExecution execution = optional.get();
                if (!execution.getHostname().equals(this.localMemberIp) || (timeElapsed = System.currentTimeMillis() - execution.getExecutionStart()) <= this.settings.getGitJwtExpMs() + (long)BONUS_TIME.intValue()) continue;
                LOGGER.log(Level.INFO, "Killing git execution with Id + [{0}] with state {1}", new Object[]{execution.getId(), execution.getState().toString()});
                this.gitOpExecutionFacade.updateState(execution, GitOpExecutionState.TIMEDOUT, "Timeout");
                this.gitCommandOperationUtil.shutdownCommandService(repository, execution);
                continue;
            }
            if (!this.payaraClusterManager.amIThePrimary()) continue;
            try {
                long executionStart = Long.parseLong(repository.getCid());
                long timeElapsed = System.currentTimeMillis() - executionStart;
                if (timeElapsed <= (long)WAIT_TIME_BEFORE_EXECUTION_OBJECT_CREATION.intValue()) continue;
                LOGGER.log(Level.INFO, "Failed to create execution in repository with Id + [{0}] ", repository.getId());
                this.gitRepositoryFacade.updateRepositoryCid(repository, null);
            }
            catch (NumberFormatException e) {
                this.gitRepositoryFacade.updateRepositoryCid(repository, null);
            }
        }
    }
}

