/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.execution;

import io.hops.hopsworks.common.dao.jobhistory.ExecutionFacade;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.javatuples.Pair;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ExecutionsCleaner {
    private static final Logger LOG = Logger.getLogger(ExecutionsCleaner.class.getName());
    private int batchSize = 2;
    @EJB
    private Settings settings;
    @EJB
    private ExecutionFacade executionFacade;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init() {
        this.batchSize = this.settings.getExecutionsCleanerBatchSize();
        this.timer = this.timerService.createIntervalTimer(10L, (long)this.settings.getExecutionsCleanerInterval(), new TimerConfig((Serializable)((Object)"ExecutionCleaner"), false));
    }

    @PreDestroy
    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=1000L)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Timeout
    public void deleteOrphanExecutions(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        try {
            LOG.log(Level.FINE, "deleteOrphanExecutions start");
            List<Execution> executions = this.executionFacade.findOrphaned((Pair<Integer, Integer>)new Pair((Object)0, (Object)this.batchSize));
            while (!executions.isEmpty()) {
                LOG.log(Level.INFO, "Deleting orphaned executions: " + executions);
                this.executionFacade.batchDelete(executions);
                executions = this.executionFacade.findOrphaned((Pair<Integer, Integer>)new Pair((Object)0, (Object)this.batchSize));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "ExecutionCleaner timer error", ex);
        }
        LOG.log(Level.FINE, "deleteOrphanExecutions end");
    }
}

