/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.jupyter.JupyterController;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class JupyterNotebookCleaner {
    private static final Logger LOGGER = Logger.getLogger(JupyterNotebookCleaner.class.getName());
    @EJB
    private JupyterFacade jupyterFacade;
    @EJB
    private JupyterController jupyterController;
    @EJB
    private Settings settings;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;

    @PostConstruct
    public void init() {
        String rawInterval = this.settings.getJupyterShutdownTimerInterval();
        Long intervalValue = this.settings.getConfTimeValue(rawInterval);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
        intervalValue = intervalTimeunit.toMillis(intervalValue);
        this.timer = this.timerService.createIntervalTimer(intervalValue.longValue(), intervalValue.longValue(), new TimerConfig((Serializable)((Object)"Jupyter Notebook Cleaner"), false));
    }

    @PreDestroy
    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void execute(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        try {
            LOGGER.log(Level.FINE, "Running JupyterNotebookCleaner.");
            List<JupyterProject> servers = this.jupyterFacade.getAllNotebookServers();
            if (servers != null && !servers.isEmpty()) {
                Date currentDate = Calendar.getInstance().getTime();
                for (JupyterProject jp : servers) {
                    if (jp.isNoLimit() || !jp.getExpires().before(currentDate)) continue;
                    try {
                        LOGGER.log(Level.FINE, "Shutting down expired notebook user: " + jp.getUser().getUsername() + " project: " + jp.getProject().getName());
                        this.jupyterController.shutdown(jp.getProject(), jp.getUser(), jp.getSecret(), jp.getCid(), jp.getPort());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Failed to cleanup notebook with port " + jp.getPort(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got an exception while cleaning up jupyter notebooks");
        }
    }
}

