/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.livy;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.dao.jobhistory.YarnApplicationstateFacade;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.persistence.entity.jobs.history.YarnApplicationstate;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

@Stateless
public class LivyController {
    private static final Logger LOGGER = Logger.getLogger(LivyController.class.getName());
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private YarnApplicationstateFacade appStateBean;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;

    public List<LivyMsg.Session> getLivySessionsForProjectUser(Project project, Users user) {
        ArrayList<LivyMsg.Session> sessions = new ArrayList<LivyMsg.Session>();
        LivyMsg sessionList = this.getLivySessions();
        if (sessionList == null || sessionList.getSessions() == null || sessionList.getSessions().length == 0) {
            return sessions;
        }
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        for (LivyMsg.Session s : sessionList.getSessions()) {
            YarnApplicationstate appStates;
            if (!hdfsUsername.equals(s.getProxyUser()) || (appStates = this.appStateBean.findByAppId(s.getAppId())) == null) continue;
            s.setOwner(user.getEmail());
            sessions.add(s);
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LivyMsg getLivySessions() {
        LivyMsg livySession = null;
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.getLivyURL()).path("/sessions");
            livySession = (LivyMsg)target.request().get(LivyMsg.class);
        }
        return livySession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteLivySession(int sessionId) {
        Response res;
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.getLivyURL()).path("/sessions/" + sessionId);
            res = target.request().delete();
        }
        return res.getStatus();
    }

    public void deleteAllLivySessions(Project project, Users user) {
        for (LivyMsg.Session session : this.getLivySessionsForProjectUser(project, user)) {
            this.deleteLivySession(session.getId());
        }
    }

    private String getLivyURL() throws ServiceDiscoveryException {
        Service livy = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.LIVY.getName());
        return "http://" + livy.getAddress() + ":" + livy.getPort();
    }
}

