/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class ServiceCertificateRotationTimer {
    private static final Logger LOG = Logger.getLogger(ServiceCertificateRotationTimer.class.getName());
    private static final String TO_BE_REVOKED = ".cert.pem.TO_BE_REVOKED.{COMMAND_ID}";
    @Resource
    private TimerService timerService;
    @EJB
    private Settings settings;
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    private Timer timer;

    @PostConstruct
    public void init() {
        String rawInterval = this.settings.getServiceKeyRotationInterval();
        Long intervalValue = this.settings.getConfTimeValue(rawInterval);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
        LOG.log(Level.INFO, "Service certificate rotation is configured to run every " + intervalValue + " " + intervalTimeunit.name());
        intervalValue = intervalTimeunit.toMillis(intervalValue);
        if (this.settings.isServiceKeyRotationEnabled()) {
            this.timer = this.timerService.createTimer(intervalValue.longValue(), intervalValue.longValue(), (Serializable)((Object)"Service certificate rotation"));
        }
    }

    @PreDestroy
    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void rotate(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        LOG.log(Level.FINEST, "Rotating service certificates");
        try {
            this.certificatesMgmService.issueServiceKeyRotationCommand();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Got an exception while rotation certificates", e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public String getToBeRevokedSuffix(String commandId) {
        return TO_BE_REVOKED.replaceAll("\\{COMMAND_ID\\}", commandId);
    }
}

