/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class StatisticsConfigDTO {
    private Boolean enabled = true;
    private Boolean histograms = false;
    private Boolean correlations = false;
    private Boolean exactUniqueness = false;
    private List<String> columns = new ArrayList<String>();

    public StatisticsConfigDTO() {
    }

    public StatisticsConfigDTO(StatisticsConfig statisticsConfig) {
        this.enabled = statisticsConfig.isDescriptive();
        this.correlations = statisticsConfig.isCorrelations();
        this.histograms = statisticsConfig.isHistograms();
        this.exactUniqueness = statisticsConfig.isExactUniqueness();
        this.columns = statisticsConfig.getStatisticColumns().stream().map(StatisticColumn::getName).collect(Collectors.toList());
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getHistograms() {
        return this.histograms;
    }

    public void setHistograms(Boolean histograms) {
        this.histograms = histograms;
    }

    public Boolean getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Boolean correlations) {
        this.correlations = correlations;
    }

    public Boolean getExactUniqueness() {
        return this.exactUniqueness;
    }

    public void setExactUniqueness(Boolean exactUniqueness) {
        this.exactUniqueness = exactUniqueness;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public String toString() {
        return "StatisticsConfigDTO{enabled=" + this.enabled + ", histograms=" + this.histograms + ", correlations=" + this.correlations + ", exactUniqueness=" + this.exactUniqueness + ", columns=" + this.columns + '}';
    }
}

