/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.jupyter.CidAndPort;
import io.hops.hopsworks.common.jupyter.JupyterJWT;
import io.hops.hopsworks.common.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

public class JupyterJWTDTO
implements Serializable {
    private static final long serialVersionUID = -5687462769985361531L;
    private Integer projectId;
    private Integer userId;
    private LocalDateTime expiration;
    private String token;
    private String tokenFile;
    private final CidAndPort pidAndPort;

    public JupyterJWTDTO(JupyterJWT jupyterJWT) {
        this.projectId = jupyterJWT.project.getId();
        this.userId = jupyterJWT.user.getUid();
        this.expiration = jupyterJWT.expiration;
        this.token = jupyterJWT.token;
        this.tokenFile = jupyterJWT.tokenFile.toString();
        this.pidAndPort = jupyterJWT.pidAndPort;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public LocalDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(LocalDateTime expiration) {
        this.expiration = expiration;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    public void setTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
    }

    public CidAndPort getPidAndPort() {
        return this.pidAndPort;
    }

    public boolean maybeRenew(LocalDateTime now) {
        return now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    public boolean isExpired() {
        LocalDateTime now = DateUtils.getNow();
        return now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JupyterJWTDTO that = (JupyterJWTDTO)o;
        return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.userId);
    }
}

