/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.commands;

import io.hops.hopsworks.common.commands.CommandException;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.common.dao.commands.CommandFilter;
import io.hops.hopsworks.persistence.entity.commands.Command;
import io.hops.hopsworks.persistence.entity.commands.CommandStatus;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public abstract class CommandFacade<C extends Command>
extends AbstractFacade<C> {
    public static final String STATUS_FIELD = "status";
    public static final String PROJECT_ID_FIELD = "projectId";
    @PersistenceContext(unitName="kthfsPU")
    protected EntityManager em;

    protected CommandFacade(Class<C> entityClass) {
        super(entityClass);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    protected abstract String getTableName();

    public C findById(Long id) {
        String queryStr = "SELECT c FROM " + this.getTableName() + " c WHERE c.id = :id";
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter("id", (Object)id);
        try {
            return (C)((Command)query.getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<C> findByQuery(QueryParam queryParam) throws CommandException {
        if (queryParam == null) {
            throw new CommandException(RESTCodes.CommandErrorCode.INVALID_SQL_QUERY, Level.INFO, "query param is null");
        }
        String queryStrPrefix = "SELECT c FROM " + this.getTableName() + " c ";
        String queryStr = this.buildQuery(queryStrPrefix, queryParam.getFilters(), queryParam.getSorts(), "");
        TypedQuery q = this.em.createQuery(queryStr, this.entityClass);
        this.setParams((Query)q, queryParam.getFilters());
        if (queryParam.getLimit() != null) {
            q.setMaxResults(queryParam.getLimit().intValue());
        }
        return q.getResultList();
    }

    public List<C> updateByQuery(QueryParam queryParam, Consumer<C> update) throws CommandException {
        List<C> result = this.findByQuery(queryParam);
        result.forEach(c -> {
            update.accept(c);
            this.update(c);
        });
        return result;
    }

    public void removeById(Long commandId) {
        this.remove(this.findById(commandId));
    }

    public void persistAndFlush(C command) {
        this.em.persist(command);
        this.em.flush();
    }

    protected void setParams(Query q, Set<AbstractFacade.FilterBy> filters) throws CommandException {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filter : filters) {
            if (filter.getParam() == null) continue;
            this.setParam(q, filter);
        }
    }

    protected void setParam(Query q, AbstractFacade.FilterBy filterBy) throws CommandException {
        block4: {
            try {
                if (filterBy.getField().equals(STATUS_FIELD)) {
                    q.setParameter(filterBy.getField(), (Object)CommandStatus.valueOf((String)filterBy.getParam()));
                    break block4;
                }
                if (filterBy.getField().equals(PROJECT_ID_FIELD)) {
                    q.setParameter(filterBy.getField(), (Object)Integer.parseInt(filterBy.getParam()));
                    break block4;
                }
                String msg = "invalid filter:" + filterBy.toString();
                throw new CommandException(RESTCodes.CommandErrorCode.INVALID_SQL_QUERY, Level.INFO, msg);
            }
            catch (IllegalArgumentException e) {
                String msg = "invalid filter:" + filterBy.toString();
                throw new CommandException(RESTCodes.CommandErrorCode.INVALID_SQL_QUERY, Level.INFO, msg, msg, e);
            }
        }
    }

    public static enum Filters implements CommandFilter
    {
        STATUS_EQ("status", "c.status = :status ", "NEW"),
        STATUS_NEQ("status", "c.status != :status ", "NEW"),
        PROJECT_ID_EQ("projectId", "c.projectId = :projectId", "0");

        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String field, String sql, String defaultParam) {
            this.field = field;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        @Override
        public String getDefaultParam() {
            return this.defaultParam;
        }

        @Override
        public String getValue() {
            return this.name();
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.name();
        }
    }
}

