/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.NamenodeTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.nio.file.Paths;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HopsfsTrainingDatasetController {
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private Settings settings;

    public TrainingDatasetDTO convertHopsfsTrainingDatasetToDTO(TrainingDatasetDTO trainingDatasetDTO, TrainingDataset trainingDataset) throws ServiceException {
        Service namenodeService;
        try {
            namenodeService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.NAMENODE.getNameWithTag((ServiceTags)NamenodeTags.rpc));
        }
        catch (ServiceDiscoveryException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, "Could not find namenode service", e.getMessage(), (Throwable)e);
        }
        String hopsfsPath = Strings.isNullOrEmpty((String)trainingDataset.getConnectorPath()) ? Utils.getDatasetPath(trainingDataset.getFeaturestoreConnector().getHopsfsConnector().getHopsfsDataset(), this.settings).toString() : Paths.get(Utils.getDatasetPath(trainingDataset.getFeaturestoreConnector().getHopsfsConnector().getHopsfsDataset(), this.settings).toString(), trainingDataset.getConnectorPath()).toString();
        trainingDatasetDTO.setLocation(new Path("hopsfs", namenodeService.getAddress() + ":" + namenodeService.getPort(), hopsfsPath).toString());
        FeaturestoreHopsfsConnectorDTO hopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO(trainingDataset.getFeaturestoreConnector());
        trainingDatasetDTO.setStorageConnector(hopsfsConnectorDTO);
        return trainingDatasetDTO;
    }
}

