/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.online;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.MysqlTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class OnlineFeaturestoreFacade {
    private static final Logger LOGGER = Logger.getLogger(OnlineFeaturestoreFacade.class.getName());
    public static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    public static final String MYSQL_JDBC = "jdbc:mysql://";
    public static final String MYSQL_PROPERTIES = "?useSSL=false&allowPublicKeyRetrieval=true";
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private Settings settings;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private SecretsController secretsController;
    @EJB
    private FeaturestoreUtils featurestoreUtils;

    @PostConstruct
    public void init() {
        try {
            Class.forName(MYSQL_DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not load the MySQL JDBC driver: com.mysql.cj.jdbc.Driver", e);
        }
    }

    public void createOnlineFeaturestoreDatabase(String db, Connection connection) throws FeaturestoreException {
        try {
            this.executeUpdate("CREATE DATABASE " + db + ";", connection);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_DB, Level.SEVERE, "Error running create query", se.getMessage(), (Throwable)se);
        }
    }

    public void removeOnlineFeaturestoreDatabase(String db, Connection connection) throws FeaturestoreException {
        try {
            this.executeUpdate("DROP DATABASE IF EXISTS " + db + ";", connection);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_DB, Level.SEVERE, "Error running drop query", se.getMessage(), (Throwable)se);
        }
    }

    public void createOnlineFeaturestoreUser(String user, String pw, Connection connection) throws FeaturestoreException {
        try (PreparedStatement pStmt = connection.prepareStatement("CREATE USER IF NOT EXISTS ? IDENTIFIED BY ?;");
             Statement stmt = connection.createStatement();){
            pStmt.setString(1, user);
            pStmt.setString(2, pw);
            pStmt.executeUpdate();
            stmt.executeUpdate("GRANT NDB_STORED_USER ON *.* TO " + user + ";");
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "Error occurred when trying to create the MySQL database user for an online feature store", se.getMessage(), (Throwable)se);
        }
    }

    public void removeOnlineFeaturestoreUser(String dbUser, Connection connection) throws FeaturestoreException {
        try (PreparedStatement pStmt = connection.prepareStatement("DROP USER IF EXISTS ?");){
            pStmt.setString(1, dbUser);
            pStmt.executeUpdate();
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "An error occurred when trying to delete the MySQL database user for an online feature store", se.getMessage(), (Throwable)se);
        }
    }

    public void grantDataOwnerPrivileges(String dbName, String dbUser, Connection conn) throws FeaturestoreException {
        try {
            this.grantUserPrivileges(dbUser, "GRANT ALL PRIVILEGES ON " + dbName + ".* TO " + dbUser + ";", dbName, conn);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_GRANTING_ONLINE_FEATURESTORE_USER_PRIVILEGES, Level.SEVERE, "Error running the grant query", se.getMessage(), (Throwable)se);
        }
    }

    public void grantDataScientistPrivileges(String dbName, String dbUser, Connection conn) throws FeaturestoreException {
        try {
            this.grantUserPrivileges(dbUser, "GRANT SELECT ON " + dbName + ".* TO " + dbUser + ";", dbName, conn);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_GRANTING_ONLINE_FEATURESTORE_USER_PRIVILEGES, Level.SEVERE, "Error running the grant query", se.getMessage(), (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantUserPrivileges(String dbUser, String grantQuery, String dbName, Connection conn) throws FeaturestoreException, SQLException {
        try (ResultSet resultSet = null;
             PreparedStatement pStmt = conn.prepareStatement("SELECT COUNT(*) FROM mysql.user WHERE User = ?");){
            pStmt.setString(1, dbUser);
            resultSet = pStmt.executeQuery();
            if (resultSet.next() && resultSet.getInt(1) != 0) {
                this.revokeUserPrivileges(dbName, dbUser, conn);
                this.executeUpdate(grantQuery, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureGroupFeatureDTO> getMySQLFeatures(String tableName, String db) throws FeaturestoreException {
        ArrayList<FeatureGroupFeatureDTO> featureGroupFeatureDTOS = new ArrayList<FeatureGroupFeatureDTO>();
        try (ResultSet resultSet = null;
             Connection connection = this.establishAdminConnection();
             PreparedStatement pStmt = connection.prepareStatement("SELECT `COLUMNS`.`COLUMN_NAME`,`COLUMNS`.`COLUMN_TYPE`, `COLUMNS`.`COLUMN_COMMENT` FROM INFORMATION_SCHEMA.`COLUMNS` WHERE `COLUMNS`.`TABLE_NAME`=? AND `COLUMNS`.`TABLE_SCHEMA`=?;");){
            pStmt.setString(1, tableName);
            pStmt.setString(2, db);
            resultSet = pStmt.executeQuery();
            while (resultSet.next()) {
                featureGroupFeatureDTOS.add(new FeatureGroupFeatureDTO(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3)));
            }
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_ONLINE_FEATURES, Level.SEVERE, "Error reading features from schema", se.getMessage(), (Throwable)se);
        }
        return featureGroupFeatureDTOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeUserPrivileges(String dbName, String dbUser, Connection connection) {
        ResultSet resultSet = null;
        try {
            try (PreparedStatement pStmt = connection.prepareStatement("SELECT COUNT(*) FROM information_schema.SCHEMA_PRIVILEGES WHERE GRANTEE = ? AND TABLE_SCHEMA = ?");){
                String grantee = "'" + dbUser + "'@'%'";
                pStmt.setString(1, grantee);
                pStmt.setString(2, dbName);
                resultSet = pStmt.executeQuery();
                if (resultSet.next() && resultSet.getInt(1) != 0) {
                    this.executeUpdate("REVOKE ALL PRIVILEGES ON " + dbName + ".* FROM " + dbUser + ";", connection);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in revoking the privileges", e);
        }
    }

    /*
     * Exception decompiling
     */
    public Boolean checkIfDatabaseExists(String dbName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeUpdateJDBCQuery(String query, String databaseName, Project project, Users user) throws FeaturestoreException {
        try (Connection conn = this.establishUserConnection(databaseName, project, user);
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.MYSQL_JDBC_UPDATE_STATEMENT_ERROR, Level.SEVERE, "project: " + project.getName() + ", Online featurestore database: " + databaseName + " jdbc query: " + query, e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public FeaturegroupPreview executeReadJDBCQuery(String query, String databaseName, Project project, Users user) throws FeaturestoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createOnlineFeaturestoreKafkaOffsetTable(String db, Connection connection) throws FeaturestoreException {
        try {
            this.executeUpdate("CREATE TABLE IF NOT EXISTS `" + db + "`.`kafka_offsets` (\n`topic` varchar(255) COLLATE latin1_general_cs NOT NULL,\n`partition` SMALLINT NOT NULL,\n`offset` BIGINT UNSIGNED NOT NULL,\nPRIMARY KEY (`topic`,`partition`)\n) ENGINE=ndbcluster DEFAULT CHARSET=latin1 COLLATE=latin1_general_cs;", connection);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_KAFKA_OFFSET_TABLE, Level.SEVERE, "Error running create query", se.getMessage(), (Throwable)se);
        }
    }

    private void executeUpdate(String query, Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(query);
        }
    }

    public Connection establishAdminConnection() throws FeaturestoreException {
        try {
            return DriverManager.getConnection(this.getJdbcURL(), this.settings.getVariableFeaturestoreDbAdminUser(), this.settings.getVariableFeaturestoreDbAdminPwd());
        }
        catch (ServiceDiscoveryException | SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, e.getMessage(), e.getMessage(), e);
        }
    }

    private Connection establishUserConnection(String databaseName, Project project, Users user) throws FeaturestoreException {
        String password;
        String dbUsername = this.onlineFeaturestoreController.onlineDbUsername(project, user);
        try {
            password = this.secretsController.get(user, dbUsername).getPlaintext();
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem getting secrets for the JDBC connection to the online FS");
        }
        String jdbcString = "";
        try {
            jdbcString = this.getJdbcURL(databaseName);
            return DriverManager.getConnection(jdbcString, dbUsername, password);
        }
        catch (ServiceDiscoveryException | SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, "project: " + project.getName() + ", database: " + databaseName + ", db user:" + dbUsername + ", jdbcString: " + jdbcString, e.getMessage(), e);
        }
    }

    public String getJdbcURL() throws ServiceDiscoveryException {
        return this.getJdbcURL("");
    }

    public String getJdbcURL(String dbName) throws ServiceDiscoveryException {
        return MYSQL_JDBC + this.serviceDiscoveryController.constructServiceAddressWithPort(HopsworksService.MYSQL.getNameWithTag((ServiceTags)MysqlTags.onlinefs)) + "/" + dbName + MYSQL_PROPERTIES;
    }
}

