/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.jobhistory.ExecutionFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobScheduleV2Facade;
import io.hops.hopsworks.common.jobs.execution.ExecutionController;
import io.hops.hopsworks.common.jobs.scheduler.JobScheduleV2DTO;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jobs.scheduler.JobScheduleV2;
import io.hops.hopsworks.restutils.RESTCodes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JobScheduleV2Controller {
    @EJB
    private JobScheduleV2Facade jobScheduleFacade;
    @Inject
    private ExecutionController executionController;
    @Inject
    private ExecutionFacade executionFacade;

    private void executeSingle(Jobs job, Instant currentTime) throws JobException, ProjectException, ServiceException, GenericException {
        String jobConfig = job.getJobConfig().getDefaultArgs();
        jobConfig = Strings.isNullOrEmpty((String)jobConfig) ? "-start_time " + currentTime.toString() : jobConfig + " -start_time " + currentTime.toString();
        this.executionController.start(job, jobConfig, job.getCreator());
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void executeWithCron() throws JobException, ProjectException, ServiceException, GenericException {
        this.executeWithCron(Instant.now());
    }

    public void executeWithCron(Instant currentTime) throws JobException, ProjectException, ServiceException, GenericException {
        for (JobScheduleV2 jobSchedule : this.jobScheduleFacade.getActiveWithCurrentExecutionTime(currentTime)) {
            if (this.executionFacade.findByJobAndNotFinished(jobSchedule.getJob()).size() > 0) continue;
            this.updateNextExecutionDateTime(currentTime, jobSchedule);
            this.executeSingle(jobSchedule.getJob(), jobSchedule.getNextExecutionDateTime());
        }
    }

    public JobScheduleV2 createSchedule(JobScheduleV2 jobSchedule) {
        jobSchedule.setStartDateTime(jobSchedule.getStartDateTime());
        this.setNextExecutionDateTime(Instant.now(), jobSchedule);
        return this.jobScheduleFacade.update(jobSchedule);
    }

    public void deleteSchedule(Integer jobId) {
        this.jobScheduleFacade.removeByJobId(jobId);
    }

    public JobScheduleV2 updateSchedule(JobScheduleV2DTO jobScheduleV2DTO) throws JobException {
        JobScheduleV2 jobSchedule = this.jobScheduleFacade.getById(jobScheduleV2DTO.getId()).orElseThrow(() -> new JobException(RESTCodes.JobErrorCode.JOB_SCHEDULE_NOT_FOUND, Level.FINE));
        jobSchedule.setEnabled(jobScheduleV2DTO.getEnabled());
        jobSchedule.setCronExpression(jobScheduleV2DTO.getCronExpression());
        jobSchedule.setStartDateTime(jobScheduleV2DTO.getStartDateTime());
        jobSchedule.setEndDateTime(jobScheduleV2DTO.getEndDateTime());
        if (jobSchedule.getStartDateTime() != null && jobSchedule.getNextExecutionDateTime() != null && jobSchedule.getNextExecutionDateTime().isBefore(jobSchedule.getStartDateTime())) {
            jobSchedule.setNextExecutionDateTime(null);
        }
        if (jobSchedule.getEndDateTime() != null && jobSchedule.getNextExecutionDateTime() != null && jobSchedule.getNextExecutionDateTime().isAfter(jobSchedule.getEndDateTime())) {
            jobSchedule.setEnabled(Boolean.valueOf(false));
            jobSchedule.setNextExecutionDateTime(null);
        }
        if (jobSchedule.getEnabled().booleanValue()) {
            this.setNextExecutionDateTime(Instant.now(), jobSchedule);
        }
        return this.jobScheduleFacade.update(jobSchedule);
    }

    public JobScheduleV2 getScheduleByJobId(Integer jobId) throws JobException {
        return this.jobScheduleFacade.getByJobId(jobId).orElseThrow(() -> new JobException(RESTCodes.JobErrorCode.JOB_SCHEDULE_NOT_FOUND, Level.FINE, String.format("There is no schedule for this job id `%d`.", jobId)));
    }

    public Instant computeNextExecutionDateTime(Instant currentTime, JobScheduleV2 jobSchedule) {
        return this.computeNextExecutionDateTime(currentTime, jobSchedule.getNextExecutionDateTime(), jobSchedule.getStartDateTime(), jobSchedule.getEndDateTime(), jobSchedule.getCronExpression());
    }

    public Instant computeNextExecutionDateTime(Instant currentTime, Instant currentExecutionTime, Instant startTime, Instant endTime, String cronExpression) {
        Instant computeFrom = null;
        computeFrom = currentExecutionTime != null ? currentExecutionTime.plusMillis(1L) : (startTime != null ? startTime : currentTime);
        CronParser quartzCronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        Cron parsedCronExpression = quartzCronParser.parse(cronExpression);
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parsedCronExpression);
        Optional nextExecutionTime = executionTime.nextExecution(computeFrom.atZone(ZoneId.of("UTC")));
        if (!nextExecutionTime.isPresent()) {
            return null;
        }
        if (endTime == null || ((ZonedDateTime)nextExecutionTime.get()).toInstant().isBefore(endTime)) {
            return ((ZonedDateTime)nextExecutionTime.get()).toInstant();
        }
        return null;
    }

    private void setNextExecutionDateTime(Instant currentTime, JobScheduleV2 jobSchedule) {
        Instant nextExecutionTime = this.computeNextExecutionDateTime(currentTime, jobSchedule);
        if (nextExecutionTime == null) {
            jobSchedule.setEnabled(Boolean.valueOf(false));
        }
        jobSchedule.setNextExecutionDateTime(nextExecutionTime);
    }

    private JobScheduleV2 updateNextExecutionDateTime(Instant currentTime, JobScheduleV2 jobSchedule) {
        this.setNextExecutionDateTime(currentTime, jobSchedule);
        return this.jobScheduleFacade.update(jobSchedule);
    }
}

