/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.jwt.JWTController;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Startup
@Singleton
public class InvalidatedJWTCleanup {
    private static final Logger LOGGER = Logger.getLogger(InvalidatedJWTCleanup.class.getName());
    @EJB
    private JWTController jWTController;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;

    @PostConstruct
    public void init() {
        long intervalDuration = 86400000L;
        this.timer = this.timerService.createIntervalTimer(0L, intervalDuration, new TimerConfig((Serializable)((Object)"Invalidated JWT cleanup"), false));
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void cleanInvalidatedJwt(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        try {
            int count = this.jWTController.cleanupInvalidTokens();
            LOGGER.log(Level.INFO, "{0} timer event: {1}, removed {2} tokens.", new Object[]{timer.getInfo(), new Date(), count});
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got an exception while cleaning up invalidated jwts", e);
        }
    }
}

