/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.git;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitProvider;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class GitRepositoryFacade
extends AbstractFacade<GitRepository> {
    private static final Logger LOGGER = Logger.getLogger(GitRepositoryFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private UserFacade userFacade;

    public GitRepositoryFacade() {
        super(GitRepository.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<GitRepository> findById(Integer repoId) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepository.findById", GitRepository.class).setParameter("id", (Object)repoId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<GitRepository> getAllInProjectForUser(Project project, Users user, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Integer limit, Integer offset) {
        String repoQueryStr = this.buildQuery("SELECT r FROM GitRepository r ", filters, sorts, "r.project = :project AND r.creator = :creator");
        String countQueryStr = this.buildQuery("SELECT COUNT(r.id) FROM GitRepository r ", filters, sorts, "r.project = :project AND r.creator = :creator");
        TypedQuery countQuery = this.em.createQuery(countQueryStr, GitRepository.class);
        countQuery.setParameter("project", (Object)project);
        countQuery.setParameter("creator", (Object)user);
        TypedQuery repoQuery = this.em.createQuery(repoQueryStr, GitRepository.class);
        repoQuery.setParameter("project", (Object)project);
        repoQuery.setParameter("creator", (Object)user);
        this.setFilter(filters, (Query)countQuery);
        this.setFilter(filters, (Query)repoQuery);
        this.setOffsetAndLim(offset, limit, (Query)repoQuery);
        return new AbstractFacade.CollectionInfo<GitRepository>((Long)countQuery.getSingleResult(), repoQuery.getResultList());
    }

    public List<GitRepository> findAllWithOngoingOperations() {
        return this.em.createNamedQuery("GitRepository.findAllWithRunningOperation", GitRepository.class).getResultList();
    }

    public Optional<GitRepository> findByIdAndProject(Project project, Integer repoId) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepository.findByIdAndProject", GitRepository.class).setParameter("id", (Object)repoId).setParameter("project", (Object)project).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<GitRepository> findByPath(String path) {
        try {
            return Optional.of(this.em.createNamedQuery("GitRepository.findByPath", GitRepository.class).setParameter("path", (Object)path).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public GitRepository create(Project project, GitProvider gitProvider, Users user, String name, String repositoryPath) {
        GitRepository gitRepository = new GitRepository(project, gitProvider, user, name, repositoryPath);
        this.em.persist((Object)gitRepository);
        this.em.flush();
        return gitRepository;
    }

    public GitRepository updateRepository(GitRepository repository) {
        repository = (GitRepository)this.em.merge((Object)repository);
        this.em.flush();
        return repository;
    }

    public GitRepository updateRepositoryCid(GitRepository repository, String pid) {
        repository.setCid(pid);
        return this.updateRepository(repository);
    }

    public void deleteRepository(GitRepository repository) {
        if (repository != null) {
            this.em.remove((Object)repository);
        }
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam().toLowerCase());
                break;
            }
            case USER: {
                q.setParameter(filterBy.getField(), (Object)this.userFacade.findByUsername(filterBy.getParam()));
                break;
            }
        }
    }

    public static enum Filters {
        NAME("NAME", "LOWER(r.name) LIKE CONCAT('%', :name, '%') ", "name", " "),
        USER("USER", "r.creator = :user ", "user", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "r.id ", "DESC"),
        NAME("NAME", "r.name ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

