/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.executors;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.naming.InitialContext;

@Singleton
@Startup
public class ExecutorPoolManager {
    private static final Logger LOGGER = Logger.getLogger(ExecutorPoolManager.class.getName());

    @PostConstruct
    private void init() {
        try {
            ManagedExecutorService jupyterExecutorService = (ManagedExecutorService)InitialContext.doLookup("concurrent/jupyterExecutorService");
            jupyterExecutorService.submit(() -> LOGGER.log(Level.INFO, "Initialized jupyter executor service"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error initializing jupyter executor service", e);
        }
        try {
            ManagedExecutorService hopsExecutorService = (ManagedExecutorService)InitialContext.doLookup("concurrent/hopsExecutorService");
            hopsExecutorService.submit(() -> LOGGER.log(Level.INFO, "Initialized hops executor service"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error initializing hops executor service", e);
        }
    }
}

