/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.code;

import io.hops.hopsworks.common.dao.jobhistory.ExecutionFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.code.CodeActions;
import io.hops.hopsworks.common.featurestore.code.CodeContentFormat;
import io.hops.hopsworks.common.featurestore.code.FeaturestoreCodeFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.jupyter.JupyterController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.code.FeaturestoreCode;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CodeController {
    @EJB
    private Settings settings;
    @EJB
    private JobFacade jobFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private JupyterController jupyterController;
    @EJB
    private FeaturestoreCodeFacade featurestoreCodeFacade;
    @EJB
    private FeatureGroupCommitController featureGroupCommitCommitController;
    @EJB
    private FeaturestoreActivityFacade featurestoreActivityFacade;
    @EJB
    private ExecutionFacade executionFacade;
    private static final String CODE = "code";

    public CodeContentFormat getContentFormat(String path) throws FeaturestoreException {
        try {
            return CodeContentFormat.valueOf(Utils.getExtension(path).orElse(CodeContentFormat.JAR.toString()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CODE_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    public String readContent(Project project, Users user, String path, CodeContentFormat contentFormat, JupyterController.NotebookConversion format) throws FeaturestoreException, ServiceException {
        switch (contentFormat) {
            case JAR: {
                return null;
            }
            case IPYNB: {
                return this.readNotebookContent(project, user, path, format);
            }
            case PY: {
                return this.readPythonFileContent(project, user, path);
            }
            case DBC: {
                return this.readNotebookContent(project, user, path.replace("." + CodeContentFormat.DBC.toString().toLowerCase(), "." + CodeContentFormat.IPYNB.toString().toLowerCase(Locale.ROOT)), format);
            }
        }
        return null;
    }

    private String readNotebookContent(Project project, Users user, String path, JupyterController.NotebookConversion format) throws ServiceException {
        if (format == JupyterController.NotebookConversion.HTML) {
            return this.jupyterController.convertIPythonNotebook(project, user, path, "", format);
        }
        return null;
    }

    private String readPythonFileContent(Project project, Users user, String path) throws FeaturestoreException {
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(project, user);
        try {
            String string = udfso.cat(path);
            return string;
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CODE_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    public FeaturestoreCode registerCode(Project project, Users user, Long codeCommitTimeStamp, Long fgCommitId, String applicationId, Featuregroup featuregroup, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        String path = this.saveCode(project, user, applicationId, featuregroup, entityId, databricksNotebook, databricksArchive, type);
        Timestamp commitTime = new Timestamp(codeCommitTimeStamp);
        FeaturestoreCode featurestoreCode = new FeaturestoreCode((Date)commitTime, featuregroup, path, applicationId);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && featuregroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI || featuregroup.getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP) {
            Optional<FeatureGroupCommit> featureGroupCommit = this.featureGroupCommitCommitController.findCommitByDate(featuregroup, fgCommitId);
            featureGroupCommit.ifPresent(arg_0 -> ((FeaturestoreCode)featurestoreCode).setFeatureGroupCommit(arg_0));
        }
        return this.featurestoreCodeFacade.update(featurestoreCode);
    }

    public FeaturestoreCode registerCode(Project project, Users user, Long codeCommitTimeStamp, String applicationId, TrainingDataset trainingDataset, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        String path = this.saveCode(project, user, applicationId, trainingDataset, entityId, databricksNotebook, databricksArchive, type);
        Timestamp commitTime = new Timestamp(codeCommitTimeStamp);
        FeaturestoreCode featurestoreCode = new FeaturestoreCode((Date)commitTime, trainingDataset, path, applicationId);
        return this.featurestoreCodeFacade.update(featurestoreCode);
    }

    private String saveCode(Project project, Users user, String applicationId, Featuregroup featureGroup, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        if (type == CodeActions.RunType.JOB) {
            this.executionFacade.findByAppId(applicationId).ifPresent(execution -> this.featurestoreActivityFacade.logExecutionActivity(featureGroup, (Execution)execution));
        }
        return this.saveCode(project, user, applicationId, entityId, this.getCodeDirFullPath(project, featureGroup), databricksNotebook, databricksArchive, type);
    }

    private String saveCode(Project project, Users user, String applicationId, TrainingDataset trainingDataset, String entityId, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        return this.saveCode(project, user, applicationId, entityId, this.getCodeDirFullPath(project, trainingDataset), databricksNotebook, databricksArchive, type);
    }

    private String saveCode(Project project, Users user, String applicationId, String entityId, Path dirPath, String databricksNotebook, byte[] databricksArchive, CodeActions.RunType type) throws ServiceException, FeaturestoreException {
        Path filePath;
        switch (type) {
            case JUPYTER: {
                filePath = new Path(dirPath, applicationId + ".ipynb");
                this.jupyterController.versionProgram(project, user, entityId, filePath);
                break;
            }
            case JOB: {
                filePath = this.saveJob(project, user, entityId, dirPath, applicationId);
                break;
            }
            case DATABRICKS: {
                filePath = this.saveDatabricks(project, user, dirPath, databricksNotebook, databricksArchive);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        return filePath.getName();
    }

    private Path saveJob(Project project, Users user, String entityId, Path dirPath, String applicationId) throws FeaturestoreException {
        Jobs job = this.jobFacade.findByProjectAndName(project, entityId);
        String appPath = null;
        if (job.getJobType() == JobType.SPARK || job.getJobType() == JobType.PYSPARK) {
            appPath = ((SparkJobConfiguration)job.getJobConfig()).getAppPath();
        }
        String extension = Utils.getExtension(appPath).orElse("");
        Path path = new Path(dirPath, applicationId + "." + extension);
        String projectUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(projectUsername);
            String notebookString = udfso.cat(appPath);
            udfso.create(path, notebookString);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CODE_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return path;
    }

    public Path saveDatabricks(Project project, Users user, Path dirPath, String databricksNotebook, byte[] databricksArchive) throws FeaturestoreException {
        String uuid = UUID.randomUUID().toString();
        Path notebookPath = new Path(dirPath, uuid + "." + CodeContentFormat.IPYNB.toString().toLowerCase());
        Path archivePath = new Path(dirPath, uuid + "." + CodeContentFormat.DBC.toString().toLowerCase());
        String projectUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(projectUsername);
            udfso.create(notebookPath, databricksNotebook);
            udfso.create(archivePath, databricksArchive);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_CODE, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return notebookPath;
    }

    public Path getCodeDirFullPath(Project project, Featuregroup featureGroup) {
        Path datasetDir = new Path(Utils.getFeaturestorePath(project, this.settings));
        String datasetName = Utils.getFeaturegroupName(featureGroup);
        return this.getCodeDirFullPath(datasetDir, datasetName);
    }

    public Path getCodeDirFullPath(Project project, TrainingDataset trainingDataset) {
        Path datasetDir = new Path(Utils.getProjectPath(project.getName()), project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName());
        String datasetName = Utils.getTrainingDatasetName(trainingDataset);
        return this.getCodeDirFullPath(datasetDir, datasetName);
    }

    private Path getCodeDirFullPath(Path datasetDir, String datasetName) {
        Path codeDir = new Path(datasetDir, CODE);
        return new Path(codeDir, datasetName);
    }
}

