/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.hops.hopsworks.common.jobs.scheduler.JobScheduleV2Controller;
import io.hops.hopsworks.common.jobs.scheduler.JobScheduleV2DTO;
import java.time.Instant;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JobScheduleV2InputValidation {
    @EJB
    private JobScheduleV2Controller jobScheduleV2Controller;

    public void validateJobScheduleDTO(JobScheduleV2DTO schedulerDTO) {
        this.validateScheduleTimes(schedulerDTO);
        this.validateCronExpression(schedulerDTO.getCronExpression());
    }

    private void validateCronExpression(String cronExpression) throws IllegalArgumentException {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        try {
            Cron parsedCron = parser.parse(cronExpression);
            parsedCron.validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid cron expression provided '%s'.", cronExpression));
        }
        this.enforceZeroSecondsInCronExpression(cronExpression);
    }

    private void enforceZeroSecondsInCronExpression(String cronExpression) {
        String secondsCron = cronExpression.split(" ")[0];
        if (!secondsCron.equals("0")) {
            throw new IllegalArgumentException(String.format("Invalid cron expression %s provided. Seconds field '%s'. Seconds should be 0.", cronExpression, secondsCron));
        }
    }

    private void validateScheduleTimes(JobScheduleV2DTO scheduleDTO) {
        Instant currentTime = Instant.now();
        if (scheduleDTO.getCronExpression() == null) {
            throw new IllegalArgumentException(String.format("Cron expression is required in job schedules.", new Object[0]));
        }
        if (this.jobScheduleV2Controller.computeNextExecutionDateTime(currentTime, null, scheduleDTO.getStartDateTime(), scheduleDTO.getEndDateTime(), scheduleDTO.getCronExpression()) == null) {
            throw new IllegalArgumentException(String.format("Invalid job schedule. The next execution time has already passed and will never be triggered", new Object[0]));
        }
    }
}

