/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.environment.DockerFileController;
import io.hops.hopsworks.common.python.environment.DockerImageController;
import io.hops.hopsworks.common.python.environment.DockerRegistryMngr;
import io.hops.hopsworks.common.python.environment.EnvironmentController;
import io.hops.hopsworks.common.python.environment.EnvironmentHistoryController;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.Path;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LibraryInstaller {
    private static final Logger LOG = Logger.getLogger(LibraryInstaller.class.getName());
    private static final Comparator<CondaCommands> ASC_COMPARATOR = new CommandsComparator<CondaCommands>();
    private final AtomicInteger registryGCCycles = new AtomicInteger();
    private Collection<PythonDep> baseImageDeps = null;
    private String baseImageConflictsStr = null;
    private String baseImageEnvYaml = null;
    @Resource
    private TimerService timerService;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private CommandsController commandsController;
    @EJB
    private LibraryController libraryController;
    @EJB
    private EnvironmentController environmentController;
    @EJB
    private Settings settings;
    @Inject
    private DockerRegistryMngr registry;
    private ManagedExecutorService executorService;
    @EJB
    private DockerImageController dockerImageController;
    @EJB
    private DockerFileController dockerFileController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @EJB
    private EnvironmentHistoryController environmentHistoryController;
    private Timer timer;

    @PostConstruct
    public void init() {
        try {
            this.commandsController.failAllOngoing();
            this.executorService = (ManagedExecutorService)InitialContext.doLookup("concurrent/condaExecutorService");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error looking up for the condaExecutorService", e);
        }
        this.schedule();
    }

    @PreDestroy
    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void schedule() {
        this.timer = this.timerService.createSingleActionTimer(1000L, new TimerConfig((Serializable)((Object)"python library installer"), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void isAlive() {
        try {
            if (!this.payaraClusterManager.amIThePrimary()) {
                return;
            }
            LOG.log(Level.FINE, "isAlive-start: " + System.currentTimeMillis());
            this.registryGCCycles.incrementAndGet();
            List<CondaCommands> allCondaCommandsOngoing = this.condaCommandFacade.findByStatus(CondaStatus.ONGOING);
            if (this.registryGCCycles.get() % 10 == 0 && allCondaCommandsOngoing.isEmpty()) {
                this.registryGCCycles.set(0);
                try {
                    LOG.log(Level.FINE, "registryGC-start: " + System.currentTimeMillis());
                    this.gc();
                    LOG.log(Level.FINE, "registryGC-stop: " + System.currentTimeMillis());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Could not run conda remove commands", ex);
                }
            } else {
                Map<Project, List<CondaCommands>> allCondaCommandsNewByProject = this.getCondaLibraryCommandsByProject(this.condaCommandFacade.findByStatus(CondaStatus.NEW));
                Map<Project, List<CondaCommands>> allCondaCommandsOngoingByProject = this.getCondaLibraryCommandsByProject(this.condaCommandFacade.findByStatus(CondaStatus.ONGOING));
                LOG.log(Level.FINE, "allCondaCommandsOngoingByProject:" + allCondaCommandsOngoingByProject);
                for (Project project : allCondaCommandsNewByProject.keySet()) {
                    if (!allCondaCommandsOngoingByProject.containsKey(project)) {
                        try {
                            allCondaCommandsNewByProject.get(project).sort(ASC_COMPARATOR);
                            CondaCommands commandToExecute = allCondaCommandsNewByProject.get(project).get(0);
                            if (this.condaCommandFacade.findCondaCommand(commandToExecute.getId()) == null) {
                                LOG.log(Level.FINE, "Command with ID " + commandToExecute.getId() + " not found, skipping...");
                                continue;
                            }
                            this.commandsController.updateCondaCommandStatus(commandToExecute.getId(), CondaStatus.ONGOING, commandToExecute.getArg(), commandToExecute.getOp());
                            this.executorService.submit(() -> this.condaCommandHandler(commandToExecute));
                        }
                        catch (Exception ex) {
                            LOG.log(Level.WARNING, "Could not run conda commands for project: " + project, ex);
                        }
                        continue;
                    }
                    LOG.log(Level.FINE, "Project " + project.getName() + " is already processing a conda command, skipping...");
                }
            }
        }
        finally {
            LOG.log(Level.FINE, "isAlive-stop: " + System.currentTimeMillis());
            this.schedule();
        }
    }

    private void condaCommandHandler(CondaCommands commandToExecute) {
        if (commandToExecute.getOp() != CondaOp.REMOVE) {
            try {
                try {
                    switch (commandToExecute.getOp()) {
                        case CREATE: 
                        case IMPORT: {
                            this.createNewImage(commandToExecute);
                            break;
                        }
                        case INSTALL: {
                            this.installLibrary(commandToExecute);
                            break;
                        }
                        case UNINSTALL: {
                            this.uninstallLibrary(commandToExecute);
                            break;
                        }
                        case EXPORT: {
                            this.exportEnvironment(commandToExecute);
                            break;
                        }
                        case SYNC_BASE_ENV: {
                            this.syncBaseLibraries(commandToExecute);
                            break;
                        }
                        case CUSTOM_COMMANDS: {
                            this.buildWithCustomCommands(commandToExecute);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("conda command unknown: " + commandToExecute.getOp());
                        }
                    }
                }
                catch (Throwable ex) {
                    LOG.log(Level.WARNING, "Could not execute command with ID: " + commandToExecute.getId(), ex);
                    this.commandsController.updateCondaCommandStatus(commandToExecute.getId(), CondaStatus.FAILED, commandToExecute.getArg(), commandToExecute.getOp(), this.errorMsg(ex));
                    return;
                }
                this.commandsController.updateCondaCommandStatus(commandToExecute.getId(), CondaStatus.SUCCESS, commandToExecute.getArg(), commandToExecute.getOp());
            }
            catch (ProjectException ex) {
                LOG.log(Level.WARNING, "Could not update command with ID: " + commandToExecute.getId(), ex);
            }
        }
    }

    private String errorMsg(Throwable ex) {
        return this.errorMsg(ex, "");
    }

    private String errorMsg(Throwable ex, String prefix) {
        String errorMsg = ex.getMessage();
        if (errorMsg == null) {
            errorMsg = ExceptionUtils.getStackTrace((Throwable)ex);
        }
        if (Strings.isNullOrEmpty((String)errorMsg)) {
            errorMsg = "Command failed due to exception:" + ex.getClass().getSimpleName();
        }
        if ((errorMsg = prefix + errorMsg).length() > 10000) {
            errorMsg = errorMsg.substring(0, 10000);
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewImage(CondaCommands cc) throws ServiceDiscoveryException, ProjectException, PythonException, ServiceException {
        Project project = this.getProject(cc);
        File cwd = this.dockerFileController.createTmpDir(cc.getProjectId());
        try {
            String dockerFileName = "dockerFile_" + cc.getProjectId().getName();
            String baseImage = this.projectUtils.getFullBaseImageName();
            if (!Strings.isNullOrEmpty((String)cc.getEnvironmentFile()) && !cc.getInstallJupyter().booleanValue()) {
                baseImage = baseImage.replace(this.settings.getBaseDockerImagePythonName(), this.settings.getBaseNonPythonDockerImage());
            }
            File dockerFile = this.dockerFileController.createNewImage(cwd, dockerFileName, baseImage, cc);
            String initialDockerImage = this.projectUtils.getInitialDockerImageName(project);
            this.dockerImageController.buildImage(initialDockerImage, dockerFile.getAbsolutePath(), cwd);
            this.updateProjectDockerImage(cc, initialDockerImage);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)cwd);
            }
            catch (IOException e) {
                String errorMsg = "Failed removing docker file";
                throw new ServiceException(RESTCodes.ServiceErrorCode.LOCAL_FILESYSTEM_ERROR, Level.INFO, errorMsg, errorMsg, (Throwable)e);
            }
        }
    }

    private void updateProjectDockerImage(CondaCommands cc, String dockerImage) throws PythonException, ServiceException, ServiceDiscoveryException, ProjectException {
        Project project = this.getProject(cc);
        project.setDockerImage(dockerImage);
        project = this.projectFacade.update(project);
        this.projectFacade.flushEm();
        this.updateInstalledDependencies(project);
        this.exportEnvironment(project, cc.getUserId());
    }

    private Project updateInstalledDependencies(Project project) throws ServiceException, PythonException {
        String dockerImage = null;
        try {
            dockerImage = this.projectUtils.getFullDockerImageName(project, false);
        }
        catch (ServiceDiscoveryException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_DISCOVERY_ERROR, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
        String condaListOutput = this.dockerImageController.listLibraries(dockerImage);
        Collection<PythonDep> projectDeps = this.libraryController.parseCondaList(condaListOutput);
        projectDeps = this.libraryController.addOngoingOperations(project.getCondaCommandsCollection(), projectDeps);
        project.setPythonDepCollection(projectDeps);
        String pipConflictStr = this.dockerImageController.checkImage(dockerImage);
        this.setPipConflicts(project, pipConflictStr);
        this.projectFacade.update(project);
        this.projectFacade.flushEm();
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildWithCustomCommands(CondaCommands cc) throws ProjectException, ServiceDiscoveryException, ServiceException, UserException, PythonException {
        Project project = this.getProject(cc);
        File cwd = this.dockerFileController.createTmpDir(cc.getProjectId());
        boolean buildSuccess = false;
        String nextDockerImageName = this.getNextDockerImageName(project);
        try {
            String baseImage = this.projectUtils.getFullDockerImageName(project, false);
            String dockerFileName = "dockerFile_" + cc.getProjectId().getName();
            DockerFileController.BuildImageDetails customCommandsDockerFile = this.dockerFileController.installLibrary(cwd, dockerFileName, baseImage, cc);
            this.dockerImageController.buildImage(nextDockerImageName, customCommandsDockerFile.dockerFile.getAbsolutePath(), cwd, customCommandsDockerFile.dockerBuildOpts);
            this.updateProjectDockerImage(cc, nextDockerImageName);
            buildSuccess = true;
        }
        catch (Throwable throwable) {
            try {
                DistributedFileSystemOps dfso = this.dfs.getDfsOps(cc.getProjectId(), cc.getUserId());
                try {
                    String artifactDirPrefix = buildSuccess ? nextDockerImageName.substring(nextDockerImageName.lastIndexOf(":") + 1) : String.valueOf(cc.getId());
                    Path artifactPath = new Path(Utils.getProjectPath(project.getName()) + "Resources/.python/", artifactDirPrefix + "_custom_command_artifacts");
                    dfso.mkdirs(artifactPath, dfso.getParentPermission(artifactPath));
                    File commandsFile = new File(cc.getCustomCommandsFile());
                    String finalCommandsFileName = buildSuccess ? "custom_commands.sh" : cc.getCustomCommandsFile();
                    dfso.copyFromLocal(false, new Path(cwd.toString(), commandsFile.getName()), new Path(artifactPath, finalCommandsFileName));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed copy commands file for conda build: " + cc.getId(), e.getMessage());
                }
                finally {
                    this.dfs.closeDfsClient(dfso);
                }
                FileUtils.deleteDirectory((File)cwd);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed removing docker file - " + cc.getId(), e.getMessage());
            }
            throw throwable;
        }
        try {
            DistributedFileSystemOps dfso = this.dfs.getDfsOps(cc.getProjectId(), cc.getUserId());
            try {
                String artifactDirPrefix = buildSuccess ? nextDockerImageName.substring(nextDockerImageName.lastIndexOf(":") + 1) : String.valueOf(cc.getId());
                Path artifactPath = new Path(Utils.getProjectPath(project.getName()) + "Resources/.python/", artifactDirPrefix + "_custom_command_artifacts");
                dfso.mkdirs(artifactPath, dfso.getParentPermission(artifactPath));
                File commandsFile = new File(cc.getCustomCommandsFile());
                String finalCommandsFileName = buildSuccess ? "custom_commands.sh" : cc.getCustomCommandsFile();
                dfso.copyFromLocal(false, new Path(cwd.toString(), commandsFile.getName()), new Path(artifactPath, finalCommandsFileName));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed copy commands file for conda build: " + cc.getId(), e.getMessage());
            }
            finally {
                this.dfs.closeDfsClient(dfso);
            }
            FileUtils.deleteDirectory((File)cwd);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed removing docker file - " + cc.getId(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installLibrary(CondaCommands cc) throws ServiceException, ServiceDiscoveryException, ProjectException, UserException, PythonException {
        Project project = this.getProject(cc);
        File cwd = this.dockerFileController.createTmpDir(cc.getProjectId());
        try {
            String baseImage = this.projectUtils.getFullDockerImageName(project, false);
            String dockerFileName = "dockerFile_" + cc.getProjectId().getName();
            DockerFileController.BuildImageDetails installLibraryResult = this.dockerFileController.installLibrary(cwd, dockerFileName, baseImage, cc);
            String nextDockerImageName = this.getNextDockerImageName(project);
            this.dockerImageController.buildImage(nextDockerImageName, installLibraryResult.dockerFile.getAbsolutePath(), cwd, installLibraryResult.dockerBuildOpts, installLibraryResult.gitApiKeyName, installLibraryResult.gitApiToken);
            this.updateProjectDockerImage(cc, nextDockerImageName);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)cwd);
            }
            catch (IOException e) {
                String errorMsg = "Failed removing docker file";
                throw new ServiceException(RESTCodes.ServiceErrorCode.LOCAL_FILESYSTEM_ERROR, Level.INFO, errorMsg, errorMsg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallLibrary(CondaCommands cc) throws ServiceDiscoveryException, ProjectException, ServiceException, PythonException {
        Project project = this.getProject(cc);
        File cwd = this.dockerFileController.createTmpDir(cc.getProjectId());
        try {
            String fullDockerImageName = this.projectUtils.getFullDockerImageName(project, false);
            File dockerFile = this.dockerFileController.uninstallLibrary(cwd, fullDockerImageName, cc);
            String nextDockerImageName = this.getNextDockerImageName(project);
            this.dockerImageController.buildImage(nextDockerImageName, dockerFile.getAbsolutePath(), cwd);
            this.updateProjectDockerImage(cc, nextDockerImageName);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)cwd);
            }
            catch (IOException e) {
                String errorMsg = "Failed removing docker file";
                throw new ServiceException(RESTCodes.ServiceErrorCode.LOCAL_FILESYSTEM_ERROR, Level.INFO, errorMsg, errorMsg, (Throwable)e);
            }
        }
    }

    private Project getProject(CondaCommands cc) throws ProjectException {
        return this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
    }

    private String exportEnvironment(Project project, Users user) throws ServiceException, ServiceDiscoveryException {
        String dockerImage = this.projectUtils.getFullDockerImageName(project, false);
        String env = this.dockerImageController.exportImage(dockerImage);
        this.environmentController.uploadYmlInProject(project, user, env);
        this.environmentHistoryController.computeDelta(project, user);
        return env;
    }

    private void exportEnvironment(CondaCommands cc) throws ServiceException, ServiceDiscoveryException, ProjectException {
        Project project = this.getProject(cc);
        this.exportEnvironment(project, cc.getUserId());
    }

    private void syncBaseLibraries(CondaCommands cc) throws ServiceException, ServiceDiscoveryException, ProjectException, PythonException {
        Project project = this.getProject(cc);
        String dockerImage = this.projectUtils.getFullDockerImageName(project, true);
        Collection<PythonDep> projectDeps = this.getBaseImageDeps();
        if (projectDeps == null) {
            String condaListOutput = this.dockerImageController.listLibraries(dockerImage);
            projectDeps = this.libraryController.parseCondaList(condaListOutput);
            this.setBaseImageDeps(projectDeps);
        }
        project.setPythonDepCollection(projectDeps);
        String pipConflictsStr = this.getBaseImageConflictsStr();
        if (pipConflictsStr == null) {
            pipConflictsStr = this.getPipConflicts(dockerImage);
            this.setBaseImageConflictsStr(pipConflictsStr);
        }
        this.setPipConflicts(project, pipConflictsStr);
        this.projectFacade.update(project);
        String baseImageEnvYaml = this.getBaseImageEnvYaml();
        if (baseImageEnvYaml == null) {
            baseImageEnvYaml = this.exportEnvironment(project, cc.getUserId());
            this.setBaseImageEnvYaml(baseImageEnvYaml);
        } else {
            this.environmentController.uploadYmlInProject(project, cc.getUserId(), baseImageEnvYaml);
            this.environmentHistoryController.computeDelta(project, cc.getUserId());
        }
    }

    private void setPipConflicts(Project project, String conflictStr) {
        String[] lines;
        if (Strings.isNullOrEmpty((String)conflictStr)) {
            project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(false));
            project.getPythonEnvironment().setConflicts(null);
            return;
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        for (String conflictLine : lines = conflictStr.split("\n")) {
            conflicts.add(conflictLine.split("\\s+")[0].trim());
        }
        if (conflicts.isEmpty()) {
            project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(false));
            project.getPythonEnvironment().setConflicts(null);
        } else {
            project.getPythonEnvironment().setConflicts(conflictStr.substring(0, Math.min(conflictStr.length(), 12000)));
            project.getPythonEnvironment().setJupyterConflicts(Boolean.valueOf(Settings.JUPYTER_DEPENDENCIES.stream().anyMatch(conflicts::contains)));
        }
    }

    public String getPipConflicts(String dockerImage) throws PythonException, ServiceException {
        return this.dockerImageController.checkImage(dockerImage);
    }

    private String getNextDockerImageName(Project project) {
        String dockerImage = ProjectUtils.getDockerImageName(project, this.settings, false);
        int indexOfLastDigit = dockerImage.lastIndexOf(".");
        int currentVersion = Integer.parseInt(dockerImage.substring(indexOfLastDigit + 1));
        int nextVersion = currentVersion + 1;
        return dockerImage.substring(0, indexOfLastDigit) + "." + nextVersion;
    }

    private Map<Project, List<CondaCommands>> getCondaLibraryCommandsByProject(List<CondaCommands> condaCommands) {
        HashMap<Project, List<CondaCommands>> condaCommandsByProject = new HashMap<Project, List<CondaCommands>>();
        for (CondaCommands condacommand : condaCommands) {
            if (condacommand.getOp() != CondaOp.REMOVE && (condacommand.getProjectId() == null || condacommand.getProjectId().getPythonEnvironment() == null)) {
                LOG.log(Level.FINEST, "Removing condacommand: " + condacommand);
                this.condaCommandFacade.remove(condacommand);
                continue;
            }
            if (condacommand.getOp() == CondaOp.REMOVE) continue;
            Project project = condacommand.getProjectId();
            if (!condaCommandsByProject.containsKey(project)) {
                condaCommandsByProject.put(project, new ArrayList());
            }
            ((List)condaCommandsByProject.get(project)).add(condacommand);
        }
        return condaCommandsByProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() throws ServiceException, ProjectException {
        List<CondaCommands> condaCommandsRemove = this.condaCommandFacade.findByStatusAndCondaOp(CondaStatus.NEW, CondaOp.REMOVE);
        LOG.log(Level.FINE, "condaCommandsRemove: " + condaCommandsRemove);
        try {
            for (CondaCommands cc : condaCommandsRemove) {
                String projectDockerImage = cc.getArg();
                if (!this.projectUtils.dockerImageIsPreinstalled(projectDockerImage)) {
                    try {
                        this.registry.deleteProjectDockerImage(projectDockerImage);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "Could not complete docker registry cleanup for: " + cc, ex);
                        try {
                            this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.FAILED, cc.getArg(), cc.getOp(), this.errorMsg(ex, "Could not complete docker registry cleanup: "));
                        }
                        catch (ProjectException e) {
                            LOG.log(Level.WARNING, "Could not change conda command status to NEW.", e);
                        }
                    }
                }
                this.commandsController.updateCondaCommandStatus(cc.getId(), CondaStatus.SUCCESS, cc.getArg(), cc.getOp());
            }
        }
        finally {
            if (!condaCommandsRemove.isEmpty()) {
                this.registry.runRegistryGC();
            }
        }
    }

    public synchronized Collection<PythonDep> getBaseImageDeps() {
        return this.baseImageDeps;
    }

    public synchronized void setBaseImageDeps(Collection<PythonDep> baseImageDeps) {
        this.baseImageDeps = baseImageDeps;
    }

    public synchronized String getBaseImageConflictsStr() {
        return this.baseImageConflictsStr;
    }

    public synchronized void setBaseImageConflictsStr(String baseImageConflictsStr) {
        this.baseImageConflictsStr = baseImageConflictsStr;
    }

    public synchronized String getBaseImageEnvYaml() {
        return this.baseImageEnvYaml;
    }

    public synchronized void setBaseImageEnvYaml(String baseImageEnvYaml) {
        this.baseImageEnvYaml = baseImageEnvYaml;
    }

    private static class CommandsComparator<T>
    implements Comparator<T> {
        private CommandsComparator() {
        }

        @Override
        public int compare(T t, T t1) {
            if (t instanceof CondaCommands && t1 instanceof CondaCommands) {
                return this.condaCommandCompare((CondaCommands)t, (CondaCommands)t1);
            }
            if (t instanceof SystemCommand && t1 instanceof SystemCommand) {
                return this.systemCommandCompare((SystemCommand)t, (SystemCommand)t1);
            }
            return 0;
        }

        private int condaCommandCompare(CondaCommands t, CondaCommands t1) {
            int comp = t.getCreated().compareTo(t1.getCreated());
            if (comp != 0) {
                return comp;
            }
            return t.getId().compareTo(t1.getId());
        }

        private int systemCommandCompare(SystemCommand t, SystemCommand t1) {
            return t.getId().compareTo(t1.getId());
        }
    }
}

