/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.commands.search;

import io.hops.hopsworks.common.commands.CommandException;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.common.dao.commands.CommandFacade;
import io.hops.hopsworks.common.dao.commands.CommandFilter;
import io.hops.hopsworks.persistence.entity.commands.CommandStatus;
import io.hops.hopsworks.persistence.entity.commands.search.SearchFSCommand;
import io.hops.hopsworks.persistence.entity.commands.search.SearchFSCommandOp;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import javax.ejb.Stateless;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class SearchFSCommandFacade
extends CommandFacade<SearchFSCommand> {
    private static final String FEATURE_GROUP_FIELD = "featureGroup";
    private static final String FEATURE_VIEW_FIELD = "featureView";
    private static final String TRAINING_DATASET_FIELD = "trainingDataset";
    private static final String DOC_ID_FIELD = "inodeId";
    private static final String OP_FIELD = "op";

    public SearchFSCommandFacade() {
        super(SearchFSCommand.class);
    }

    @Override
    protected String getTableName() {
        return "SearchFSCommand";
    }

    public List<SearchFSCommand> findByQuery(QueryParam queryParam, Set<Integer> excludeProjects, Set<Long> excludeDocs) throws CommandException {
        if (queryParam == null) {
            throw new CommandException(RESTCodes.CommandErrorCode.INVALID_SQL_QUERY, Level.INFO, "query param is null");
        }
        String queryStrPrefix = "SELECT c FROM " + this.getTableName() + " c ";
        String queryStr = this.buildQuery(queryStrPrefix, queryParam.getFilters(), queryParam.getSorts(), "");
        if (!excludeProjects.isEmpty()) {
            queryStr = queryStr + " AND c.projectId NOT IN :exclude_projectId";
        }
        if (!excludeDocs.isEmpty()) {
            queryStr = queryStr + " AND c.inodeId NOT IN :exclude_inodeId";
        }
        TypedQuery q = this.em.createQuery(queryStr, this.entityClass);
        this.setParams((Query)q, queryParam.getFilters());
        if (queryParam.getLimit() != null) {
            q.setMaxResults(queryParam.getLimit().intValue());
        }
        if (!excludeProjects.isEmpty()) {
            q.setParameter("exclude_projectId", excludeProjects);
        }
        if (!excludeDocs.isEmpty()) {
            q.setParameter("exclude_inodeId", excludeDocs);
        }
        return q.getResultList();
    }

    public List<SearchFSCommand> findToProcess(Set<Integer> excludeProjects, Set<Long> excludeDocs, int limit) {
        UnaryOperator filterFoLive = tableName -> {
            String filter = "(";
            filter = filter + tableName + "." + FEATURE_GROUP_FIELD + " IS NOT NULL OR ";
            filter = filter + tableName + "." + FEATURE_VIEW_FIELD + " IS NOT NULL OR ";
            filter = filter + tableName + "." + TRAINING_DATASET_FIELD + " IS NOT NULL";
            filter = filter + ")";
            return filter;
        };
        return this.findToProcessInt(excludeProjects, excludeDocs, limit, filterFoLive);
    }

    public List<SearchFSCommand> findDeleteCascaded(Set<Integer> excludeProjects, Set<Long> excludeDocs, int limit) {
        UnaryOperator filterForDeleteCascaded = tableName -> {
            String filter = "(";
            filter = filter + tableName + "." + FEATURE_GROUP_FIELD + " IS NULL AND ";
            filter = filter + tableName + "." + FEATURE_VIEW_FIELD + " IS NULL AND ";
            filter = filter + tableName + "." + TRAINING_DATASET_FIELD + " IS NULL";
            filter = filter + ")";
            return filter;
        };
        return this.findToProcessInt(excludeProjects, excludeDocs, limit, filterForDeleteCascaded);
    }

    private List<SearchFSCommand> findToProcessInt(Set<Integer> excludeProjects, Set<Long> excludeDocs, int limit, UnaryOperator<String> queryAppendFilter) {
        String queryStr = "";
        queryStr = queryStr + "SELECT jc FROM " + this.getTableName() + " jc WHERE jc.id IN (";
        queryStr = queryStr + "SELECT MIN(c.id) FROM " + this.getTableName() + " c";
        queryStr = queryStr + " WHERE c.status = :status";
        queryStr = queryStr + " AND " + (String)queryAppendFilter.apply("c");
        if (!excludeProjects.isEmpty()) {
            queryStr = queryStr + " AND c.projectId NOT IN :exclude_projectId";
        }
        if (!excludeDocs.isEmpty()) {
            queryStr = queryStr + " AND c.inodeId NOT IN :exclude_inodeId";
        }
        queryStr = queryStr + " GROUP BY c.inodeId";
        queryStr = queryStr + ")";
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter("status", (Object)CommandStatus.NEW);
        if (!excludeProjects.isEmpty()) {
            query.setParameter("exclude_projectId", excludeProjects);
        }
        if (!excludeDocs.isEmpty()) {
            query.setParameter("exclude_inodeId", excludeDocs);
        }
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    protected void setParam(Query q, AbstractFacade.FilterBy filterBy) throws CommandException {
        try {
            if (filterBy.getField().equals(FEATURE_GROUP_FIELD) || filterBy.getField().equals(FEATURE_VIEW_FIELD) || filterBy.getField().equals(TRAINING_DATASET_FIELD)) {
                if (filterBy.getParam() != null) {
                    q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                }
            } else if (filterBy.getField().equals(OP_FIELD)) {
                q.setParameter(filterBy.getField(), (Object)SearchFSCommandOp.valueOf((String)filterBy.getParam()));
            } else if (filterBy.getField().equals(DOC_ID_FIELD)) {
                q.setParameter(filterBy.getField(), (Object)Long.parseLong(filterBy.getParam()));
            } else {
                super.setParam(q, filterBy);
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "invalid filter:" + filterBy.toString();
            throw new CommandException(RESTCodes.CommandErrorCode.INVALID_SQL_QUERY, Level.INFO, msg, msg, e);
        }
    }

    public static enum SearchFSFilters implements CommandFilter
    {
        FG_IS_NULL("featureGroup", "c.featureGroup IS NULL ", null),
        FG_NOT_NULL("featureGroup", "c.featureGroup IS NOT NULL ", null),
        FG_EQ("featureGroup", "c.featureGroup.id = :featureGroup", null),
        FV_IS_NULL("featureView", "c.featureView IS NULL ", null),
        FV_NOT_NULL("featureView", "c.featureView IS NOT NULL ", null),
        FV_EQ("featureView", "c.featureView.id = :featureView", null),
        TD_IS_NULL("trainingDataset", "c.trainingDataset IS NULL ", null),
        TD_NOT_NULL("trainingDataset", "c.trainingDataset IS NOT NULL ", null),
        TD_EQ("trainingDataset", "c.trainingDataset.id = :trainingDataset", null),
        DOC_EQ("inodeId", "c.inodeId = :inodeId", null),
        OP_EQ("op", "c.op = :op", SearchFSCommandOp.CREATE.name()),
        OP_NEQ("op", "c.op != :op", SearchFSCommandOp.CREATE.name());

        private final String sql;
        private final String field;
        private final String defaultParam;

        private SearchFSFilters(String field, String sql, String defaultParam) {
            this.field = field;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        @Override
        public String getDefaultParam() {
            return this.defaultParam;
        }

        @Override
        public String getValue() {
            return this.name();
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.name();
        }
    }
}

