/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterProject;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class JupyterFacade
extends AbstractFacade<JupyterProject> {
    private static final Logger LOGGER = Logger.getLogger(JupyterFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public JupyterFacade() {
        super(JupyterProject.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<JupyterProject> findByProjectUser(Project project, Users user) {
        try {
            return Optional.of(this.em.createNamedQuery("JupyterProject.findByProjectUser", JupyterProject.class).setParameter("project", (Object)project).setParameter("user", (Object)user).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public void remove(Project project, Users user) {
        try {
            JupyterProject jupyterProject = (JupyterProject)this.em.createNamedQuery("JupyterProject.findByProjectUser", JupyterProject.class).setParameter("project", (Object)project).setParameter("user", (Object)user).getSingleResult();
            this.em.remove((Object)jupyterProject);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    public List<JupyterProject> getAllNotebookServers() {
        List res = null;
        TypedQuery query = this.em.createNamedQuery("JupyterProject.findAll", JupyterProject.class);
        try {
            res = query.getResultList();
        }
        catch (EntityNotFoundException | NoResultException e) {
            LOGGER.log(Level.FINE, null, e);
            return null;
        }
        return res;
    }

    public JupyterProject saveServer(Project project, Users user, String secretConfig, int port, String token, String cid, Date expires, boolean noLimit) {
        JupyterProject jp = new JupyterProject(project, user, secretConfig, Integer.valueOf(port), token, cid, expires, noLimit);
        this.persist(jp);
        return jp;
    }

    private void persist(JupyterProject jp) {
        if (jp != null) {
            this.em.persist((Object)jp);
        }
    }
}

