/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.suites;

import io.hops.hopsworks.common.api.RestDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationDTO;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationIngestionPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ExpectationSuiteDTO
extends RestDTO<ExpectationSuiteDTO> {
    private Integer id;
    private String dataAssetType = null;
    private String expectationSuiteName;
    private List<ExpectationDTO> expectations;
    private String meta = "{\"great_expectations_version\": \"0.14.13\"}";
    private String geCloudId = null;
    private ValidationIngestionPolicy validationIngestionPolicy = ValidationIngestionPolicy.ALWAYS;
    private boolean runValidation = true;
    private Integer featureGroupId;
    private Integer featureStoreId;

    public ExpectationSuiteDTO() {
    }

    public ExpectationSuiteDTO(ExpectationSuite expectationSuite) {
        this.id = expectationSuite.getId();
        this.geCloudId = expectationSuite.getGeCloudId();
        this.dataAssetType = expectationSuite.getDataAssetType();
        this.meta = expectationSuite.getMeta();
        this.expectationSuiteName = expectationSuite.getName();
        this.validationIngestionPolicy = expectationSuite.getValidationIngestionPolicy();
        this.runValidation = expectationSuite.getRunValidation();
        this.featureGroupId = expectationSuite.getFeaturegroup().getId();
        this.featureStoreId = expectationSuite.getFeaturegroup().getFeaturestore().getId();
        ArrayList<ExpectationDTO> expectationDTOs = new ArrayList<ExpectationDTO>();
        for (Expectation expectation : expectationSuite.getExpectations()) {
            ExpectationDTO expectationDTO = new ExpectationDTO(expectation);
            expectationDTOs.add(expectationDTO);
        }
        this.expectations = expectationDTOs;
    }

    public String getExpectationSuiteName() {
        return this.expectationSuiteName;
    }

    public void setExpectationSuiteName(String expectationSuiteName) {
        this.expectationSuiteName = expectationSuiteName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getFeatureGroupId() {
        return this.featureGroupId;
    }

    public void setFeatureGroupId(Integer featureGroupId) {
        this.featureGroupId = featureGroupId;
    }

    public Integer getFeatureStoreId() {
        return this.featureStoreId;
    }

    public void setFeatureStoreId(Integer featureStoreId) {
        this.featureStoreId = featureStoreId;
    }

    public String getDataAssetType() {
        return this.dataAssetType;
    }

    public void setDataAssetType(String dataAssetType) {
        this.dataAssetType = dataAssetType;
    }

    public String getGeCloudId() {
        return this.geCloudId;
    }

    public void setGeCloudId(String geCloudId) {
        this.geCloudId = geCloudId;
    }

    public String getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public List<ExpectationDTO> getExpectations() {
        return this.expectations;
    }

    public void setExpectations(List<ExpectationDTO> expectations) {
        this.expectations = expectations;
    }

    public boolean getRunValidation() {
        return this.runValidation;
    }

    public void setRunValidation(boolean runValidation) {
        this.runValidation = runValidation;
    }

    public ValidationIngestionPolicy getValidationIngestionPolicy() {
        return this.validationIngestionPolicy;
    }

    public void setValidationIngestionPolicy(ValidationIngestionPolicy validationIngestionPolicy) {
        this.validationIngestionPolicy = validationIngestionPolicy;
    }

    public String toString() {
        return "ExpectationSuiteDTO{expectationSuiteName: " + this.expectationSuiteName + ", meta: " + this.meta + ", geCloudId:" + this.geCloudId + ", dataAssetType: " + this.dataAssetType + ", validationIngestionPolicy: " + this.validationIngestionPolicy + ", runValidation :" + this.runValidation + ", expectations:[" + this.expectations + "]}";
    }
}

