/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.online;

import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectRoleTypes;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.SecretId;
import io.hops.hopsworks.persistence.entity.user.security.secrets.VisibilityType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.RandomStringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class OnlineFeaturestoreController {
    private static final Logger LOGGER = Logger.getLogger(OnlineFeaturestoreController.class.getName());
    public static final String ONLINEFS_USERNAME = "onlinefs";
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private Settings settings;
    @EJB
    private SecretsController secretsController;
    @EJB
    private OnlineFeaturestoreFacade onlineFeaturestoreFacade;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    @EJB
    private StorageConnectorUtil storageConnectorUtil;
    @EJB
    private ProjectUtils projectUtils;

    public void setupOnlineFeaturestore(Users user, Featurestore featurestore, Connection connection) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_NOT_ENABLED, Level.FINE, "Online feature store service is not enabled for this Hopsworks instance");
        }
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        this.onlineFeaturestoreFacade.createOnlineFeaturestoreDatabase(db, connection);
        this.onlineFeaturestoreFacade.createOnlineFeaturestoreKafkaOffsetTable(db, connection);
        this.createDatabaseUser(user, featurestore, ProjectRoleTypes.DATA_OWNER.getRole(), connection);
    }

    public void createDatabaseUser(Users user, Featurestore featurestore, String projectRole, Connection connection) throws FeaturestoreException {
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(db).booleanValue()) {
            return;
        }
        String dbUser = this.onlineDbUsername(featurestore.getProject(), user);
        String onlineFsPw = this.createOnlineFeaturestoreUserSecret(dbUser, user, featurestore.getProject());
        this.onlineFeaturestoreFacade.createOnlineFeaturestoreUser(dbUser, onlineFsPw, connection);
        this.updateUserOnlineFeatureStoreDB(user, featurestore, projectRole, connection);
    }

    private String createOnlineFeaturestoreUserSecret(String dbuser, Users user, Project project) throws FeaturestoreException {
        String onlineFsPw = RandomStringUtils.randomAlphabetic((int)32);
        try {
            this.secretsController.delete(user, dbuser);
            this.secretsController.add(user, dbuser, onlineFsPw, VisibilityType.PRIVATE, project.getId());
        }
        catch (UserException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem adding online featurestore password to hopsworks secretsmgr");
        }
        return onlineFsPw;
    }

    public String onlineDbUsername(Project project, Users user) {
        return this.onlineDbUsername(project.getName(), user.getUsername());
    }

    public String getOnlineFeaturestoreDbName(Project project) {
        return project.getName().toLowerCase();
    }

    private String onlineDbUsername(String project, String user) {
        String username = project + "_" + user;
        if (username.length() > 32) {
            username = username.substring(0, 31);
        }
        return username;
    }

    public void updateUserOnlineFeatureStoreDB(Users user, Featurestore featurestore, String projectRole, Connection connection) throws FeaturestoreException {
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.settings.isOnlineFeaturestore().booleanValue() || !this.checkIfDatabaseExists(db).booleanValue()) {
            return;
        }
        String dbuser = this.onlineDbUsername(featurestore.getProject(), user);
        if (projectRole.equals(ProjectRoleTypes.DATA_OWNER.getRole())) {
            this.onlineFeaturestoreFacade.grantDataOwnerPrivileges(db, dbuser, connection);
        } else {
            this.onlineFeaturestoreFacade.grantDataScientistPrivileges(db, dbuser, connection);
        }
        try {
            this.createJdbcConnectorForOnlineFeaturestore(dbuser, featurestore, db);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createJdbcConnectorForOnlineFeaturestore(String onlineDbUsername, Featurestore featurestore, String dbName) throws FeaturestoreException {
        String connectorName = onlineDbUsername + "_onlinefeaturestore";
        if (this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, "a storage connector with that name already exists");
        }
        FeaturestoreConnector featurestoreConnector = new FeaturestoreConnector();
        featurestoreConnector.setName(connectorName);
        featurestoreConnector.setDescription("JDBC connection to Hopsworks Project Online Feature Store NDB Database for user: " + onlineDbUsername);
        featurestoreConnector.setFeaturestore(featurestore);
        featurestoreConnector.setConnectorType(FeaturestoreConnectorType.JDBC);
        FeaturestoreJdbcConnector featurestoreJdbcConnector = new FeaturestoreJdbcConnector();
        featurestoreJdbcConnector.setConnectionString(this.settings.getFeaturestoreJdbcUrl() + dbName + "?useSSL=false&allowPublicKeyRetrieval=true");
        ArrayList<OptionDTO> arguments = new ArrayList<OptionDTO>();
        arguments.add(new OptionDTO("password", "<SECRETPASSWORD>"));
        arguments.add(new OptionDTO("user", onlineDbUsername));
        arguments.add(new OptionDTO("driver", "com.mysql.cj.jdbc.Driver"));
        arguments.add(new OptionDTO("isolationLevel", "NONE"));
        arguments.add(new OptionDTO("batchsize", "500"));
        featurestoreJdbcConnector.setArguments(this.storageConnectorUtil.fromOptions(arguments));
        featurestoreConnector.setJdbcConnector(featurestoreJdbcConnector);
        this.featurestoreConnectorFacade.update(featurestoreConnector);
    }

    public void removeOnlineFeatureStore(Project project) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue() || !this.checkIfDatabaseExists(this.getOnlineFeaturestoreDbName(project)).booleanValue()) {
            return;
        }
        try (Connection connection = this.onlineFeaturestoreFacade.establishAdminConnection();){
            for (ProjectTeam member : this.projectUtils.getProjectTeamCollection(project)) {
                String dbUser = this.onlineDbUsername(project, member.getUser());
                try {
                    this.secretsController.delete(member.getUser(), dbUser);
                }
                catch (UserException e) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_ONLINE_SECRETS_ERROR, Level.SEVERE, "Problem removing user-secret to online featurestore");
                }
                this.onlineFeaturestoreFacade.removeOnlineFeaturestoreUser(dbUser, connection);
            }
            String db = this.getOnlineFeaturestoreDbName(project);
            this.onlineFeaturestoreFacade.removeOnlineFeaturestoreDatabase(db, connection);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, "Error closing connection", se.getMessage(), (Throwable)se);
        }
    }

    public void removeOnlineFeaturestoreUser(Featurestore featurestore, Users user) throws FeaturestoreException {
        String db = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(db).booleanValue()) {
            return;
        }
        String dbUser = this.onlineDbUsername(featurestore.getProject().getName(), user.getUsername());
        SecretId id = new SecretId(user.getUid(), dbUser);
        this.secretsFacade.deleteSecret(id);
        try (Connection connection = this.onlineFeaturestoreFacade.establishAdminConnection();){
            this.onlineFeaturestoreFacade.removeOnlineFeaturestoreUser(dbUser, connection);
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, "Error closing connection", se.getMessage(), (Throwable)se);
        }
        this.featurestoreConnectorFacade.deleteByFeaturestoreName(featurestore, dbUser + "_onlinefeaturestore");
    }

    public void shareOnlineFeatureStore(Project project, Featurestore featurestore, DatasetAccessPermission permission) throws FeaturestoreException {
        String featureStoreDb = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(featureStoreDb).booleanValue()) {
            return;
        }
        try (Connection connection = this.onlineFeaturestoreFacade.establishAdminConnection();){
            for (ProjectTeam member : this.projectUtils.getProjectTeamCollection(project)) {
                this.shareOnlineFeatureStoreUser(project, member.getUser(), member.getTeamRole(), featureStoreDb, permission, connection);
            }
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    public void shareOnlineFeatureStore(Project project, Users user, String role, Featurestore featurestore, DatasetAccessPermission permission, Connection conn) throws FeaturestoreException {
        String featureStoreDb = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(featureStoreDb).booleanValue()) {
            return;
        }
        this.shareOnlineFeatureStoreUser(project, user, role, featureStoreDb, permission, conn);
    }

    private void shareOnlineFeatureStoreUser(Project project, Users user, String role, String featureStoreDb, DatasetAccessPermission permission, Connection conn) throws FeaturestoreException {
        String dbUser = this.onlineDbUsername(project, user);
        if (permission == DatasetAccessPermission.READ_ONLY || permission == DatasetAccessPermission.EDITABLE_BY_OWNERS && role.equals(ProjectRoleTypes.DATA_SCIENTIST.getRole())) {
            this.onlineFeaturestoreFacade.grantDataScientistPrivileges(featureStoreDb, dbUser, conn);
        } else {
            this.onlineFeaturestoreFacade.grantDataOwnerPrivileges(featureStoreDb, dbUser, conn);
        }
    }

    public void unshareOnlineFeatureStore(Project project, Featurestore featurestore) throws FeaturestoreException {
        String featureStoreDb = this.getOnlineFeaturestoreDbName(featurestore.getProject());
        if (!this.checkIfDatabaseExists(featureStoreDb).booleanValue()) {
            return;
        }
        try (Connection connection = this.onlineFeaturestoreFacade.establishAdminConnection();){
            for (ProjectTeam member : this.projectUtils.getProjectTeamCollection(project)) {
                String dbUser = this.onlineDbUsername(project, member.getUser());
                this.onlineFeaturestoreFacade.revokeUserPrivileges(featureStoreDb, dbUser, connection);
            }
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    public Boolean checkIfDatabaseExists(String dbName) {
        return this.onlineFeaturestoreFacade.checkIfDatabaseExists(dbName);
    }
}

