/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnector;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreHopsfsConnectorController {
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetController datasetController;
    @EJB
    private Settings settings;

    public FeaturestoreHopsfsConnector createFeaturestoreHopsfsConnector(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO) throws FeaturestoreException {
        Dataset dataset = this.verifyHopsfsConnectorDatasetName(featurestoreHopsfsConnectorDTO.getDatasetName(), featurestore);
        FeaturestoreHopsfsConnector featurestoreHopsfsConnector = new FeaturestoreHopsfsConnector();
        featurestoreHopsfsConnector.setHopsfsDataset(dataset);
        return featurestoreHopsfsConnector;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreHopsfsConnector updateFeaturestoreHopsfsConnector(Featurestore featurestore, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO, FeaturestoreHopsfsConnector featurestoreHopsfsConnector) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)featurestoreHopsfsConnectorDTO.getDatasetName())) {
            Dataset dataset = this.verifyHopsfsConnectorDatasetName(featurestoreHopsfsConnectorDTO.getDatasetName(), featurestore);
            featurestoreHopsfsConnector.setHopsfsDataset(dataset);
        }
        return featurestoreHopsfsConnector;
    }

    private Dataset verifyHopsfsConnectorDatasetName(String datasetName, Featurestore featurestore) throws FeaturestoreException {
        Dataset dataset = this.datasetController.getByProjectAndDsName(featurestore.getProject(), null, datasetName);
        if (dataset == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_HOPSFS_CONNECTOR_DATASET, Level.FINE, datasetName + " could not be found in project " + featurestore.getProject().getName());
        }
        return dataset;
    }

    public FeaturestoreHopsfsConnectorDTO getHopsfsConnectorDTO(FeaturestoreConnector featurestoreConnector) {
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO(featurestoreConnector);
        featurestoreHopsfsConnectorDTO.setHopsfsPath(Utils.getDatasetPath(featurestoreConnector.getHopsfsConnector().getHopsfsDataset(), this.settings).toString());
        return featurestoreHopsfsConnectorDTO;
    }
}

