/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hosts;

import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import com.logicalclocks.servicediscoverclient.resolvers.DnsResolver;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.Utilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.NotImplementedException;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ServiceDiscoveryController {
    private static final Logger LOG = Logger.getLogger(ServiceDiscoveryController.class.getName());
    private final Map<Type, ServiceDiscoveryClient> clients = new HashMap<Type, ServiceDiscoveryClient>(1);
    @EJB
    private Settings settings;

    @PostConstruct
    public void init() {
        try {
            ServiceDiscoveryClient dnsClient = this.createClient(Type.DNS);
            this.clients.put(Type.DNS, dnsClient);
        }
        catch (ServiceDiscoveryException ex) {
            LOG.log(Level.SEVERE, "Failed to initialize Service Discovery client", ex);
        }
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry<Type, ServiceDiscoveryClient> client : this.clients.entrySet()) {
            client.getValue().close();
        }
    }

    @Lock(value=LockType.READ)
    public String constructServiceFQDN(String serviceDomain) {
        return Utilities.constructServiceFQDN((String)serviceDomain, (String)this.settings.getServiceDiscoveryDomain());
    }

    @Lock(value=LockType.READ)
    public String constructServiceFQDNWithPort(String serviceDomain) throws ServiceDiscoveryException {
        Service service = this.getAnyAddressOfServiceWithDNS(serviceDomain);
        return service.getName() + ":" + service.getPort();
    }

    @Lock(value=LockType.READ)
    public String constructServiceAddressWithPort(String serviceDomain) throws ServiceDiscoveryException {
        Service service = this.getAnyAddressOfServiceWithDNS(serviceDomain);
        return service.getAddress() + ":" + service.getPort();
    }

    @Lock(value=LockType.READ)
    public Stream<Service> getService(Type resolverType, ServiceQuery serviceQuery) throws ServiceDiscoveryException {
        ServiceDiscoveryClient client = this.getClient(resolverType);
        return client.getService(serviceQuery);
    }

    @Lock(value=LockType.READ)
    public List<Service> getAddressesOfServiceWithDNS(String serviceDomain) throws ServiceDiscoveryException {
        ServiceQuery serviceQuery = ServiceQuery.of((String)this.constructServiceFQDN(serviceDomain), Collections.emptySet());
        List<Service> services = this.getService(Type.DNS, serviceQuery).collect(Collectors.toList());
        if (services.isEmpty()) {
            throw new ServiceNotFoundException("Could not find services with: " + serviceQuery);
        }
        return services;
    }

    @Lock(value=LockType.READ)
    public Service getAnyAddressOfServiceWithDNS(String serviceDomain) throws ServiceDiscoveryException {
        ServiceQuery serviceQuery = ServiceQuery.of((String)this.constructServiceFQDN(serviceDomain), Collections.emptySet());
        Optional<Service> serviceOpt = this.getService(Type.DNS, serviceQuery).findAny();
        return serviceOpt.orElseThrow(() -> new ServiceNotFoundException("Could not find service with: " + serviceQuery));
    }

    @Lock(value=LockType.READ)
    public Service getAnyAddressOfServiceWithDNSSRVOnly(String serviceDomain) throws ServiceDiscoveryException {
        ServiceQuery serviceQuery = ServiceQuery.of((String)this.constructServiceFQDN(serviceDomain), Collections.emptySet());
        DnsResolver client = (DnsResolver)this.getClient(Type.DNS);
        Optional serviceOpt = client.getServiceSRVOnly(serviceQuery).findAny();
        return (Service)serviceOpt.orElseThrow(() -> new ServiceNotFoundException("Could not find service with: " + serviceQuery));
    }

    @Lock(value=LockType.READ)
    public String getConsulServerAddress() throws ServiceDiscoveryException {
        Service consulService = this.getAnyAddressOfServiceWithDNS(HopsworksService.CONSUL.getName());
        return consulService.getAddress();
    }

    private ServiceDiscoveryClient getClient(Type type) throws ServiceDiscoveryException {
        ServiceDiscoveryClient client = this.clients.get(type);
        if (client != null) {
            return client;
        }
        throw new ServiceDiscoveryException("Could not find initialized Service Discovery client of type " + type + " Was it initialized correctly?");
    }

    private ServiceDiscoveryClient createClient(Type type) throws ServiceDiscoveryException {
        switch (type) {
            case DNS: {
                return new Builder(type).build();
            }
            case HTTP: 
            case CACHING: {
                throw new NotImplementedException(type + " resolver is not implemented yet");
            }
        }
        throw new RuntimeException("Unknown Service Discovery resolver type: " + type);
    }
}

