/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.commands;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.python.CondaCommandFacade;
import io.hops.hopsworks.common.python.library.LibraryController;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jupyter.config.GitBackend;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CommandsController {
    private static final Logger LOGGER = Logger.getLogger(CommandsController.class.getName());
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^(.*\\[.*\\])$");
    @EJB
    private CondaCommandFacade condaCommandFacade;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private LibraryController libraryController;

    public void deleteCommands(Project project, String library) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedCommandsForProjectAndLib(project, library);
        Optional<CondaCommands> command = commands.stream().filter(d -> d.getStatus().equals((Object)CondaStatus.FAILED)).findFirst();
        if (command.isPresent()) {
            Collection projectLibs = project.getPythonDepCollection();
            projectLibs.removeIf(lib -> lib.getDependency().equals(library));
            this.projectFacade.update(project);
        }
        this.condaCommandFacade.deleteCommandsForLibrary(project, library);
    }

    public void deleteCommands(Project project) {
        this.condaCommandFacade.deleteCommandsForEnvironment(project);
    }

    public void deleteCommand(Project project, Integer commandId) throws PythonException {
        CondaCommands command = this.condaCommandFacade.getCommandsForProject(project).stream().filter(cc -> cc.getId().equals(commandId)).findFirst().orElseThrow(() -> new PythonException(RESTCodes.PythonErrorCode.CONDA_COMMAND_NOT_FOUND, Level.FINE, "Conda command with Id " + commandId + " not found"));
        if (command.getStatus().isRunning()) {
            throw new PythonException(RESTCodes.PythonErrorCode.CONDA_COMMAND_DELETE_ERROR, Level.FINE, "Cannot delete command: command is already in running state.");
        }
        if (CondaOp.isEnvOp((CondaOp)command.getOp())) {
            this.condaCommandFacade.removeCondaCommand(command.getId());
        }
    }

    public void create(CondaCommands command) {
        this.condaCommandFacade.save(command);
    }

    public void retryFailedCondaEnvOps(Project project) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedEnvCommandsForProject(project);
        for (CondaCommands cc : commands) {
            cc.setStatus(CondaStatus.NEW);
            this.condaCommandFacade.update(cc);
        }
    }

    public void retryFailedCondaLibraryOps(Project project, String library) {
        List<CondaCommands> commands = this.condaCommandFacade.getFailedCommandsForProjectAndLib(project, library);
        for (CondaCommands cc : commands) {
            cc.setStatus(CondaStatus.NEW);
            this.condaCommandFacade.update(cc);
        }
    }

    public void deleteCommandsForProject(Project proj) {
        List<CondaCommands> commands = this.condaCommandFacade.getCommandsForProject(proj);
        if (commands == null) {
            return;
        }
        commands.stream().filter(cc -> cc.getOp() != CondaOp.REMOVE).forEach(this.condaCommandFacade::remove);
    }

    public PythonDep condaOp(CondaOp op, Users user, CondaInstallType installType, Project proj, String channelUrl, String lib, String version, String arg, GitBackend gitBackend, String apiKeyName) throws GenericException, ServiceException {
        PythonDep dep;
        if (Strings.isNullOrEmpty((String)version) && CondaOp.isLibraryOp((CondaOp)op)) {
            version = "UNKNOWN";
        }
        ArrayList<CondaStatus> statuses = new ArrayList<CondaStatus>();
        statuses.add(CondaStatus.NEW);
        statuses.add(CondaStatus.ONGOING);
        List<CondaCommands> uninstallCommands = this.condaCommandFacade.findByStatusAndCondaOpAndProject(statuses, CondaOp.UNINSTALL, proj);
        List ongoingUninstall = uninstallCommands.stream().filter(c -> c.getLib().equalsIgnoreCase(lib) && c.getInstallType().equals((Object)installType)).collect(Collectors.toList());
        Optional<PythonDep> installedDep = proj.getPythonDepCollection().stream().filter(d -> d.getDependency().equalsIgnoreCase(lib) && d.getInstallType().equals((Object)installType)).findFirst();
        if (op == CondaOp.INSTALL && installedDep.isPresent() && ongoingUninstall.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_DEP_INSTALL_FORBIDDEN, Level.FINE, "dep: " + lib);
        }
        try {
            dep = this.libraryController.getOrCreateDep(channelUrl, installType, lib, version, false);
            Collection depsInProj = proj.getPythonDepCollection();
            if (op == CondaOp.INSTALL) {
                depsInProj.remove(dep);
                depsInProj.add(dep);
            }
            proj.setPythonDepCollection(depsInProj);
            this.projectFacade.update(proj);
            CondaCommands cc = new CondaCommands(user, op, CondaStatus.NEW, installType, proj, lib, version, channelUrl, arg, null, Boolean.valueOf(false), gitBackend, apiKeyName);
            this.condaCommandFacade.save(cc);
        }
        catch (Exception ex) {
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, "condaOp failed", ex.getMessage(), (Throwable)ex);
        }
        return dep;
    }

    public void updateCondaCommandStatus(int commandId, CondaStatus condaStatus, String arg, CondaOp opType) throws ProjectException {
        this.updateCondaCommandStatus(commandId, condaStatus, arg, opType, null);
    }

    public void updateCondaCommandStatus(int commandId, CondaStatus condaStatus, String arg, CondaOp opType, String errorMessage) throws ProjectException {
        CondaCommands cc = this.condaCommandFacade.findCondaCommand(commandId);
        if (cc != null) {
            if (condaStatus == CondaStatus.SUCCESS) {
                this.condaCommandFacade.remove(cc);
                if (CondaOp.isLibraryOp((CondaOp)opType)) {
                    Project project = this.projectFacade.findById(cc.getProjectId().getId()).orElseThrow(() -> new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_NOT_FOUND, Level.FINE, "projectId: " + cc.getProjectId().getId()));
                    PythonDep dep = this.libraryController.getOrCreateDep(cc.getChannelUrl(), cc.getInstallType(), cc.getLib(), cc.getVersion(), false);
                    Collection deps = project.getPythonDepCollection();
                    if (this.isPlaceholderDep(cc, opType) || opType.equals((Object)CondaOp.UNINSTALL)) {
                        deps.remove(dep);
                    }
                    project.setPythonDepCollection(deps);
                    this.projectFacade.update(project);
                    this.projectFacade.flushEm();
                }
            } else if (condaStatus == CondaStatus.FAILED) {
                cc.setStatus(condaStatus);
                cc.setArg(arg);
                cc.setErrorMsg(errorMessage);
                this.condaCommandFacade.update(cc);
                this.condaCommandFacade.flushEm();
            } else if (condaStatus == CondaStatus.ONGOING) {
                cc.setStatus(condaStatus);
                this.condaCommandFacade.update(cc);
                this.condaCommandFacade.flushEm();
            }
        } else {
            LOGGER.log(Level.FINE, "Could not remove CondaCommand with id: {0}", commandId);
        }
    }

    private boolean isPlaceholderDep(CondaCommands command, CondaOp condaOp) {
        if (command.getInstallType().equals((Object)CondaInstallType.GIT) || command.getInstallType().equals((Object)CondaInstallType.EGG) || command.getInstallType().equals((Object)CondaInstallType.WHEEL) || command.getInstallType().equals((Object)CondaInstallType.REQUIREMENTS_TXT) || command.getInstallType().equals((Object)CondaInstallType.ENVIRONMENT_YAML)) {
            return true;
        }
        Matcher bracketMatcher = BRACKET_PATTERN.matcher(command.getLib());
        return !(!condaOp.equals((Object)CondaOp.INSTALL) || !command.getInstallType().equals((Object)CondaInstallType.PIP) && !command.getInstallType().equals((Object)CondaInstallType.CONDA) || !command.getVersion().equals("UNKNOWN") && !bracketMatcher.matches());
    }

    public void failAllOngoing() {
        List<CondaCommands> targetList = this.condaCommandFacade.findByStatus(CondaStatus.ONGOING);
        targetList.forEach(cc -> {
            cc.setStatus(CondaStatus.FAILED);
            cc.setErrorMsg("Could not run conda command due to internal server error. Please try again.");
            this.condaCommandFacade.update(cc);
        });
    }
}

