/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.suites;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationController;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.greatexpectations.GreatExpectationFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.suites.ExpectationSuiteDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.suites.ExpectationSuiteFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.GreatExpectation;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ExpectationSuiteController {
    private static final Logger LOGGER = Logger.getLogger(ExpectationSuiteController.class.getName());
    @EJB
    ExpectationSuiteFacade expectationSuiteFacade;
    @EJB
    GreatExpectationFacade greatExpectationFacade;
    @EJB
    ExpectationController expectationController;
    @EJB
    FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    FeaturegroupController featuregroupController;

    public AbstractFacade.CollectionInfo<GreatExpectation> getAllGreatExpectations() {
        return this.greatExpectationFacade.findAllGreatExpectation();
    }

    public ExpectationSuite getExpectationSuite(Featuregroup featureGroup) {
        Optional<ExpectationSuite> e = this.expectationSuiteFacade.findByFeaturegroup(featureGroup);
        return e.orElse(null);
    }

    public ExpectationSuite getExpectationSuiteById(Integer expectationSuiteId) {
        Optional<ExpectationSuite> e = this.expectationSuiteFacade.findById(expectationSuiteId);
        return e.orElse(null);
    }

    public ExpectationSuite createExpectationSuite(Users user, Featuregroup featureGroup, ExpectationSuiteDTO expectationSuiteDTO) throws FeaturestoreException {
        this.verifyExpectationSuite(expectationSuiteDTO, this.featuregroupController.getFeatureNames(featureGroup, featureGroup.getFeaturestore().getProject(), user));
        ExpectationSuite expectationSuite = this.convertExpectationSuiteDTOToPersistent(featureGroup, expectationSuiteDTO);
        this.expectationSuiteFacade.persist(expectationSuite);
        this.fsActivityFacade.logExpectationSuiteActivity(user, featureGroup, expectationSuite, FeaturestoreActivityMeta.EXPECTATION_SUITE_ATTACHED, "");
        return expectationSuite;
    }

    public void deleteExpectationSuite(Users user, Featuregroup featureGroup) {
        ExpectationSuite expectationSuite = this.getExpectationSuite(featureGroup);
        if (expectationSuite != null) {
            this.expectationSuiteFacade.remove(expectationSuite);
            this.fsActivityFacade.logExpectationSuiteActivity(user, featureGroup, null, FeaturestoreActivityMeta.EXPECTATION_SUITE_DELETED, "");
        }
    }

    public ExpectationSuite convertExpectationSuiteDTOToPersistent(Featuregroup featuregroup, ExpectationSuiteDTO expectationSuiteDTO) {
        ExpectationSuite expectationSuite = this.convertExpectationSuiteMetadataDTOToPersistent(featuregroup, expectationSuiteDTO);
        ArrayList<Expectation> persistentExpectations = new ArrayList<Expectation>();
        for (ExpectationDTO dto : expectationSuiteDTO.getExpectations()) {
            persistentExpectations.add(this.expectationController.convertExpectationDTOToPersistent(expectationSuite, dto));
        }
        expectationSuite.setExpectations(persistentExpectations);
        return expectationSuite;
    }

    public ExpectationSuite convertExpectationSuiteMetadataDTOToPersistent(Featuregroup featuregroup, ExpectationSuiteDTO expectationSuiteDTO) {
        ExpectationSuite expectationSuite = new ExpectationSuite();
        expectationSuite.setFeaturegroup(featuregroup);
        expectationSuite.setMeta(expectationSuiteDTO.getMeta());
        expectationSuite.setName(expectationSuiteDTO.getExpectationSuiteName());
        expectationSuite.setValidationIngestionPolicy(expectationSuiteDTO.getValidationIngestionPolicy());
        expectationSuite.setRunValidation(expectationSuiteDTO.getRunValidation());
        expectationSuite.setDataAssetType(expectationSuiteDTO.getDataAssetType());
        expectationSuite.setGeCloudId(expectationSuiteDTO.getGeCloudId());
        return expectationSuite;
    }

    public void verifyExpectationSuite(ExpectationSuiteDTO dto, List<String> featureNames) throws FeaturestoreException {
        if (dto == null) {
            return;
        }
        this.verifyExpectationSuiteFields(dto);
        for (ExpectationDTO expectationDTO : dto.getExpectations()) {
            this.expectationController.verifyExpectationFields(expectationDTO, featureNames);
        }
    }

    private void verifyExpectationSuiteFields(ExpectationSuiteDTO dto) throws FeaturestoreException {
        this.verifyExpectationSuiteGeCloudId(dto);
        this.verifyExpectationSuiteDataAssetType(dto);
        this.verifyExpectationSuiteMeta(dto);
        this.verifyExpectationSuiteName(dto);
    }

    private void verifyExpectationSuiteName(ExpectationSuiteDTO dto) throws FeaturestoreException {
        String expectationSuiteName = dto.getExpectationSuiteName();
        if (expectationSuiteName == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Suite Name cannot be null. Pass an empty string.");
        }
        if (expectationSuiteName.length() > 63) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Name %s exceeds the max allowed character length %d.", expectationSuiteName, 63));
        }
    }

    private void verifyExpectationSuiteMeta(ExpectationSuiteDTO dto) throws FeaturestoreException {
        String meta = dto.getMeta();
        if (meta == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Suite Meta cannot be null. Pass a stringified Json.");
        }
        if (meta.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Meta field %s exceeds the max allowed character length %d.", meta, 1000));
        }
        try {
            new JSONObject(meta);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation Suite Meta field %s is not a valid json.", meta), e.getMessage());
        }
    }

    private void verifyExpectationSuiteGeCloudId(ExpectationSuiteDTO dto) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)dto.getGeCloudId()) && dto.getGeCloudId().length() > 200) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Ge Cloud Id %s exceeds the max allowed character length %d.", dto.getGeCloudId(), 200));
        }
    }

    private void verifyExpectationSuiteDataAssetType(ExpectationSuiteDTO dto) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)dto.getDataAssetType()) && dto.getDataAssetType().length() > 50) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Suite Data Asset Type %s exceeds the max allowed character length %d.", dto.getDataAssetType(), 50));
        }
    }

    public ExpectationSuite createOrUpdateExpectationSuite(Users user, Featuregroup featuregroup, ExpectationSuiteDTO expectationSuiteDTO) throws FeaturestoreException {
        this.verifyExpectationSuite(expectationSuiteDTO, this.featuregroupController.getFeatureNames(featuregroup, featuregroup.getFeaturestore().getProject(), user));
        Optional<ExpectationSuite> optionalOldExpectationSuite = this.expectationSuiteFacade.findByFeaturegroup(featuregroup);
        if (!optionalOldExpectationSuite.isPresent()) {
            return this.createExpectationSuite(user, featuregroup, expectationSuiteDTO);
        }
        return this.smartUpdateExpectationSuite(user, featuregroup, expectationSuiteDTO, optionalOldExpectationSuite.get());
    }

    public ExpectationSuite smartUpdateExpectationSuite(Users user, Featuregroup featuregroup, ExpectationSuiteDTO expectationSuiteDTO, ExpectationSuite oldExpectationSuite) throws FeaturestoreException {
        boolean logActivity = false;
        boolean verifyInput = true;
        ExpectationSuite newExpectationSuite = this.updateMetadataExpectationSuite(user, featuregroup, expectationSuiteDTO, logActivity, verifyInput);
        ArrayList<Expectation> newExpectationList = new ArrayList<Expectation>();
        verifyInput = false;
        for (ExpectationDTO expectationDTO : expectationSuiteDTO.getExpectations()) {
            newExpectationList.add(this.expectationController.createOrUpdateExpectation(user, newExpectationSuite, expectationDTO, logActivity, verifyInput));
        }
        newExpectationSuite.setExpectations(newExpectationList);
        this.deleteMissingExpectations(user, newExpectationList, oldExpectationSuite.getExpectations());
        this.fsActivityFacade.logExpectationSuiteActivity(user, featuregroup, newExpectationSuite, FeaturestoreActivityMeta.EXPECTATION_SUITE_UPDATED, "");
        return newExpectationSuite;
    }

    public ExpectationSuite updateMetadataExpectationSuite(Users user, Featuregroup featuregroup, ExpectationSuiteDTO expectationSuiteDTO, boolean logActivity, boolean verifyInput) throws FeaturestoreException {
        if (verifyInput) {
            this.verifyExpectationSuite(expectationSuiteDTO, this.featuregroupController.getFeatureNames(featuregroup, featuregroup.getFeaturestore().getProject(), user));
        }
        ExpectationSuite oldExpectationSuite = this.getExpectationSuite(featuregroup);
        ExpectationSuite expectationSuite = this.convertExpectationSuiteMetadataDTOToPersistent(featuregroup, expectationSuiteDTO);
        expectationSuite.setId(oldExpectationSuite.getId());
        expectationSuite.setExpectations(oldExpectationSuite.getExpectations());
        this.expectationSuiteFacade.updateExpectationSuite(expectationSuite);
        if (logActivity) {
            this.fsActivityFacade.logExpectationSuiteActivity(user, featuregroup, expectationSuite, FeaturestoreActivityMeta.EXPECTATION_SUITE_METADATA_UPDATED, "");
        }
        return expectationSuite;
    }

    private void deleteMissingExpectations(Users user, ArrayList<Expectation> newExpectations, Collection<Expectation> oldExpectations) {
        List newAndPreservedExpectationIds = newExpectations.stream().map(Expectation::getId).collect(Collectors.toList());
        ArrayList<Integer> missingExpectationIds = new ArrayList<Integer>();
        for (Expectation expectation : oldExpectations) {
            if (newAndPreservedExpectationIds.contains(expectation.getId())) continue;
            missingExpectationIds.add(expectation.getId());
        }
        for (Integer expectationId : missingExpectationIds) {
            this.expectationController.deleteExpectation(user, expectationId, false);
        }
    }

    public ExpectationSuite addAllExpectationIdToMetaField(ExpectationSuite expectationSuite) throws FeaturestoreException {
        ArrayList<Expectation> listOfExpectations = new ArrayList<Expectation>();
        for (Expectation expectation : expectationSuite.getExpectations()) {
            listOfExpectations.add(this.expectationController.addExpectationIdToMetaField(expectation));
        }
        expectationSuite.setExpectations(listOfExpectations);
        return expectationSuite;
    }
}

