/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.FeaturestoreDTO;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewFacade;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.hopsfs.FeaturestoreHopsfsConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.HiveTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FeaturestoreController {
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private Settings settings;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private OnlineFeaturestoreFacade onlineFeaturestoreFacade;
    @EJB
    private HiveController hiveController;
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private FeaturestoreConnectorFacade connectorFacade;
    @EJB
    private FeaturestoreStorageConnectorController featurestoreStorageConnectorController;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetController datasetController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private FeatureViewFacade featureViewFacade;

    public List<FeaturestoreDTO> getFeaturestoresForProject(Project project) throws FeaturestoreException {
        List<Featurestore> featurestores = this.getProjectFeaturestores(project);
        try {
            return featurestores.stream().map(this::convertFeaturestoreToDTO).collect(Collectors.toList());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof ServiceDiscoveryException) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public Dataset getProjectFeaturestoreDataset(Project project) throws FeaturestoreException {
        return project.getDatasetCollection().stream().filter(ds -> ds.getDsType() == DatasetType.FEATURESTORE).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.INFO, "Could not find feature store for project: " + project.getName()));
    }

    public Featurestore getProjectFeaturestore(Project project) throws FeaturestoreException {
        Collection dsInProject = project.getDatasetCollection();
        return dsInProject.stream().filter(ds -> ds.getDsType() == DatasetType.FEATURESTORE).map(Dataset::getFeatureStore).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.INFO, "Could not find feature store for project: " + project.getName()));
    }

    private List<Featurestore> getProjectFeaturestores(Project project) {
        Collection dsInProject = project.getDatasetCollection();
        dsInProject.addAll(project.getDatasetSharedWithCollection().stream().filter(DatasetSharedWith::getAccepted).map(DatasetSharedWith::getDataset).collect(Collectors.toList()));
        return dsInProject.stream().filter(ds -> ds.getDsType() == DatasetType.FEATURESTORE).map(Dataset::getFeatureStore).collect(Collectors.toList());
    }

    public FeaturestoreDTO getFeaturestoreForProjectWithName(Project project, String featurestoreName) throws FeaturestoreException {
        try {
            return this.getProjectFeaturestores(project).stream().map(this::convertFeaturestoreToDTO).filter(fs -> fs.getFeaturestoreName().equals(featurestoreName)).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreName: " + featurestoreName + " , project: " + project.getName()));
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof ServiceDiscoveryException) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public FeaturestoreDTO getFeaturestoreForProjectWithId(Project project, Integer featurestoreId) throws FeaturestoreException {
        try {
            return this.getProjectFeaturestores(project).stream().filter(fs -> fs.getId().equals(featurestoreId)).map(this::convertFeaturestoreToDTO).findAny().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreId: " + featurestoreId + " , project: " + project.getName()));
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof ServiceDiscoveryException) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Could not create Hive connection string", ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public Featurestore getFeaturestoreWithId(Integer id) throws FeaturestoreException {
        Featurestore featurestore = this.featurestoreFacade.findById(id);
        if (featurestore == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreId: " + id);
        }
        return featurestore;
    }

    public Featurestore createProjectFeatureStore(Project project, Users user, String featurestoreName, Dataset trainingDatasetsFolder) throws FeaturestoreException, ProjectException, UserException {
        Featurestore featurestore = new Featurestore();
        featurestore.setProject(project);
        featurestore.setName(project.getName().toLowerCase());
        featurestore.setCreated(new Date());
        this.featurestoreFacade.persist(featurestore);
        this.activityFacade.persistActivity(" created a new feature store named " + featurestoreName, project, project.getOwner(), ActivityFlag.SERVICE);
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + this.getOfflineFeaturestoreDbName(project), project, project.getOwner(), ActivityFlag.SERVICE);
        this.featurestoreStorageConnectorController.createStorageConnector(user, project, featurestore, this.hopsfsTrainingDatasetConnector(trainingDatasetsFolder));
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + trainingDatasetsFolder.getName(), project, project.getOwner(), ActivityFlag.SERVICE);
        this.featurestoreStorageConnectorController.createStorageConnector(user, project, featurestore, this.createOfflineJdbcConnector(featurestoreName));
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + project.getName(), project, project.getOwner(), ActivityFlag.SERVICE);
        this.createOnlineFeatureStore(project, user, featurestore);
        return featurestore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStorageConnectorResourceDirectory(Project project, Users user) throws DatasetException, HopsSecurityException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String featureStoreName = this.getOfflineFeaturestoreDbName(project);
            Path featureStoreDbPath = this.hiveController.getDbPath(featureStoreName);
            Path storageConnectorPath = new Path(featureStoreDbPath, "storage_connector_resources");
            if (!this.inodeController.existsPath(storageConnectorPath.toString())) {
                this.datasetController.createSubDirectory(project, storageConnectorPath, udfso);
            }
            this.dfs.closeDfsClient(udfso);
        }
        catch (Throwable throwable) {
            this.dfs.closeDfsClient(udfso);
            throw throwable;
        }
    }

    private void createOnlineFeatureStore(Project project, Users user, Featurestore featurestore) throws FeaturestoreException {
        if (!this.settings.isOnlineFeaturestore().booleanValue()) {
            return;
        }
        try (Connection connection = this.onlineFeaturestoreFacade.establishAdminConnection();){
            this.onlineFeaturestoreController.setupOnlineFeaturestore(user, featurestore, connection);
            for (ProjectTeam projectTeam : this.projectTeamFacade.findMembersByProject(project)) {
                if (projectTeam.getUser().equals((Object)user)) continue;
                this.onlineFeaturestoreController.createDatabaseUser(projectTeam.getUser(), featurestore, projectTeam.getTeamRole(), connection);
            }
        }
        catch (SQLException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_MYSQL_CONNECTION_TO_ONLINE_FEATURESTORE, Level.SEVERE, e.getMessage(), e.getMessage(), (Throwable)e);
        }
    }

    public FeaturestoreStorageConnectorDTO hopsfsTrainingDatasetConnector(Dataset hopsfsDataset) {
        String name = hopsfsDataset.getName();
        String description = "HOPSFS backend for storing Training Datasets of the Hopsworks Feature Store";
        FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO = new FeaturestoreHopsfsConnectorDTO();
        featurestoreHopsfsConnectorDTO.setStorageConnectorType(FeaturestoreConnectorType.HOPSFS);
        featurestoreHopsfsConnectorDTO.setName(name);
        featurestoreHopsfsConnectorDTO.setDescription(description);
        featurestoreHopsfsConnectorDTO.setDatasetName(hopsfsDataset.getName());
        return featurestoreHopsfsConnectorDTO;
    }

    public FeaturestoreStorageConnectorDTO createOfflineJdbcConnector(String databaseName) throws FeaturestoreException {
        String hiveEndpoint = "";
        try {
            hiveEndpoint = this.serviceDiscoveryController.constructServiceFQDNWithPort(HopsworksService.HIVE.getNameWithTag((ServiceTags)HiveTags.hiveserver2_tls));
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.SEVERE, "Could not create Hive connection string", e.getMessage(), (Throwable)e);
        }
        String connectionString = "jdbc:hopshive://" + hiveEndpoint + "/" + databaseName + ";auth=noSasl;ssl=true;twoWay=true;";
        List<OptionDTO> arguments = FeaturestoreConstants.OFFLINE_JDBC_CONNECTOR_ARGS.stream().map(arg -> new OptionDTO((String)arg, null)).collect(Collectors.toList());
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO();
        featurestoreJdbcConnectorDTO.setStorageConnectorType(FeaturestoreConnectorType.JDBC);
        featurestoreJdbcConnectorDTO.setName(databaseName);
        featurestoreJdbcConnectorDTO.setDescription("JDBC connector for the Offline Feature Store");
        featurestoreJdbcConnectorDTO.setConnectionString(connectionString);
        featurestoreJdbcConnectorDTO.setArguments(arguments);
        return featurestoreJdbcConnectorDTO;
    }

    public FeaturestoreDTO convertFeaturestoreToDTO(Featurestore featurestore) {
        FeaturestoreDTO featurestoreDTO = new FeaturestoreDTO(featurestore);
        String featureStoreName = this.getOfflineFeaturestoreDbName(featurestore);
        featurestoreDTO.setFeaturestoreName(featureStoreName);
        featurestoreDTO.setOfflineFeaturestoreName(featureStoreName);
        try {
            featurestoreDTO.setHiveEndpoint(this.hiveController.getHiveServerInternalEndpoint());
            if (this.settings.isOnlineFeaturestore().booleanValue() && this.onlineFeaturestoreController.checkIfDatabaseExists(this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(featurestore.getProject())).booleanValue()) {
                featurestoreDTO.setMysqlServerEndpoint(this.onlineFeaturestoreFacade.getJdbcURL());
                featurestoreDTO.setOnlineFeaturestoreName(featurestore.getProject().getName());
                featurestoreDTO.setOnlineEnabled(true);
            }
        }
        catch (ServiceDiscoveryException ex) {
            throw new RuntimeException(ex);
        }
        featurestoreDTO.setNumFeatureGroups(this.featuregroupFacade.countByFeaturestore(featurestore));
        featurestoreDTO.setNumTrainingDatasets(this.trainingDatasetFacade.countByFeaturestore(featurestore));
        featurestoreDTO.setNumStorageConnectors(this.connectorFacade.countByFeaturestore(featurestore));
        featurestoreDTO.setNumFeatureViews(this.featureViewFacade.countByFeaturestore(featurestore));
        return featurestoreDTO;
    }

    public String getOfflineFeaturestoreDbName(Project project) {
        return this.getOfflineFeaturestoreDbName(project.getName().toLowerCase());
    }

    public String getOfflineFeaturestoreDbName(Featurestore featurestore) {
        return this.getOfflineFeaturestoreDbName(featurestore.getName());
    }

    private String getOfflineFeaturestoreDbName(String name) {
        return name + "_featurestore";
    }
}

