/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.proxies.client;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpConnectionManagerBuilder {
    private Path trustStore;
    private char[] trustStorePassword;
    private Path keyStore;
    private char[] keyStorePassword;
    private char[] keyPassword;
    private TrustStrategy trustStrategy;
    private HostnameVerifier hostnameVerifier;

    public HttpConnectionManagerBuilder withTrustStore(Path trustStore, char[] trustStorePassword) {
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public HttpConnectionManagerBuilder withTrustStrategy(TrustStrategy trustStrategy) {
        this.trustStrategy = trustStrategy;
        return this;
    }

    public HttpConnectionManagerBuilder withKeyStore(Path keyStore, char[] keystorePassword, char[] keyPassword) {
        this.keyStore = keyStore;
        this.keyStorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        return this;
    }

    public HttpConnectionManagerBuilder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public Registry<ConnectionSocketFactory> build() throws IOException, GeneralSecurityException {
        if (this.trustStrategy == null) {
            this.trustStrategy = new TrustSelfSignedStrategy();
        }
        if (this.hostnameVerifier == null) {
            this.hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        }
        SSLContextBuilder sslCtxBuilder = SSLContexts.custom();
        if (this.trustStore != null) {
            sslCtxBuilder.loadTrustMaterial(this.trustStore.toFile(), this.trustStorePassword, this.trustStrategy);
        }
        if (this.keyStore != null) {
            sslCtxBuilder.loadKeyMaterial(this.keyStore.toFile(), this.keyStorePassword, this.keyPassword);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslCtxBuilder.build(), this.hostnameVerifier);
        return RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }
}

