/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.util.Settings;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Singleton
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class StagingManager {
    private static final Logger LOGGER = Logger.getLogger(StagingManager.class.getName());
    private Path hdfsStagingFolder;
    @EJB
    private Settings settings;
    @EJB
    private DistributedFsService dfs;

    @PostConstruct
    public void init() {
        this.hdfsStagingFolder = new Path(this.settings.getUploadStagingDir());
        this.createStagingDir(this.hdfsStagingFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStagingDir(Path stagingDir) {
        DistributedFileSystemOps dfsOps = null;
        try {
            boolean created;
            dfsOps = this.dfs.getDfsOps();
            if (!(dfsOps.exists(stagingDir) || this.isRootDir(stagingDir.toString()) || (created = dfsOps.mkdirs(stagingDir, dfsOps.getParentPermission(stagingDir))))) {
                LOGGER.log(Level.WARNING, "Failed to create upload staging dir. Path: {0}", stagingDir.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to create upload staging dir. Path: {0}", stagingDir.toString());
        }
        finally {
            if (dfsOps != null) {
                this.dfs.closeDfsClient(dfsOps);
            }
        }
    }

    public String getStagingPath() {
        if (this.isRootDir(this.hdfsStagingFolder.toString())) {
            return "";
        }
        if (this.hdfsStagingFolder == null || !this.hdfsStagingFolder.equals((Object)new Path(this.settings.getUploadStagingDir()))) {
            this.hdfsStagingFolder = new Path(this.settings.getUploadStagingDir());
            this.createStagingDir(this.hdfsStagingFolder);
        }
        return this.hdfsStagingFolder.toString();
    }

    private boolean isRootDir(String path) {
        return path.equals("Projects") || path.equals("/Projects");
    }
}

