/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.commands;

import io.hops.hopsworks.common.commands.CommandException;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.commands.CommandHistory;
import io.hops.hopsworks.persistence.entity.commands.CommandStatus;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

public abstract class CommandHistoryFacade<C extends CommandHistory>
extends AbstractFacade<C> {
    @PersistenceContext(unitName="kthfsPU")
    protected EntityManager em;

    protected CommandHistoryFacade(Class<C> entityClass) {
        super(entityClass);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    protected abstract String getTableName();

    public void persistAndFlush(C command) {
        this.em.persist(command);
        this.em.flush();
    }

    public void deleteOlderThan(Long intervalSeconds) throws CommandException {
        Connection connection = (Connection)this.em.unwrap(Connection.class);
        String sql = "DELETE FROM hopsworks.command_search_fs_history h WHERE h.executed < DATE_ADD(CURRENT_TIMESTAMP, INTERVAL ? SECOND)";
        int deleted = 0;
        do {
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.setLong(1, -1L * intervalSeconds);
                preparedStatement.setMaxRows(10000);
                deleted = preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "error on the command history cleanup query";
                throw new CommandException(RESTCodes.CommandErrorCode.DB_QUERY_ERROR, Level.WARNING, msg, msg, e);
            }
        } while (deleted > 0);
    }

    public long countRetries(Long id) {
        String queryStr = "SELECT COUNT(h.id) FROM " + this.getTableName() + " h WHERE h.id = :id AND h.status = :status";
        TypedQuery q = this.em.createQuery(queryStr, this.entityClass);
        q.setParameter("id", (Object)id);
        q.setParameter("status", (Object)CommandStatus.FAILED);
        return (Long)q.getSingleResult();
    }
}

