/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.python;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.history.EnvironmentDelta;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class EnvironmentHistoryFacade
extends AbstractFacade<EnvironmentHistoryFacade> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public EnvironmentHistoryFacade() {
        super(EnvironmentHistoryFacade.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<EnvironmentDelta> getPreviousBuild(Project project) {
        try {
            TypedQuery query = this.em.createNamedQuery("EnvironmentDelta.findAllForProject", EnvironmentDelta.class);
            query.setParameter("project", (Object)project);
            query.setMaxResults(1);
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<EnvironmentDelta> getAll(Project project, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Integer limit, Integer offset) {
        String historyQueryStr = this.buildQuery("SELECT e FROM EnvironmentDelta e ", filters, sorts, "e.project = :project");
        String countQueryStr = this.buildQuery("SELECT count(e.id) FROM EnvironmentDelta e ", filters, sorts, "e.project = :project");
        TypedQuery countQuery = this.em.createQuery(countQueryStr, EnvironmentDelta.class);
        countQuery.setParameter("project", (Object)project);
        TypedQuery historyQuery = this.em.createQuery(historyQueryStr, EnvironmentDelta.class);
        historyQuery.setParameter("project", (Object)project);
        this.setFilter(filters, (Query)countQuery);
        this.setFilter(filters, (Query)historyQuery);
        this.setOffsetAndLim(offset, limit, (Query)historyQuery);
        return new AbstractFacade.CollectionInfo((Long)countQuery.getSingleResult(), historyQuery.getResultList());
    }

    public Optional<EnvironmentDelta> getById(Project project, Integer id) {
        try {
            TypedQuery query = this.em.createNamedQuery("EnvironmentDelta.findById", EnvironmentDelta.class);
            query.setParameter("project", (Object)project);
            query.setParameter("id", (Object)id);
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public EnvironmentDelta create(EnvironmentDelta diff) {
        this.em.persist((Object)diff);
        this.em.flush();
        return diff;
    }

    public void deleteAll(Project project) {
        TypedQuery query = this.em.createNamedQuery("EnvironmentDelta.deleteAllForProject", EnvironmentDelta.class);
        query.setParameter("project", (Object)project);
        query.executeUpdate();
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case LIBRARY: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam().toLowerCase());
                break;
            }
        }
    }

    public static enum Filters {
        LIBRARY("LIBRARY", "(LOWER(e.installed) LIKE CONCAT('%', :library, '%') OR LOWER(e.uninstalled) LIKE CONCAT('%', :library, '%') OR LOWER(e.upgraded) LIKE CONCAT('%', :library, '%') OR LOWER(e.downgraded) LIKE CONCAT('%', :library, '%'))", "library", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "e.id ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

