/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.git.GitCommitsFacade;
import io.hops.hopsworks.common.dao.git.GitOpExecutionFacade;
import io.hops.hopsworks.common.dao.git.GitPaths;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.dao.git.GitRepositoryRemotesFacade;
import io.hops.hopsworks.common.git.AsynchronousGitCommandExecutor;
import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.git.GitCommandExecutionStateUpdateDTO;
import io.hops.hopsworks.common.git.GitJWTManager;
import io.hops.hopsworks.common.git.util.GitCommandConfigurationValidator;
import io.hops.hopsworks.common.git.util.GitCommandOperationUtil;
import io.hops.hopsworks.common.git.util.GitContainerArgumentsWriter;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandType;
import io.hops.hopsworks.persistence.entity.git.config.GitOpExecutionState;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.digest.DigestUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class GitExecutionController {
    private static final Logger LOGGER = Logger.getLogger(GitExecutionController.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private GitJWTManager gitJWTManager;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private GitOpExecutionFacade gitOpExecutionFacade;
    @EJB
    private AsynchronousGitCommandExecutor gitCommandExecutor;
    @EJB
    private GitCommandOperationUtil gitCommandOperationUtil;
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private GitCommitsFacade gitCommitsFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private GitRepositoryRemotesFacade gitRepositoryRemotesFacade;
    @EJB
    private GitCommandConfigurationValidator commandConfigurationValidator;
    @EJB
    private GitContainerArgumentsWriter argumentsWriter;
    @EJB
    private PayaraClusterManager payaraClusterManager;

    public GitOpExecution createExecution(GitCommandConfiguration gitCommandConfiguration, Project project, Users hopsworksUser, GitRepository repository) throws HopsSecurityException, GitOpException {
        this.commandConfigurationValidator.verifyReadOnly(gitCommandConfiguration.getCommandType(), repository);
        gitCommandConfiguration.setReadOnly(this.settings.getEnableGitReadOnlyRepositories());
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, hopsworksUser);
        gitCommandConfiguration.setProvider(repository.getGitProvider());
        BasicAuthSecrets authSecrets = this.gitCommandOperationUtil.getAuthenticationSecrets(hopsworksUser, repository.getGitProvider());
        this.commandConfigurationValidator.validateProviderConfiguration(authSecrets, gitCommandConfiguration);
        String configSecret = DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt()));
        this.lockRepository(repository.getId());
        GitOpExecution gitOpExecution = null;
        DistributedFileSystemOps udfso = null;
        String localMemberIp = this.payaraClusterManager.getLocalIp();
        try {
            udfso = this.dfsService.getDfsOps(hdfsUsername);
            GitPaths gitPaths = this.prepareCommandExecution(project, hopsworksUser, udfso, configSecret);
            gitOpExecution = this.gitOpExecutionFacade.create(gitCommandConfiguration, hopsworksUser, repository, configSecret, localMemberIp);
            this.argumentsWriter.createArgumentFile(gitOpExecution, gitPaths, authSecrets);
            this.gitCommandExecutor.execute(gitOpExecution, gitPaths);
            GitOpExecution gitOpExecution2 = gitOpExecution;
            return gitOpExecution2;
        }
        catch (Exception ex) {
            this.gitRepositoryFacade.updateRepositoryCid(repository, null);
            this.gitCommandOperationUtil.cleanUp(project, hopsworksUser, configSecret);
            if (ex instanceof IOException) {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.CERT_MATERIALIZATION_ERROR, Level.SEVERE, ex.getMessage(), null, (Throwable)ex);
            }
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_OPERATION_ERROR, Level.SEVERE, ex.getMessage());
        }
        finally {
            if (udfso != null) {
                this.dfsService.closeDfsClient(udfso);
            }
        }
    }

    public GitPaths prepareCommandExecution(Project project, Users hopsworksUser, DistributedFileSystemOps dfso, String configSecret) throws GitOpException, IOException {
        GitPaths gitPaths = new GitPaths(this.settings.getStagingDir() + "/private_dirs/", configSecret);
        this.gitCommandOperationUtil.generatePaths(gitPaths);
        HopsUtils.materializeCertificatesForUserCustomDir(project.getName(), hopsworksUser.getUsername(), this.settings.getHdfsTmpCertDir(), dfso, this.certificateMaterializer, this.settings, gitPaths.getCertificatesDirPath());
        this.gitJWTManager.materializeJWT(hopsworksUser, gitPaths.getTokenPath());
        return gitPaths;
    }

    private synchronized void lockRepository(Integer repositoryId) throws GitOpException {
        Optional<GitRepository> optional = this.gitRepositoryFacade.findById(repositoryId);
        if (!optional.isPresent()) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.REPOSITORY_NOT_FOUND, Level.SEVERE, "Git repository with id [" + optional + "] was not found.");
        }
        GitRepository repository = optional.get();
        if (repository.getCid() != null) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_OPERATION_ERROR, Level.WARNING, "There is another ongoing operation in the repository.");
        }
        repository.setCid(String.valueOf(System.currentTimeMillis()));
        this.gitRepositoryFacade.updateRepository(repository);
    }

    public GitOpExecution getExecutionInRepository(GitRepository repository, Integer executionId) throws GitOpException {
        Optional<GitOpExecution> executionObj = this.gitOpExecutionFacade.findByIdAndRepository(repository, executionId);
        if (!executionObj.isPresent()) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.EXECUTION_OBJECT_NOT_FOUND, Level.FINE, "Could not find execution with id " + executionId);
        }
        return executionObj.get();
    }

    public synchronized GitOpExecution updateGitExecutionState(Project project, Users hopsworksUser, GitCommandExecutionStateUpdateDTO stateDTO, Integer repositoryId, Integer executionId) throws IllegalArgumentException, GitOpException {
        GitOpExecutionState newState = stateDTO.getExecutionState();
        if (newState == null) {
            throw new IllegalArgumentException("Invalid git execution state. Execution state cannot be null.");
        }
        LOGGER.log(Level.INFO, "Updating execution, Id = " + executionId + " to " + newState.getExecutionState());
        GitRepository repository = this.commandConfigurationValidator.verifyRepository(project, hopsworksUser, repositoryId);
        GitOpExecution execution = this.getExecutionInRepository(repository, executionId);
        if (newState.isFinalState()) {
            if (newState == GitOpExecutionState.SUCCESS) {
                repository = this.finalizeSuccessfulExecution(execution, stateDTO);
            }
            if (newState == GitOpExecutionState.CANCELLED) {
                this.gitCommandExecutor.cancelGitExecution(execution, stateDTO.getMessage());
                return execution;
            }
            execution = this.getExecutionInRepository(repository, executionId);
            if (execution.getState() != GitOpExecutionState.CANCELLED) {
                this.gitRepositoryFacade.updateRepositoryCid(repository, null);
                this.gitCommandOperationUtil.cleanUp(project, hopsworksUser, execution.getConfigSecret());
            }
        }
        if (execution.getState() == GitOpExecutionState.CANCELLED) {
            return execution;
        }
        return this.gitOpExecutionFacade.updateState(execution, newState, stateDTO.getMessage());
    }

    private GitRepository finalizeSuccessfulExecution(GitOpExecution execution, GitCommandExecutionStateUpdateDTO stateDTO) {
        String remotesJson;
        GitRepository repository = execution.getRepository();
        repository.setCurrentBranch(stateDTO.getBranch());
        repository.setCurrentCommit(stateDTO.getCommitHash());
        GitRepository updateRepository = this.gitRepositoryFacade.updateRepository(repository);
        GitCommandConfiguration executedCommandConfig = execution.getGitCommandConfiguration();
        if (executedCommandConfig.getCommandType() == GitCommandType.DELETE_BRANCH) {
            this.gitCommitsFacade.deleteAllInBranchAndRepository(executedCommandConfig.getBranchName(), repository);
        }
        if (!(executedCommandConfig.getCommandType() != GitCommandType.ADD_REMOTE && executedCommandConfig.getCommandType() != GitCommandType.DELETE_REMOTE || Strings.isNullOrEmpty((String)(remotesJson = stateDTO.getMessage())))) {
            this.gitRepositoryRemotesFacade.updateRepositoryRemotes(this.gitCommandOperationUtil.convertToRemote(repository, remotesJson), repository);
        }
        return updateRepository;
    }
}

