/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.execution;

import io.hops.hopsworks.common.alert.AlertController;
import io.hops.hopsworks.common.dao.jobhistory.ExecutionFacade;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobFinalStatus;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ExecutionUpdateController {
    private static final Logger LOGGER = Logger.getLogger(ExecutionUpdateController.class.getName());
    @EJB
    private ExecutionFacade executionFacade;
    @EJB
    private AlertController alertController;

    public Execution updateProgress(float progress, Execution execution) {
        if (this.executionFacade.findById(execution.getId()).isPresent()) {
            execution = this.executionFacade.updateProgress(execution, progress);
        }
        return execution;
    }

    public Execution updateExecutionStop(long executionStop, Execution execution) {
        if (this.executionFacade.findById(execution.getId()).isPresent()) {
            execution = this.executionFacade.updateExecutionStop(execution, executionStop);
        }
        return execution;
    }

    public Execution updateState(JobState newState, Execution execution) {
        if (this.executionFacade.findById(execution.getId()).isPresent()) {
            execution = this.executionFacade.updateState(execution, newState);
        }
        return execution;
    }

    public Execution updateStateAndSendAlert(Execution execution) {
        if (this.executionFacade.findById(execution.getId()).isPresent()) {
            execution = (Execution)this.executionFacade.update(execution);
            this.alertController.sendAlert(execution.getState(), execution);
        }
        return execution;
    }

    public Execution updateFinalStatusAndSendAlert(JobFinalStatus finalStatus, Execution execution) {
        if (this.executionFacade.findById(execution.getId()).isPresent()) {
            execution = this.executionFacade.updateFinalStatus(execution, finalStatus);
            this.alertController.sendAlert(finalStatus, execution);
        }
        return execution;
    }
}

